---
title: "module lang::sdf2::\\syntax::Sdf2"
id: Sdf2
slug: /Library/lang/sdf2/syntax/Sdf2
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

#### Usage

```rascal
import lang::sdf2::\syntax::Sdf2;
```



## syntax Sort {#lang-sdf2-\syntax-Sdf2-Sort}

```rascal
lexical Sort 
  = OneChar: [A-Z] !>> [A-Za-z0-9]
  | MoreChars: ([A-Z] [A-Za-z0-9\-]* [A-Za-z0-9] !>> [A-Za-z0-9]) \ "LAYOUT" 
  ;
```

## syntax Syms {#lang-sdf2-\syntax-Sdf2-Syms}

```rascal
syntax Syms = Sym*;
```

## syntax NatCon {#lang-sdf2-\syntax-Sdf2-NatCon}

```rascal
lexical NatCon = Digits: [0-9]+ !>> [0-9];
```

## syntax NumChar {#lang-sdf2-\syntax-Sdf2-NumChar}

```rascal
lexical NumChar = Digits: [\\] [0-9]+ !>> [0-9];
```

## syntax SDF {#lang-sdf2-\syntax-Sdf2-SDF}

```rascal
start syntax SDF = Definition: "definition" Definition def;
```

## syntax Character {#lang-sdf2-\syntax-Sdf2-Character}

```rascal
syntax Character 
  = Numeric: NumChar 
  | short: ShortChar 
  | top: "\\TOP" 
  | eof: "\\EOF" 
  | bot: "\\BOT" 
  | label_start: "\\LABEL_START"
  ;
```

## syntax ShortChar {#lang-sdf2-\syntax-Sdf2-ShortChar}

```rascal
lexical ShortChar 
  = Regular: [a-zA-Z0-9] 
  | Escaped: [\\] ![A-Za-mo-qsu-z0-9] // -\0-\31
  ;
```

## syntax Renaming {#lang-sdf2-\syntax-Sdf2-Renaming}

```rascal
syntax Renaming = Sym: Sym "=\>" Sym |
                  production: Prod "=\>" Prod
                  ;
```

## syntax Renamings {#lang-sdf2-\syntax-Sdf2-Renamings}

```rascal
syntax Renamings = Renamings: "[" Renaming* "]"
                   ;
```

## syntax IdCon {#lang-sdf2-\syntax-Sdf2-IdCon}

```rascal
lexical IdCon = Default: [A-Za-z] [A-Za-z\-0-9]* !>> [A-Za-z\-0-9];
```

## syntax Class {#lang-sdf2-\syntax-Sdf2-Class}

```rascal
syntax Class 
  = SimpleCharClass: "[" Range* "]" 
  | \bracket: "(" Class ")" 
  | Comp: "~" Class 
  > Diff: Class "/" Class 
  > left ISect: Class "/\\" Class 
  > left Union: Class "\\/" Class
  ;
```

## syntax Range {#lang-sdf2-\syntax-Sdf2-Range}

```rascal
syntax Range 
  = Character 
  | Range: Character "-" Character
  ;
```

## syntax Attribute {#lang-sdf2-\syntax-Sdf2-Attribute}

```rascal
syntax Attribute = Id: "id" "(" ModuleName ")" |
                   Term: ATermAttribute |
                   Reject: "reject" |
                   Prefer: "prefer" |
                   Avoid: "avoid" |
                   Bracket: "bracket" |
                   Assoc: Assoc
                   ;
```

## syntax ATermAttribute {#lang-sdf2-\syntax-Sdf2-ATermAttribute}

```rascal
syntax ATermAttribute = Default: ATerm a  
                        \ "reject"
                        \ "prefer"
                        \ "avoid"
                        \ "bracket"
                        ;
```

## syntax Attrs {#lang-sdf2-\syntax-Sdf2-Attrs}

```rascal
syntax Attrs = Attrs: "{" {Attribute ","}* "}" |
                    NoAttrs: 
                    ;
```

## syntax Prod {#lang-sdf2-\syntax-Sdf2-Prod}

```rascal
syntax Prod = Prod: Syms "-\>" Sym Attrs ;
```

## syntax Prods {#lang-sdf2-\syntax-Sdf2-Prods}

```rascal
syntax Prods = Prod*;
```

## syntax Grammar {#lang-sdf2-\syntax-Sdf2-Grammar}

```rascal
syntax Grammar = Aliases: "aliases" Aliases |
                 Sorts: "sorts" Syms |
                 ImpSection: ImpSection |
                 Syntax: "syntax" Prods |
                 KernalStartSyms: "start-symbols" Syms |
                 Variables: "variables" Prods |
                 Priorities: "priorities" Priorities |
                 Restrictions: "restrictions" Restrictions |
                 LexicalSyntax: "lexical" "syntax" Prods |
                 LexicalStartSyms: "lexical" "start-symbols" Syms |
                 LexicalVariables: "lexical" "variables" Prods |
                 LexicalPriorities: "lexical" "priorities" Priorities |
                 LexicalRestrictions: "lexical" "restrictions" Restrictions |
                 ContextFreeSyntax: "context-free" "syntax" Prods |
                 ContextFreeStartSyms: "context-free" "start-symbols" Syms |
                 ContextFreePriorities: "context-free" "priorities" Priorities |
                 ContextFreeRestrictions: "context-free" "restrictions" Restrictions 
                 ;
```

## syntax Label {#lang-sdf2-\syntax-Sdf2-Label}

```rascal
syntax Label = Quoted: StrCon |
               IdCon: IdCon
               \ "left"
               \ "right"
               \ "assoc"
               \ "non-assoc"
               ;
```

## syntax Sym {#lang-sdf2-\syntax-Sdf2-Sym}

```rascal
syntax Sym = Sort: Sort |
                Lit: StrCon |
                CILit: SingleQuotedStrCon |
                Class: Class |
                Layout: "LAYOUT" |
                Empty: "(" ")" |
                Bracket: "(" Sym ")" |
                Seq: "(" Sym Sym+ ")" |
                Opt: Sym "?" |
                Iter: Sym "+" |
                IterStar: Sym "*" |
                IterSep: "{" Sym Sym "}" "+" |
                IterStarSep: "{" Sym Sym "}" "*" |
                CF: "\<" Sym "-CF" "\>" |
                Lex: "\<" Sym "-LEX" "\>" |
                Varsym: "\<" Sym "-VAR" "\>" |
                ParameterizedSort: Sort "[[" {Sym ","}+ "]]" >
                right Alt: Sym "|" Sym >
                Label: Label ":" Sym
                ;
```

## syntax LAYOUTLIST {#lang-sdf2-\syntax-Sdf2-LAYOUTLIST}

```rascal
layout LAYOUTLIST = LAYOUT* !>> [\ \t\n\r%]
                    ;
```

## syntax LAYOUT {#lang-sdf2-\syntax-Sdf2-LAYOUT}

```rascal
lexical LAYOUT = Whitespace: [\ \t\n\r] |
                 @category="comment" Line: "%%" ![\n]* [\n] |
                 @category="comment" Nested: "%" ![%\n] "%"
                ;
```

## syntax Alias {#lang-sdf2-\syntax-Sdf2-Alias}

```rascal
syntax Alias = Alias: Sym "-\>" Sym
               ;
```

## syntax Aliases {#lang-sdf2-\syntax-Sdf2-Aliases}

```rascal
syntax Aliases = Alias*
                 ;
```

## syntax StrChar {#lang-sdf2-\syntax-Sdf2-StrChar}

```rascal
lexical StrChar = NewLine: [\\] [n] 
                | Tab: [\\] [t] 
                | Quote: [\\] [\"] 
                |  Backslash: [\\] [\\] 
                |  Decimal: [\\] [0-9] [0-9] [0-9] 
                |  Normal: ![\n\t\"\\] 
                ;
```

## syntax StrCon {#lang-sdf2-\syntax-Sdf2-StrCon}

```rascal
lexical StrCon = Default: [\"] StrChar* [\"]
                ;
```

## syntax FunctionName {#lang-sdf2-\syntax-Sdf2-FunctionName}

```rascal
syntax FunctionName = UnquotedFun: IdCon |
                      QuotedFun: StrCon
                      ;
```

## syntax SingleQuotedStrCon {#lang-sdf2-\syntax-Sdf2-SingleQuotedStrCon}

```rascal
lexical SingleQuotedStrCon = Default: [\'] SingleQuotedStrChar* [\']
                            ;
```

## syntax SingleQuotedStrChar {#lang-sdf2-\syntax-Sdf2-SingleQuotedStrChar}

```rascal
lexical SingleQuotedStrChar = NewLine: [\\] [n] | 
                              Tab: [\\] [t] | 
                              Quote: [\\] [\'] | 
                              Backslash: [\\] [\\] | 
                              Decimal: [\\] [0-9] [0-9] [0-9] | 
                              Normal: ![\n\t\'\\] 
                             ;
```

## syntax RealCon {#lang-sdf2-\syntax-Sdf2-RealCon}

```rascal
syntax RealCon = RealCon: IntCon "." NatCon OptExp
                 ;
```

## syntax OptExp {#lang-sdf2-\syntax-Sdf2-OptExp}

```rascal
syntax OptExp = Present: "e" IntCon |
                Absent: 
                ;
```

## syntax Module {#lang-sdf2-\syntax-Sdf2-Module}

```rascal
start syntax Module = Module: "module" ModuleName ImpSection* Sections
                      ;
```

## syntax ModuleName {#lang-sdf2-\syntax-Sdf2-ModuleName}

```rascal
syntax ModuleName = Unparameterized: ModuleId id 
                    \ "aliases"
                    \ "lexical"
                    \ "priorities"
                    \ "context-free"
                    \ "definition"
                    \ "syntax"
                    \ "variables"
                    \ "module"
                    \ "imports"
                    \ "exports"
                    \ "hiddens"
                    \ "left"
                    \ "right"
                    \ "assoc"
                    \ "non-assoc"
                    \ "bracket"
                    \ "sorts"
                    \ "restrictions"
                    !>> [A-Za-z0-9_\-]
                  | Parameterized: ModuleId id "[" Syms actuals "]"  
                    ;
```

## syntax ModuleWord {#lang-sdf2-\syntax-Sdf2-ModuleWord}

```rascal
lexical ModuleWord = Word: [A-Za-z0-9_\-]+
                    !>> [A-Za-z0-9_\-]
                    ;
```

## syntax ModuleId {#lang-sdf2-\syntax-Sdf2-ModuleId}

```rascal
lexical ModuleId =  Leaf: ModuleWord !>> [/] |
                   Root: "/" ModuleId |
                   Path: ModuleWord "/" ModuleId
                  ;
```

## syntax Import {#lang-sdf2-\syntax-Sdf2-Import}

```rascal
syntax Import = Module: ModuleName |
                RenamedModule: ModuleName Renamings |
                Bracket: "(" Import ")"
                ;
```

## syntax Imports {#lang-sdf2-\syntax-Sdf2-Imports}

```rascal
syntax Imports = Import*
                 ;
```

## syntax Section {#lang-sdf2-\syntax-Sdf2-Section}

```rascal
syntax Section = Exports: "exports" Grammar* |
                 Hiddens: "hiddens" Grammar*
                 ;
```

## syntax Sections {#lang-sdf2-\syntax-Sdf2-Sections}

```rascal
syntax Sections = Section*
                  ;
```

## syntax ImpSection {#lang-sdf2-\syntax-Sdf2-ImpSection}

```rascal
syntax ImpSection = Imports: "imports" Imports
                    ;
```

## syntax Definition {#lang-sdf2-\syntax-Sdf2-Definition}

```rascal
syntax Definition = Module* modules
                    ;
```

## syntax Lookahead {#lang-sdf2-\syntax-Sdf2-Lookahead}

```rascal
syntax Lookahead 
 = Class: Class!bracket class
 | Seq: Class class "." Lookaheads!alt las 
 ;
```

## syntax Lookaheads {#lang-sdf2-\syntax-Sdf2-Lookaheads}

```rascal
syntax Lookaheads 
  = Single: Lookahead 
  | right alt: Lookaheads "|" Lookaheads 
  | Bracket: "(" Lookaheads ")" 
  | List: "[[" {Lookahead ","}* "]]"
  ;
```

## syntax Restriction {#lang-sdf2-\syntax-Sdf2-Restriction}

```rascal
syntax Restriction = Follow: Syms "-/-" Lookaheads
                     ;
```

## syntax Assoc {#lang-sdf2-\syntax-Sdf2-Assoc}

```rascal
syntax Assoc = Left: "left" |
                       Right: "right" |
                       NonAssoc: "non-assoc" |
                       Assoc: "assoc"
                       ;
```

## syntax Restrictions {#lang-sdf2-\syntax-Sdf2-Restrictions}

```rascal
syntax Restrictions = Default: Restriction* ;
```

## syntax ArgumentIndicator {#lang-sdf2-\syntax-Sdf2-ArgumentIndicator}

```rascal
syntax ArgumentIndicator = Default: "\<" {NatCon ","}+ "\>"
                           ;
```

## syntax Group {#lang-sdf2-\syntax-Sdf2-Group}

```rascal
syntax Group = non-assoc WithArguments: Group ArgumentIndicator |
               non-assoc NonTransitive: Group "." |
               ProdsGroup: "{" Prods "}" |
               AssocGroup: "{" Assoc ":" Prods "}" |
               SimpleGroup: Prod
               ;
```

## syntax Priority {#lang-sdf2-\syntax-Sdf2-Priority}

```rascal
syntax Priority = Chain: {Group "\>"}+ |
                  Assoc: Group Assoc Group
                  ;
```

## syntax Priorities {#lang-sdf2-\syntax-Sdf2-Priorities}

```rascal
syntax Priorities = {Priority ","}*
                    ;
```

## syntax AFun {#lang-sdf2-\syntax-Sdf2-AFun}

```rascal
syntax AFun = Quoted: StrCon |
              Unquoted: IdCon
              \ "left" 
              \ "right" 
              \ "assoc" 
              \ "non-assoc"
              ;
```

## syntax ATerm {#lang-sdf2-\syntax-Sdf2-ATerm}

```rascal
syntax ATerm = Int: IntCon |
               Real: RealCon |
               Fun: AFun |
               Appl: AFun "(" {ATerm ","}+ ")" |
               Placeholder: "\<" ATerm "\>" |
               List: "[" {ATerm ","}* "]" |
               Annotated: ATerm Annotation
               ;
```

## syntax Annotation {#lang-sdf2-\syntax-Sdf2-Annotation}

```rascal
syntax Annotation = Default: "{" {ATerm ","}+ "}"
                    ;
```

## syntax IntCon {#lang-sdf2-\syntax-Sdf2-IntCon}

```rascal
syntax IntCon = Natural: NatCon |
                Positive: "+" NatCon |
                Negative: "-" NatCon
                ;
```

