---
title: "module lang::sdf2::util::Importer"
id: Importer
slug: /Library/lang/sdf2/util/Importer
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

#### Usage

```rascal
import lang::sdf2::util::Importer;
```

#### Dependencies
```rascal
import lang::sdf2::util::Load;
import lang::sdf2::util::SDF2Grammar;
import lang::rascal::format::Grammar;
import lang::rascal::grammar::definition::Modules;
import util::Reflective;
```


## function generate {#lang-sdf2-util-Importer-generate}

Converts an SDF2 module to a Rascal module

```rascal
str generate(str name, loc at, PathConfig pcfg)
```


The `sdf` uri scheme works like this:
`sdf:///<modulename>`

The default Rascal search path is used to resolve the 
module name to a file with the `.sdf2` extension. 

The module name is expected to be in SDF2 syntax.

If modules are "imported" by the given top module,
then these names are resolved recursively and a 
"definition" composed of all relative modules is
collected before the translation process starts.
All of the syntax rules in all of the SDF2 modules 
end up in one Rascal module.

