---
title: "module lang::smtlib2::theory::core::Ast"
id: Ast
slug: /Library/lang/smtlib2/theory/core/Ast
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

Synopsis: AST for the SMTLIBv2 Core theory (boolean logic)
#### Usage

```rascal
import lang::smtlib2::theory::core::Ast;
```



## data Sort {#lang-smtlib2-theory-core-Ast-Sort}

```rascal
data Sort  
     = \bool()
     ;
```

## data Expr {#lang-smtlib2-theory-core-Ast-Expr}

```rascal
data Expr  
     = \not(Expr val)
     | implies(Expr lhs, Expr rhs)
     | and(Expr lhs, Expr rhs)
     | or(Expr lhs, Expr rhs)
     | xor(Expr lhs, Expr rhs)
     | eq(Expr lhs, Expr rhs)
     | distinct(Expr lhs, Expr rhs)
     | ite(Expr condition, Expr whenTrue, Expr whenFalse)
     ;
```

## data Literal {#lang-smtlib2-theory-core-Ast-Literal}

```rascal
data Literal  
     = boolVal(bool b)
     ;
```

