---
title: "module lang::uri::\\syntax::RFC3986"
id: RFC3986
slug: /Library/lang/uri/syntax/RFC3986
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

#### Usage

```rascal
import lang::uri::\syntax::RFC3986;
```



## syntax Top {#lang-uri-\syntax-RFC3986-Top}

```rascal
start syntax Top = URI;
```

## syntax URI {#lang-uri-\syntax-RFC3986-URI}

```rascal
lexical URI = Scheme scheme ":" HierPart ("?" Query)? ("#" Fragment)?;
```

## syntax PctEncoded {#lang-uri-\syntax-RFC3986-PctEncoded}

```rascal
lexical PctEncoded = "%" [A-Fa-f0-9] [A-Fa-f0-9];
```

## syntax Reserved {#lang-uri-\syntax-RFC3986-Reserved}

```rascal
lexical Reserved = GenDelims | SubDelims;
```

## syntax GenDelims {#lang-uri-\syntax-RFC3986-GenDelims}

```rascal
lexical GenDelims = [:/?#\[\]@];
```

## syntax SubDelims {#lang-uri-\syntax-RFC3986-SubDelims}

```rascal
lexical SubDelims = [!$&\'()*+,;=];
```

## syntax Unreserved {#lang-uri-\syntax-RFC3986-Unreserved}

```rascal
lexical Unreserved = [A-Za-z0-9\-._~];
```

## syntax HierPart {#lang-uri-\syntax-RFC3986-HierPart}

```rascal
lexical HierPart 
  = "//" Authority PathAbEmpty
  | PathAbsolute
  | PathRootless
  | PathEmpty
  ;
```

## syntax Scheme {#lang-uri-\syntax-RFC3986-Scheme}

```rascal
lexical Scheme = [A-Za-z] [A-Za-z0-9+\-.]*;
```

## syntax Authority {#lang-uri-\syntax-RFC3986-Authority}

```rascal
lexical Authority = (Userinfo "@")? Host (":" Port)?;
```

## syntax Userinfo {#lang-uri-\syntax-RFC3986-Userinfo}

```rascal
lexical Userinfo = (Unreserved | PctEncoded | SubDelims | ":")*;
```

## syntax Host {#lang-uri-\syntax-RFC3986-Host}

```rascal
lexical Host = IPLiteral | IPv4Address | RegName;
```

## syntax IPLiteral {#lang-uri-\syntax-RFC3986-IPLiteral}

```rascal
lexical IPLiteral = "[" (IPv6addres | IPvFuture) "]";
```

## syntax IPvFuture {#lang-uri-\syntax-RFC3986-IPvFuture}

```rascal
lexical IPvFuture = "v" [A-Fa-f0-9]+ "." (Unreserved | SubDelims | ":")+;
```

## syntax IPv6addres {#lang-uri-\syntax-RFC3986-IPv6addres}

```rascal
lexical IPv6addres 
  = H16 ":" H16 ":" H16 ":" H16 ":" H16 ":" H16 ":" LS32
  | "::" H16 ":" H16 ":" H16 ":" H16 ":" H16 ":" LS32
  | H16? "::" H16 ":" H16 ":" H16 ":" H16 ":" LS32
  | (H16 ":" H16)? "::" H16 ":" H16 ":" H16 ":" LS32
  | (H16 ":" H16 ":" H16)? "::" H16 ":" H16 ":" LS32
  | (H16 ":" H16 ":" H16 ":" H16)? "::" H16 ":" LS32
  | (H16 ":" H16 ":" H16 ":" H16 ":" H16)? "::" LS32
  | (H16 ":" H16 ":" H16 ":" H16 ":" H16 ":" H16)? "::" H16 
  | (H16 ":" H16 ":" H16 ":" H16 ":" H16 ":" H16 ":" H16)? "::"  
  ;
```

## syntax LS32 {#lang-uri-\syntax-RFC3986-LS32}

```rascal
lexical LS32 = H16 ":" H16 | IPv4Address;
```

## syntax H16 {#lang-uri-\syntax-RFC3986-H16}

```rascal
lexical H16 = [A-Fa-f0-9] [A-Fa-f0-9] [A-Fa-f0-9] [A-Fa-f0-9] ;
```

## syntax IPv4Address {#lang-uri-\syntax-RFC3986-IPv4Address}

```rascal
lexical IPv4Address = DecOctet "." DecOctet "." DecOctet "." DecOctet;
```

## syntax DecOctet {#lang-uri-\syntax-RFC3986-DecOctet}

```rascal
lexical DecOctet 
  = [0-9]
  | [1-9] [0-9]
  | "1" [0-9] [0-9]
  | "2" [0-4] [0-9]
  | "25" [0-5]
  ;
```

## syntax RegName {#lang-uri-\syntax-RFC3986-RegName}

```rascal
lexical RegName = (Unreserved | PctEncoded | SubDelims)*;
```

## syntax Port {#lang-uri-\syntax-RFC3986-Port}

```rascal
lexical Port = [0-9]*;
```

## syntax Path {#lang-uri-\syntax-RFC3986-Path}

```rascal
lexical Path 
  = PathAbEmpty
  | PathAbsolute
  | PathNoScheme
  | PathRootless
  | PathEmpty
  ;
```

## syntax PathAbEmpty {#lang-uri-\syntax-RFC3986-PathAbEmpty}

```rascal
lexical PathAbEmpty = ("/" Segment)*;
```

## syntax PathAbsolute {#lang-uri-\syntax-RFC3986-PathAbsolute}

```rascal
lexical PathAbsolute = "/" (SegmentNz ("/" Segment)*)? ;
```

## syntax PathNoScheme {#lang-uri-\syntax-RFC3986-PathNoScheme}

```rascal
lexical PathNoScheme = SegmentNzNc ("/" Segment)*;
```

## syntax PathRootless {#lang-uri-\syntax-RFC3986-PathRootless}

```rascal
lexical PathRootless = SegmentNz ("/" Segment)*;
```

## syntax PathEmpty {#lang-uri-\syntax-RFC3986-PathEmpty}

```rascal
lexical PathEmpty = ;
```

## syntax Segment {#lang-uri-\syntax-RFC3986-Segment}

```rascal
lexical Segment = Pchar*;
```

## syntax SegmentNz {#lang-uri-\syntax-RFC3986-SegmentNz}

```rascal
lexical SegmentNz = Pchar+;
```

## syntax SegmentNzNc {#lang-uri-\syntax-RFC3986-SegmentNzNc}

```rascal
lexical SegmentNzNc = (Unreserved | PctEncoded | SubDelims | "@")+;
```

## syntax Pchar {#lang-uri-\syntax-RFC3986-Pchar}

```rascal
lexical Pchar = Unreserved | PctEncoded | SubDelims | ":" | "@";
```

## syntax Query {#lang-uri-\syntax-RFC3986-Query}

```rascal
lexical Query = (Pchar | "/" | "?")*;
```

## syntax Fragment {#lang-uri-\syntax-RFC3986-Fragment}

```rascal
lexical Fragment = (Pchar | "/" | "?")*;
```

