---
title: "module lang::yaml::Model"
id: Model
slug: /Library/lang/yaml/Model
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

AST model for YAML (loosely based on the serialization model of <http://www.yaml.org/spec/1.2/spec.html>)
#### Usage

```rascal
import lang::yaml::Model;
```

#### Dependencies
```rascal
import List;
import Map;
import Set;
```


## data Node {#lang-yaml-Model-Node}
Generic representation for YAML nodes

```rascal
data Node (int anchor=-1, type[value] \tag = #void) 
     = sequence(list[Node] \list)
     | scalar(value \value)
     | reference()
     | mapping(map[Node, Node] \map)
     ;
```


Tagging (using the `\tag` field) will be used to do typed 
serialization for ADTs in the future.
 
In valid YAML anchors always occur before any references
this should also hold in our YAML data type.
Dumping will throw index out of bound exception if references
are out of order.

Anchors are only currently valid on seq/map nodes.
and should be unique.

## function loadYAML {#lang-yaml-Model-loadYAML}

```rascal
Node loadYAML(str src)
```

## function dumpYAML {#lang-yaml-Model-dumpYAML}

```rascal
str dumpYAML(Node yaml)
```

## function checkYAML {#lang-yaml-Model-checkYAML}

```rascal
set[str] checkYAML(Node n)
```

## function badAnchors {#lang-yaml-Model-badAnchors}

```rascal
set[Node] badAnchors(Node n)
```

## function wronglyTypedScalars {#lang-yaml-Model-wronglyTypedScalars}

```rascal
set[Node] wronglyTypedScalars(Node n)
```

## function okValue {#lang-yaml-Model-okValue}

```rascal
bool okValue(type[&T <: value] _, value v)
```

## function unsupportedTypes {#lang-yaml-Model-unsupportedTypes}

```rascal
set[type[value]] unsupportedTypes(Node n)
```

## function untaggedScalars {#lang-yaml-Model-untaggedScalars}

```rascal
set[Node] untaggedScalars(Node n)
```

## function duplicateAnchors {#lang-yaml-Model-duplicateAnchors}

```rascal
set[int] duplicateAnchors(Node n)
```

## function undefinedRefs {#lang-yaml-Model-undefinedRefs}

```rascal
tuple[set[int], set[int]] undefinedRefs(reference(anchor=i), set[int] seen, set[int] dupl)

tuple[set[int], set[int]] undefinedRefs(s:sequence(ns), set[int] seen, set[int] dupl)

tuple[set[int], set[int]] undefinedRefs(nod:mapping(m), set[int] seen, set[int] dupl)

default tuple[set[int], set[int]] undefinedRefs(Node n, set[int] seen, set[int] dupl)
```

## function equalNodes {#lang-yaml-Model-equalNodes}

```rascal
bool equalNodes(Node x, Node y)
```

# Tests
## test testLoadDump {#lang-yaml-Model-testLoadDump}

```rascal
public test bool testLoadDump() {
  Node n = loadYAML(TEST_YAML);
  str y = dumpYAML(n);
  return equalNodes(n, loadYAML(y));
}
```

