---
title: "module util::Maybe"
id: Maybe
slug: /Library/util/Maybe
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

Encapsulate any optional value using `Maybe[&T]`
#### Usage

```rascal
import util::Maybe;
```



## data Maybe {#util-Maybe-Maybe}
Generic data type to encapsulate any value, optionally.

```rascal
data Maybe[&A]  
     = nothing()
     | just(&A val)
     ;
```

#### Examples



```rascal-shell 
rascal>import util::Maybe;
ok
```
nothing() can always be assigned to a variable of type `Maybe[Anytype]`
```rascal-shell
rascal>Maybe[int] myIntOption = nothing();
Maybe[int]: nothing()
```
another example of the same feature:
```rascal-shell
rascal>Maybe[str] myStrOption = nothing();
Maybe[str]: nothing()
```
if you do have a value, the type of the parameter of `just` must align:
```rascal-shell
rascal>myStrOption = just("a string");
Maybe[str]: just("a string")
```

If you don't align the type of the parameter with the parameter type of `Maybe`, static errors ensue:

```rascal-shell -continue-error
rascal>myStrOption = just(42);
|prompt:///|(19,2,<1,19>,<1,21>): Expected Maybe[str], but got Maybe[int]
Advice: |https://www.rascal-mpl.org/docs/Rascal/Errors/CompileTimeErrors/UnexpectedType|
```

Here's a function that sometimes returns a value and otherwise returns `nothing()`:
```rascal
Maybe[int] indexOf(list[int] haystack, int needle) {
   for (i <- index(haystack), haystack[i] == needle) {
      return just(i);
   }
   
   return nothing();
}
```

