---
title: "module util::SemVer"
id: SemVer
slug: /Library/util/SemVer
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

#### Usage

```rascal
import util::SemVer;
```



## function satisfiesVersion {#util-SemVer-satisfiesVersion}

Semantic Versioning

```rascal
bool satisfiesVersion(str version, str rangeSet)
```


Check that a given version string satisfies a range-set as defined by:
(See https://github.com/npm/node-semver):
``````
range-set  ::= range ( logical-or range ) *
logical-or ::= ( ' ' ) * '||' ( ' ' ) *
range      ::= hyphen | simple ( ' ' simple ) * | ''
hyphen     ::= partial ' - ' partial
simple     ::= primitive | partial | tilde | caret
primitive  ::= ( '<' | '>' | '>=' | '<=' | '=' | ) partial
partial    ::= xr ( '.' xr ( '.' xr qualifier ? )? )?
xr         ::= 'x' | 'X' | '*' | nr
nr         ::= '0' | ['1'-'9'] ( ['0'-'9'] ) *
tilde      ::= '~' partial
caret      ::= '^' partial
qualifier  ::= ( '-' pre )? ( '+' build )?
pre        ::= parts
build      ::= parts
parts      ::= part ( '.' part ) *
part       ::= nr | [-0-9A-Za-z]+
``````

## function lessVersion {#util-SemVer-lessVersion}

```rascal
bool lessVersion(str version1, str version2)
```

## function lessEqualVersion {#util-SemVer-lessEqualVersion}

```rascal
bool lessEqualVersion(str version1, str version2)
```

## function greaterVersion {#util-SemVer-greaterVersion}

```rascal
bool greaterVersion(str version1, str version2)
```

## function greaterEqualVersion {#util-SemVer-greaterEqualVersion}

```rascal
bool greaterEqualVersion(str version1, str version2)
```

## function equalVersion {#util-SemVer-equalVersion}

```rascal
bool equalVersion(str version1, str version2)
```

## function getRascalVersion {#util-SemVer-getRascalVersion}

```rascal
str getRascalVersion()
```

## function getRascalRuntimeVersion {#util-SemVer-getRascalRuntimeVersion}

```rascal
str getRascalRuntimeVersion()
```

## function getRascalCompilerVersion {#util-SemVer-getRascalCompilerVersion}

```rascal
str getRascalCompilerVersion()
```

## function getJavaRuntimeVersion {#util-SemVer-getJavaRuntimeVersion}

```rascal
str getJavaRuntimeVersion()
```

