---
title: "module util::ShellExec"
id: ShellExec
slug: /Library/util/ShellExec
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

Execute and manage external processes.
#### Usage

```rascal
import util::ShellExec;
```



## function createProcess {#util-ShellExec-createProcess}

Start a new external process.

```rascal
PID createProcess(str processCommand, loc workingDir=|cwd:///|, list[str] args = [], map[str,str] envVars = ())
```

## function createProcess {#util-ShellExec-createProcess}

Start a new external process.

```rascal
PID createProcess(loc processCommand, loc workingDir=|cwd:///|, list[value] args = [], map[str, value] envVars = ())
```


The file schemes that are allowed for the `processCommand` are limited to the `file:///` schemes
and all logical schemes that directly resolve to `file:///` such as `cwd:///` and `tmp:///`.
`PATH:///` is also a handy scheme for `processCommand` since it searches for the binary/script
in the underlying system's search path.

The arguments to `args` given are all converted to strings before passing them into the command.
Special treatment is given to `loc` arguments, which are first resolved to `file:///` schemes and
then printed to OS-specific absolute path names.

For environment variables in `envVars` the same treatment is given to convert values to strings.

## function exec {#util-ShellExec-exec}

start, run and kill an external process returning its output as a string.

```rascal
str exec(str processCommand, loc workingDir=|cwd:///|, list[str] args = [], map[str, str] env = ())
```

## function exec {#util-ShellExec-exec}

start, run and kill an external process returning its output as a string.

```rascal
str exec(loc processCommand, loc workingDir=|cwd:///|, list[value] args = [], map[str, value] env = ())
```

## function execWithCode {#util-ShellExec-execWithCode}

```rascal
tuple[str output, int exitCode] execWithCode(str processCommand, loc workingDir=|cwd:///|, list[str] args = [], map[str, str] env = ())
```

## function execWithCode {#util-ShellExec-execWithCode}

start, run and kill an external process returning its output as a string with an exit code.

```rascal
tuple[str output, int exitCode] execWithCode(loc processCommand, loc workingDir=|cwd:///|, list[value] args = [], map[str, value] env = ())
```

## function killProcess {#util-ShellExec-killProcess}

Kill a running process, or a zombie process (a process which is not alive yet not killed)

```rascal
void killProcess(PID processId, bool force=false)
```

## function isAlive {#util-ShellExec-isAlive}

Check whether a process is still alive

```rascal
bool isAlive(PID processId)
```

## function isZombie {#util-ShellExec-isZombie}

Check whether a process is still registered but not actually running anymore. A zombie process may be cleaned up using killProcess.

```rascal
bool isZombie(PID processId)
```

## function exitCode {#util-ShellExec-exitCode}

Waits for the process to exit and then returns its return code. This is a blocking operation.

```rascal
int exitCode(PID processId)
```

## function readFrom {#util-ShellExec-readFrom}

Read from an existing process's output stream. This is non-blocking.

```rascal
str readFrom(PID processId)
```

## function readWithWait {#util-ShellExec-readWithWait}

Read from an existing process's output stream with a given wait timeout. Some processes are a little slower in producing output. The wait is used to give the process some extra time in producing output. This is non-blocking apart from the waiting.

```rascal
str readWithWait(PID processId, int wait)
```

## function readFromErr {#util-ShellExec-readFromErr}

Read from an existing process's error output stream. This is non-blocking.

```rascal
str readFromErr(PID processId)
```

## function readLineFromErr {#util-ShellExec-readLineFromErr}

Read from an existing process's error output stream. This blocks until a full line is read and waits for one second maximally for this line to appear.

```rascal
str readLineFromErr(PID processId, int wait=200, int maxTries=5)
```

## function readEntireStream {#util-ShellExec-readEntireStream}

Read the entire stream from an existing process's output stream. This is blocking.

```rascal
str readEntireStream(PID processId)
```

## function readEntireErrStream {#util-ShellExec-readEntireErrStream}

Read the entire error stream from an existing process's output stream. This is blocking.

```rascal
str readEntireErrStream(PID processId)
```

## function writeTo {#util-ShellExec-writeTo}

Write to an existing process's input stream.

```rascal
void writeTo(PID processId, str msg)
```

## alias PID {#util-ShellExec-PID}

Process Identifiers (PID).

```rascal
int
```


A PID is returned by [Create Process](../..//Library/util/ShellExec.md#util-ShellExec-createProcess) and is required for any further interaction with the created process.

