---
title: "module util::tasks::Manager"
id: Manager
slug: /Library/util/tasks/Manager
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

#### Usage

```rascal
import util::tasks::Manager;
```



## alias Task {#util-tasks-Manager-Task}

```rascal
bool (Transaction tr, type[&T] key, &N name)
```

## function registerProducer {#util-tasks-Manager-registerProducer}

```rascal
void registerProducer(Task[&T,&N] producer, set[value] keys)
```

## function unregisterProducer {#util-tasks-Manager-unregisterProducer}

```rascal
void unregisterProducer(Task[&T,&N] producer)
```

## function lockProducerRegistry {#util-tasks-Manager-lockProducerRegistry}

Lock the producer registry ‚Äì use this before adding/removing a
	set of related producers. Remember to enclose the critical section in
	try { ...¬†} finally { unlockProducerRegistry(); }

```rascal
void lockProducerRegistry()
```

## function unlockProducerRegistry {#util-tasks-Manager-unlockProducerRegistry}

```rascal
void unlockProducerRegistry()
```

## function registryTransaction {#util-tasks-Manager-registryTransaction}

```rascal
void registryTransaction(void() f)
```

## alias Transaction {#util-tasks-Manager-Transaction}

```rascal
value
```

## alias Fact {#util-tasks-Manager-Fact}

```rascal
value
```

## function startTransaction {#util-tasks-Manager-startTransaction}

```rascal
Transaction startTransaction()

Transaction startTransaction(Transaction parent)
```

## function endTransaction {#util-tasks-Manager-endTransaction}

```rascal
void endTransaction(Transaction tr)
```

## function abandonTransaction {#util-tasks-Manager-abandonTransaction}

```rascal
void abandonTransaction(Transaction tr)
```

## function getFact {#util-tasks-Manager-getFact}

```rascal
&T getFact(Transaction tr, type[&T] key, value name)
```

## function queryFact {#util-tasks-Manager-queryFact}

```rascal
&T queryFact(Transaction tr, type[&T] key, value name)
```

## function hasFact {#util-tasks-Manager-hasFact}

```rascal
bool hasFact(Transaction tr, type[&T] key, value name)
```

## function removeFact {#util-tasks-Manager-removeFact}

```rascal
void removeFact(Transaction tr, type[&T] key, value name)
```

## function setFact {#util-tasks-Manager-setFact}

```rascal
void setFact(Transaction tr, type[&T] key, value name, &T val)
```

## function getDependencyGraph {#util-tasks-Manager-getDependencyGraph}

```rascal
tuple[rel[str,str,str,int],rel[str,str,str]] getDependencyGraph(Transaction tr)
```

