---
title: "module vis::Basic"
id: Basic
slug: /Library/vis/Basic
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

Uses static HTML to visualize arbitrary Rascal values
#### Usage

```rascal
import vis::Basic;
```

#### Dependencies
```rascal
import lang::html::IO;
import lang::rascal::format::Grammar;
import ParseTree;
import Node;
import util::IDEServices;
import util::Math;
import util::Sampling;
import Content;
import IO;
import ValueIO;
import List;
import Set;
import Map;
```

#### Description


This modules provides a simple mapping from hierarchical (nested)
Rascal values to HTML markup. The goal of the mapping is to provide
a more visible and searchable representation of Rascal values than
the standard textual expression format.

This module is quite new and may undergo some tweaks in the coming time.


## function showValue {#vis-Basic-showValue}

```rascal
Content showValue(value v)
```

## function valueServer {#vis-Basic-valueServer}

```rascal
Response (Request) valueServer(value v)
```

## function toHTML {#vis-Basic-toHTML}

```rascal
HTMLElement toHTML(num i)

HTMLElement toHTML(str s)

HTMLElement toHTML(loc l)

HTMLElement toHTML(list[value] l)

default HTMLElement toHTML(set[value] l)

HTMLElement toHTML(rel[value,value] r)

HTMLElement toHTML(rel[value,value,value] r)

HTMLElement toHTML(rel[value,value,value,value] r)

HTMLElement toHTML(map[value,value] m)

HTMLElement toHTML(t:<value a, value bb>)

HTMLElement toHTML(t:<value a, value bb, value c>)

HTMLElement toHTML(t:<value a, value bb, value c, value d>)

HTMLElement toHTML(Tree t:appl(Production p, list[Tree] args))

HTMLElement toHTML(Tree t:amb(set[Tree] alts))

HTMLElement toHTML(char(int c))

HTMLElement toHTML(node n)

default HTMLElement toHTML(value x:!set[value] _)
```

## function sampled {#vis-Basic-sampled}

```rascal
str sampled(list[value] s, int count)

str sampled(set[value] s, int count)

str sampled(map[value,value] s, int count)
```

