---
title: "module vis::Text"
id: Text
slug: /Library/vis/Text
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.0-RC29</div>

Visualizing values using "ASCII art".
This module provides functions that map values to strings using ASCII Art pretty printing.

The words [ASCII Art](https://en.wikipedia.org/wiki/ASCII_art) refers to the technique of 
constructing images from text characters that are in the ASCII set. However, in this case
we may use any Unicode character for visual representation purposes.
#### Usage

```rascal
import vis::Text;
```

#### Dependencies
```rascal
import Node;
import List;
import ListRelation;
import ParseTree;
import Type;
```

#### Examples



```rascal-shell 
rascal>syntax E = "e" | E "+" E;
ok
rascal>import IO;
ok
rascal>import vis::Text;
ok
rascal>ex = prettyTree([E] "e+e+e");
str: " ❖\n ├─ E = E  \"+\"  E \n │  ├─ E = \"e\" \n │  └─ E = E  \"+\"  E \n │     ├─ E = \"e\" \n │     └─ E = \"e\" \n └─ E = E  \"+\"  E \n    ├─ E = E  \"+\"  E \n    │  ├─ E = \"e\" \n    │  └─ E = \"e\" \n    └─ E = \"e\" \n"
───
 ❖
 ├─ E = E  "+"  E 
 │  ├─ E = "e" 
 │  └─ E = E  "+"  E 
 │     ├─ E = "e" 
 │     └─ E = "e" 
 └─ E = E  "+"  E 
    ├─ E = E  "+"  E 
    │  ├─ E = "e" 
    │  └─ E = "e" 
    └─ E = "e" 

───
rascal>println(ex);
 ❖
 ├─ E = E  "+"  E 
 │  ├─ E = "e" 
 │  └─ E = E  "+"  E 
 │     ├─ E = "e" 
 │     └─ E = "e" 
 └─ E = E  "+"  E 
    ├─ E = E  "+"  E 
    │  ├─ E = "e" 
    │  └─ E = "e" 
    └─ E = "e" 
ok
```


## function prettyTree {#vis-Text-prettyTree}

Pretty prints parse trees using ASCII art lines for edges.

```rascal
str prettyTree(Tree t, bool src=false, bool characters=true, bool \layout=false, bool literals=\layout)
```

## function prettyNode {#vis-Text-prettyNode}

Pretty prints nodes and ADTs using ASCII art for the edges.

```rascal
str prettyNode(node n, bool keywords=true)
```

## function ppvalue {#vis-Text-ppvalue}

```rascal
str ppvalue(value e, str(value) nodeLabel, lrel[str,value](value) edges)
```

## function ppvalue_ {#vis-Text-ppvalue_}

```rascal
str ppvalue_(value e, str(value) nodeLabel, lrel[str,value](value) edges, str indent = "")
```

