/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.visitors;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IExternalValue;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.visitors.IValueVisitor;
import io.usethesource.vallang.visitors.VisitorAdapter;
import java.util.Map;

public class BottomUpVisitor<T, E extends Throwable>
extends VisitorAdapter<T, E> {
    protected IValueFactory fFactory;

    public BottomUpVisitor(IValueVisitor<T, E> visitor, IValueFactory factory) {
        super(visitor);
        this.fFactory = factory;
    }

    @Override
    public T visitNode(INode o) throws E {
        for (int i = 0; i < o.arity(); ++i) {
            o.get(i).accept(this);
        }
        return (T)this.fVisitor.visitNode(o);
    }

    @Override
    public T visitConstructor(IConstructor o) throws E {
        for (int i = 0; i < o.arity(); ++i) {
            o.get(i).accept(this);
        }
        return (T)this.fVisitor.visitConstructor(o);
    }

    @Override
    public T visitList(IList o) throws E {
        IListWriter w = this.fFactory.listWriter();
        for (IValue elem : o) {
            elem.accept(this);
        }
        return (T)this.fVisitor.visitList((IList)w.done());
    }

    @Override
    public T visitSet(ISet o) throws E {
        ISetWriter w = this.fFactory.setWriter();
        for (IValue elem : o) {
            elem.accept(this);
        }
        return (T)this.fVisitor.visitSet((ISet)w.done());
    }

    @Override
    public T visitMap(IMap o) throws E {
        IMapWriter w = this.fFactory.mapWriter();
        for (Map.Entry entry : () -> o.entryIterator()) {
            ((IValue)entry.getKey()).accept(this);
            ((IValue)entry.getValue()).accept(this);
        }
        return (T)this.fVisitor.visitMap((IMap)w.done());
    }

    @Override
    public T visitTuple(ITuple o) throws E {
        for (int i = 0; i < o.arity(); ++i) {
            o.get(i).accept(this);
        }
        return (T)this.fVisitor.visitTuple(o);
    }

    @Override
    public T visitExternal(IExternalValue externalValue) throws E {
        return (T)this.fVisitor.visitExternal(externalValue);
    }
}

