/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.IASTVisitor;

public abstract class Replacement
extends AbstractAST {
    public Replacement(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasConditions() {
        return false;
    }

    public List<Expression> getConditions() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasReplacementExpression() {
        return false;
    }

    public Expression getReplacementExpression() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isConditional() {
        return false;
    }

    public boolean isUnconditional() {
        return false;
    }

    public static class Unconditional
    extends Replacement {
        private final Expression replacementExpression;

        public Unconditional(ISourceLocation src, IConstructor node, Expression replacementExpression) {
            super(src, node);
            this.replacementExpression = replacementExpression;
        }

        @Override
        public boolean isUnconditional() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitReplacementUnconditional(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.replacementExpression.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.replacementExpression.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Unconditional)) {
                return false;
            }
            Unconditional tmp = (Unconditional)o;
            return tmp.replacementExpression.equals(this.replacementExpression);
        }

        @Override
        public int hashCode() {
            return 281 + 433 * this.replacementExpression.hashCode();
        }

        @Override
        public Expression getReplacementExpression() {
            return this.replacementExpression;
        }

        @Override
        public boolean hasReplacementExpression() {
            return true;
        }

        @Override
        public Object clone() {
            return Unconditional.newInstance(this.getClass(), this.src, null, this.clone(this.replacementExpression));
        }
    }

    public static class Conditional
    extends Replacement {
        private final Expression replacementExpression;
        private final List<Expression> conditions;

        public Conditional(ISourceLocation src, IConstructor node, Expression replacementExpression, List<Expression> conditions) {
            super(src, node);
            this.replacementExpression = replacementExpression;
            this.conditions = conditions;
        }

        @Override
        public boolean isConditional() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitReplacementConditional(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.replacementExpression.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.replacementExpression.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.conditions) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Conditional)) {
                return false;
            }
            Conditional tmp = (Conditional)o;
            return tmp.replacementExpression.equals(this.replacementExpression) && tmp.conditions.equals(this.conditions);
        }

        @Override
        public int hashCode() {
            return 881 + 3 * this.replacementExpression.hashCode() + 293 * this.conditions.hashCode();
        }

        @Override
        public Expression getReplacementExpression() {
            return this.replacementExpression;
        }

        @Override
        public boolean hasReplacementExpression() {
            return true;
        }

        @Override
        public List<Expression> getConditions() {
            return this.conditions;
        }

        @Override
        public boolean hasConditions() {
            return true;
        }

        @Override
        public Object clone() {
            return Conditional.newInstance(this.getClass(), this.src, null, this.clone(this.replacementExpression), this.clone(this.conditions));
        }
    }
}

