/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Case;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Strategy;

public abstract class Visit
extends AbstractAST {
    public Visit(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasCases() {
        return false;
    }

    public List<Case> getCases() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasSubject() {
        return false;
    }

    public Expression getSubject() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasStrategy() {
        return false;
    }

    public Strategy getStrategy() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isDefaultStrategy() {
        return false;
    }

    public boolean isGivenStrategy() {
        return false;
    }

    public static class GivenStrategy
    extends Visit {
        private final Strategy strategy;
        private final Expression subject;
        private final List<Case> cases;

        public GivenStrategy(ISourceLocation src, IConstructor node, Strategy strategy, Expression subject, List<Case> cases) {
            super(src, node);
            this.strategy = strategy;
            this.subject = subject;
            this.cases = cases;
        }

        @Override
        public boolean isGivenStrategy() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitVisitGivenStrategy(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.strategy.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.strategy.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.subject.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.subject.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.cases) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof GivenStrategy)) {
                return false;
            }
            GivenStrategy tmp = (GivenStrategy)o;
            return tmp.strategy.equals(this.strategy) && tmp.subject.equals(this.subject) && tmp.cases.equals(this.cases);
        }

        @Override
        public int hashCode() {
            return 17 + 797 * this.strategy.hashCode() + 499 * this.subject.hashCode() + 347 * this.cases.hashCode();
        }

        @Override
        public Strategy getStrategy() {
            return this.strategy;
        }

        @Override
        public boolean hasStrategy() {
            return true;
        }

        @Override
        public Expression getSubject() {
            return this.subject;
        }

        @Override
        public boolean hasSubject() {
            return true;
        }

        @Override
        public List<Case> getCases() {
            return this.cases;
        }

        @Override
        public boolean hasCases() {
            return true;
        }

        @Override
        public Object clone() {
            return GivenStrategy.newInstance(this.getClass(), this.src, null, this.clone(this.strategy), this.clone(this.subject), this.clone(this.cases));
        }
    }

    public static class DefaultStrategy
    extends Visit {
        private final Expression subject;
        private final List<Case> cases;

        public DefaultStrategy(ISourceLocation src, IConstructor node, Expression subject, List<Case> cases) {
            super(src, node);
            this.subject = subject;
            this.cases = cases;
        }

        @Override
        public boolean isDefaultStrategy() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitVisitDefaultStrategy(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.subject.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.subject.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.cases) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof DefaultStrategy)) {
                return false;
            }
            DefaultStrategy tmp = (DefaultStrategy)o;
            return tmp.subject.equals(this.subject) && tmp.cases.equals(this.cases);
        }

        @Override
        public int hashCode() {
            return 179 + 797 * this.subject.hashCode() + 101 * this.cases.hashCode();
        }

        @Override
        public Expression getSubject() {
            return this.subject;
        }

        @Override
        public boolean hasSubject() {
            return true;
        }

        @Override
        public List<Case> getCases() {
            return this.cases;
        }

        @Override
        public boolean hasCases() {
            return true;
        }

        @Override
        public Object clone() {
            return DefaultStrategy.newInstance(this.getClass(), this.src, null, this.clone(this.subject), this.clone(this.cases));
        }
    }
}

