/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ideservices;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISourceLocation;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jline.terminal.Terminal;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.interpreter.utils.RascalManifest;
import org.rascalmpl.library.Messages;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;

public class BasicIDEServices
implements IDEServices {
    private final IRascalMonitor monitor;
    private final PrintWriter stderr;
    private final Terminal terminal;
    private final ISourceLocation projectRoot;
    private final String projectName;

    public BasicIDEServices(PrintWriter stderr, IRascalMonitor monitor, Terminal terminal, ISourceLocation projectRoot) {
        this.stderr = stderr;
        this.monitor = monitor;
        this.terminal = terminal;
        this.projectRoot = projectRoot;
        this.projectName = new RascalManifest().getProjectName(projectRoot);
    }

    @Override
    public PrintWriter stderr() {
        return this.stderr;
    }

    @Override
    public Terminal activeTerminal() {
        return this.terminal;
    }

    public void browse(ISourceLocation loc, String title, int viewColumn) {
        this.browse(loc.getURI(), title, viewColumn);
    }

    @Override
    public void browse(URI uri, String _title, int _viewColumn) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(uri);
            }
            catch (IOException e) {
                this.stderr.println(e.getMessage());
            }
        } else {
            this.stderr.println("Desktop not supported, cannot open browser");
        }
    }

    @Override
    public void edit(ISourceLocation loc) {
        try {
            loc = URIResolverRegistry.getInstance().logicalToPhysical(loc);
            if (!loc.getScheme().equals("file")) {
                ISourceLocation tmp = URIUtil.correctLocation("tmp", "", "rascal-edits");
                tmp = URIUtil.getChildLocation(tmp, loc.getScheme());
                tmp = URIUtil.getChildLocation(tmp, loc.getPath());
                URIResolverRegistry.getInstance().copy(loc, tmp, false, true);
                loc = URIResolverRegistry.getInstance().logicalToPhysical(tmp);
            }
            this.edit(Paths.get(loc.getURI()));
        }
        catch (IOException e) {
            this.stderr.println("Can not edit " + loc + " because: " + e);
        }
    }

    public void edit(Path path) {
        Desktop desktop;
        File file = new File(path.toString());
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.EDIT)) {
            try {
                desktop.edit(file);
            }
            catch (IOException e) {
                this.stderr.println(e.getMessage());
            }
        } else {
            this.stderr.println("Desktop not supported, cannot open editor");
        }
    }

    @Override
    public void registerDiagnostics(IList messages, ISourceLocation projectRoot) {
        Messages.write(messages, projectRoot, this.stderr());
    }

    @Override
    public void jobStart(String name, int workShare, int totalWork) {
        this.monitor.jobStart(name, workShare, totalWork);
    }

    @Override
    public void jobStep(String name, String message, int inc) {
        this.monitor.jobStep(name, message, inc);
    }

    @Override
    public int jobEnd(String name, boolean succeeded) {
        return this.monitor.jobEnd(name, succeeded);
    }

    @Override
    public void endAllJobs() {
        this.monitor.endAllJobs();
    }

    @Override
    public boolean jobIsCanceled(String name) {
        return this.monitor.jobIsCanceled(name);
    }

    @Override
    public void jobTodo(String name, int work) {
        this.monitor.jobTodo(name, work);
    }

    @Override
    public void warning(String message, ISourceLocation src) {
        this.monitor.warning(message, src);
    }

    @Override
    public ISourceLocation resolveProjectLocation(ISourceLocation input) {
        if (this.projectName != "" && input.getScheme().equals("project") && input.getAuthority().equals(this.projectName)) {
            return URIUtil.getChildLocation(this.projectRoot, input.getPath());
        }
        return input;
    }
}

