/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import org.rascalmpl.interpreter.result.Result;

public class Accumulator {
    private String label = null;
    private IListWriter writer = null;
    private IString template = null;
    private IValueFactory factory;

    public Accumulator(IValueFactory factory, String label) {
        this.factory = factory;
        this.label = label;
    }

    public Accumulator(IValueFactory factory) {
        this(factory, null);
    }

    public boolean hasLabel(String label) {
        if (this.label == null) {
            return false;
        }
        return this.label.equals(label);
    }

    public void append(Result<IValue> value) {
        if (this.writer == null) {
            this.writer = this.factory.listWriter();
        }
        this.writer.append(value.getValue());
    }

    public void appendString(IString s2) {
        if (this.template == null) {
            this.template = this.factory.string("");
        }
        this.template = this.template.concat(s2);
    }

    public IList done() {
        if (this.template != null) {
            return this.factory.list(this.template);
        }
        if (this.writer == null) {
            return this.factory.list(new IValue[0]);
        }
        return (IList)this.writer.done();
    }

    protected IValueFactory getFactory() {
        return this.factory;
    }
}

