/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Command;
import org.rascalmpl.ast.Commands;
import org.rascalmpl.ast.Declaration;
import org.rascalmpl.ast.EvalCommand;
import org.rascalmpl.ast.Name;
import org.rascalmpl.ast.QualifiedName;
import org.rascalmpl.ast.Statement;
import org.rascalmpl.debug.AbstractInterpreterEventTrigger;
import org.rascalmpl.debug.IRascalFrame;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.debug.IRascalRuntimeInspection;
import org.rascalmpl.debug.IRascalSuspendTrigger;
import org.rascalmpl.debug.IRascalSuspendTriggerListener;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.exceptions.StackTrace;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.interpreter.Accumulator;
import org.rascalmpl.interpreter.Configuration;
import org.rascalmpl.interpreter.DefaultTestResultListener;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.ITestResultListener;
import org.rascalmpl.interpreter.NullRascalMonitor;
import org.rascalmpl.interpreter.TestEvaluator;
import org.rascalmpl.interpreter.TraversalEvaluator;
import org.rascalmpl.interpreter.TypeDeclarationEvaluator;
import org.rascalmpl.interpreter.asserts.NotYetImplemented;
import org.rascalmpl.interpreter.callbacks.IConstructorDeclared;
import org.rascalmpl.interpreter.control_exceptions.Failure;
import org.rascalmpl.interpreter.control_exceptions.Insert;
import org.rascalmpl.interpreter.control_exceptions.MatchFailed;
import org.rascalmpl.interpreter.control_exceptions.Return;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.env.GlobalEnvironment;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.interpreter.env.Pair;
import org.rascalmpl.interpreter.load.IRascalSearchPathContributor;
import org.rascalmpl.interpreter.load.RascalSearchPath;
import org.rascalmpl.interpreter.load.URIContributor;
import org.rascalmpl.interpreter.result.AbstractFunction;
import org.rascalmpl.interpreter.result.ICallableValue;
import org.rascalmpl.interpreter.result.OverloadedFunction;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.CommandlineError;
import org.rascalmpl.interpreter.staticErrors.UndeclaredFunction;
import org.rascalmpl.interpreter.staticErrors.UndeclaredVariable;
import org.rascalmpl.interpreter.staticErrors.UnguardedFail;
import org.rascalmpl.interpreter.staticErrors.UnguardedInsert;
import org.rascalmpl.interpreter.staticErrors.UnguardedReturn;
import org.rascalmpl.interpreter.utils.JavaBridge;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.interpreter.utils.Profiler;
import org.rascalmpl.library.lang.rascal.syntax.RascalParser;
import org.rascalmpl.parser.ASTBuilder;
import org.rascalmpl.parser.ParserGenerator;
import org.rascalmpl.parser.gtd.io.InputConverter;
import org.rascalmpl.parser.gtd.result.out.DefaultNodeFlattener;
import org.rascalmpl.parser.uptr.UPTRNodeFactory;
import org.rascalmpl.parser.uptr.action.NoActionExecutor;
import org.rascalmpl.semantics.dynamic.Import;
import org.rascalmpl.shell.CommandlineParser;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.RascalFunctionValueFactory;
import org.rascalmpl.values.functions.IFunction;
import org.rascalmpl.values.parsetrees.ITree;

public class Evaluator
implements IEvaluator<Result<IValue>>,
IRascalSuspendTrigger,
IRascalRuntimeInspection {
    private final RascalFunctionValueFactory vf;
    private static final TypeFactory tf = TypeFactory.getInstance();
    protected volatile Environment currentEnvt;
    private final GlobalEnvironment heap;
    private final Configuration config = new Configuration();
    private volatile boolean interrupt = false;
    private int callNesting = 0;
    private boolean callTracing = false;
    private JavaBridge javaBridge;
    private AbstractAST currentAST;
    private boolean doProfiling = false;
    private boolean profilerRunning = false;
    private boolean isBootstrapper = false;
    private final TypeDeclarationEvaluator typeDeclarator;
    private final List<ClassLoader> classLoaders;
    private final ModuleEnvironment rootScope;
    private final PrintWriter defOutWriter;
    private final PrintWriter defErrWriter;
    private final Reader defInput;
    private PrintWriter curOutWriter = null;
    private PrintWriter curErrWriter = null;
    private Reader curInput = null;
    private ITestResultListener testReporter;
    private IRascalMonitor monitor;
    private AbstractInterpreterEventTrigger eventTrigger;
    private final List<IRascalSuspendTriggerListener> suspendTriggerListeners;
    private Stack<Accumulator> accumulators = new Stack();
    private final Stack<IString> indentStack = new Stack();
    private final RascalSearchPath rascalPathResolver;
    private final URIResolverRegistry resolverRegistry;
    private final Map<IConstructorDeclared, Object> constructorDeclaredListeners;
    private static final Object dummy = new Object();
    private volatile ParserGenerator parserGenerator;
    private Stack<TraversalEvaluator> teStack = new Stack();

    @Override
    public int getCallNesting() {
        return this.callNesting;
    }

    @Override
    public boolean getCallTracing() {
        return this.callTracing;
    }

    @Override
    public void setCallTracing(boolean callTracing) {
        this.callTracing = callTracing;
    }

    @Override
    public void incCallNesting() {
        ++this.callNesting;
    }

    @Override
    public void decCallNesting() {
        --this.callNesting;
    }

    public Evaluator(IValueFactory f, Reader input, PrintWriter stderr, PrintWriter stdout, IRascalMonitor monitor, ModuleEnvironment scope, GlobalEnvironment heap) {
        this(f, input, stderr, monitor instanceof PrintWriter ? (PrintWriter)((Object)monitor) : stdout, scope, heap, new ArrayList<ClassLoader>(Collections.singleton(Evaluator.class.getClassLoader())), new RascalSearchPath());
    }

    public <M extends PrintWriter> Evaluator(IValueFactory f, Reader input, PrintWriter stderr, M monitor, ModuleEnvironment scope, GlobalEnvironment heap) {
        this(f, input, stderr, monitor, scope, heap, new ArrayList<ClassLoader>(Collections.singleton(Evaluator.class.getClassLoader())), new RascalSearchPath());
        this.setMonitor((IRascalMonitor)((Object)monitor));
    }

    public Evaluator(IValueFactory f, Reader input, PrintWriter stderr, PrintWriter stdout, ModuleEnvironment scope, GlobalEnvironment heap, IRascalMonitor monitor) {
        this(f, input, stderr, monitor instanceof PrintWriter ? (PrintWriter)((Object)monitor) : stdout, scope, heap, new ArrayList<ClassLoader>(Collections.singleton(Evaluator.class.getClassLoader())), new RascalSearchPath());
        this.setMonitor(monitor);
    }

    public Evaluator(IValueFactory vf, Reader input, PrintWriter stderr, PrintWriter stdout, ModuleEnvironment scope, GlobalEnvironment heap, List<ClassLoader> classLoaders, RascalSearchPath rascalPathResolver) {
        this.vf = new RascalFunctionValueFactory(this);
        this.heap = heap;
        this.typeDeclarator = new TypeDeclarationEvaluator(this);
        this.currentEnvt = scope;
        this.rootScope = scope;
        heap.addModule(scope);
        this.classLoaders = classLoaders;
        this.javaBridge = new JavaBridge(classLoaders, vf, this.config);
        this.rascalPathResolver = rascalPathResolver;
        this.resolverRegistry = rascalPathResolver.getRegistry();
        this.defInput = input;
        this.defErrWriter = stderr;
        this.defOutWriter = stdout;
        this.constructorDeclaredListeners = new HashMap<IConstructorDeclared, Object>();
        this.suspendTriggerListeners = new CopyOnWriteArrayList<IRascalSuspendTriggerListener>();
        this.updateProperties();
        if (stderr == null) {
            throw new NullPointerException("stderr is null");
        }
        if (stdout == null) {
            throw new NullPointerException("stdout is null");
        }
        this.setEventTrigger(AbstractInterpreterEventTrigger.newNullEventTrigger());
    }

    private Evaluator(Evaluator source, ModuleEnvironment scope) {
        this.vf = source.vf;
        this.heap = source.heap;
        this.typeDeclarator = new TypeDeclarationEvaluator(this);
        this.currentEnvt = scope;
        this.rootScope = scope;
        this.heap.addModule(scope);
        this.classLoaders = source.classLoaders;
        this.javaBridge = new JavaBridge(this.classLoaders, this.vf, this.config);
        this.rascalPathResolver = source.rascalPathResolver;
        this.resolverRegistry = source.resolverRegistry;
        this.defInput = source.defInput;
        this.defErrWriter = source.defErrWriter;
        this.defOutWriter = source.defOutWriter;
        this.constructorDeclaredListeners = new HashMap<IConstructorDeclared, Object>(source.constructorDeclaredListeners);
        this.suspendTriggerListeners = new CopyOnWriteArrayList<IRascalSuspendTriggerListener>(source.suspendTriggerListeners);
        this.updateProperties();
        this.setEventTrigger(AbstractInterpreterEventTrigger.newNullEventTrigger());
    }

    @Override
    public void resetJavaBridge() {
        this.javaBridge = new JavaBridge(this.classLoaders, this.vf, this.config);
    }

    @Override
    public IRascalMonitor setMonitor(IRascalMonitor monitor) {
        if (monitor == this) {
            return monitor;
        }
        this.interrupt = false;
        IRascalMonitor old = this.monitor;
        this.monitor = monitor;
        return old;
    }

    @Override
    public int jobEnd(String name, boolean succeeded) {
        if (this.monitor != null) {
            return this.monitor.jobEnd(name, succeeded);
        }
        return 0;
    }

    @Override
    public void endAllJobs() {
        if (this.monitor != null) {
            this.monitor.endAllJobs();
        }
    }

    @Override
    public void jobStep(String name, String msg, int inc) {
        if (this.monitor != null) {
            this.monitor.jobStep(name, msg, inc);
        }
    }

    @Override
    public void jobStart(String name, int workShare, int totalWork) {
        if (this.monitor != null) {
            this.monitor.jobStart(name, workShare, totalWork);
        }
    }

    @Override
    public void jobTodo(String name, int work) {
        if (this.monitor != null) {
            this.monitor.jobTodo(name, work);
        }
    }

    @Override
    public boolean jobIsCanceled(String name) {
        if (this.monitor == null) {
            return false;
        }
        return this.monitor.jobIsCanceled(name);
    }

    @Override
    public void registerConstructorDeclaredListener(IConstructorDeclared iml) {
        this.constructorDeclaredListeners.put(iml, dummy);
    }

    @Override
    public void notifyConstructorDeclaredListeners() {
        for (IConstructorDeclared iml : this.constructorDeclaredListeners.keySet()) {
            if (iml == null) continue;
            iml.handleConstructorDeclaredEvent();
        }
        this.constructorDeclaredListeners.clear();
    }

    @Override
    public List<ClassLoader> getClassLoaders() {
        return Collections.unmodifiableList(this.classLoaders);
    }

    @Override
    public ModuleEnvironment __getRootScope() {
        return this.rootScope;
    }

    @Override
    public PrintWriter getOutPrinter() {
        return this.curOutWriter == null ? this.defOutWriter : this.curOutWriter;
    }

    @Override
    public Reader getInput() {
        return this.curInput == null ? this.defInput : this.curInput;
    }

    @Override
    public TypeDeclarationEvaluator __getTypeDeclarator() {
        return this.typeDeclarator;
    }

    @Override
    public GlobalEnvironment __getHeap() {
        return this.heap;
    }

    @Override
    public void __setInterrupt(boolean interrupt) {
        this.interrupt = interrupt;
    }

    @Override
    public Stack<Accumulator> __getAccumulators() {
        return this.accumulators;
    }

    @Override
    public IValueFactory __getVf() {
        return this.vf;
    }

    public static TypeFactory __getTf() {
        return tf;
    }

    @Override
    public JavaBridge __getJavaBridge() {
        return this.javaBridge;
    }

    @Override
    public void interrupt() {
        this.__setInterrupt(true);
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupt;
    }

    @Override
    public PrintWriter getErrorPrinter() {
        return this.curErrWriter == null ? this.defErrWriter : this.curErrWriter;
    }

    public void setTestResultListener(ITestResultListener l) {
        this.testReporter = l;
    }

    public JavaBridge getJavaBridge() {
        return this.javaBridge;
    }

    @Override
    public RascalSearchPath getRascalResolver() {
        return this.rascalPathResolver;
    }

    @Override
    public void indent(IString n) {
        this.indentStack.push(n);
    }

    @Override
    public void unindent() {
        this.indentStack.pop();
    }

    @Override
    public IString getCurrentIndent() {
        return this.indentStack.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IValue call(IRascalMonitor monitor, String name, IValue ... args) {
        IRascalMonitor old = this.setMonitor(monitor);
        try {
            IValue iValue = this.call(name, args);
            return iValue;
        }
        finally {
            this.setMonitor(old);
        }
    }

    @Override
    public IValue call(String adt, String name, IValue ... args) {
        LinkedList<AbstractFunction> candidates = new LinkedList<AbstractFunction>();
        Type[] types = new Type[args.length];
        int i = 0;
        for (IValue v : args) {
            types[i++] = v.getType();
        }
        this.getCurrentEnvt().getAllFunctions(name, candidates);
        if (candidates.isEmpty()) {
            throw new UndeclaredFunction(name, types, this, this.getCurrentAST());
        }
        LinkedList<AbstractFunction> filtered = new LinkedList<AbstractFunction>();
        for (AbstractFunction candidate : candidates) {
            if (!candidate.getReturnType().isAbstractData() || !candidate.getReturnType().getName().equals(adt)) continue;
            filtered.add(candidate);
        }
        if (filtered.isEmpty()) {
            throw new UndeclaredFunction(adt + "::" + name, types, this, this.getCurrentAST());
        }
        OverloadedFunction func = new OverloadedFunction(name, filtered);
        return func.call(this.getMonitor(), types, args, Collections.emptyMap()).getValue();
    }

    @Override
    public IValue call(String name, IValue ... args) {
        return this.call(name, (Map<String, IValue>)null, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IValue call(IRascalMonitor monitor, String module, String name, IValue ... args) {
        IRascalMonitor old = this.setMonitor(monitor);
        Environment oldEnv = this.getCurrentEnvt();
        try {
            ModuleEnvironment modEnv = this.getHeap().getModule(module);
            this.setCurrentEnvt(modEnv);
            IValue iValue = this.call(name, (Map<String, IValue>)null, args);
            return iValue;
        }
        finally {
            this.setMonitor(old);
            this.setCurrentEnvt(oldEnv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IValue main(IRascalMonitor monitor, String module, String function, String[] commandline) {
        IRascalMonitor old = this.setMonitor(monitor);
        Environment oldEnv = this.getCurrentEnvt();
        CommandlineParser parser = new CommandlineParser(this.getOutPrinter());
        try {
            ModuleEnvironment modEnv = this.getHeap().getModule(module);
            this.setCurrentEnvt(modEnv);
            Name name = Names.toName(function, modEnv.getLocation());
            Result func = this.getCurrentEnvt().getVariable(name);
            if (func instanceof OverloadedFunction) {
                OverloadedFunction overloaded = (OverloadedFunction)this.getCurrentEnvt().getVariable(name);
                func = overloaded.getFunctions().get(0);
            }
            if (func == null) {
                throw new UndeclaredVariable(function, name);
            }
            if (!(func instanceof AbstractFunction)) {
                throw new UnsupportedOperationException("main should be function");
            }
            AbstractFunction main = (AbstractFunction)func;
            if (main.getArity() == 1 && main.getFormals().getFieldType(0).isSubtypeOf(tf.listType(tf.stringType()))) {
                IValue iValue = main.call(this.getMonitor(), new Type[]{tf.listType(tf.stringType())}, new IValue[]{parser.parsePlainCommandLineArgs(commandline)}, null).getValue();
                return iValue;
            }
            if (main.hasKeywordArguments() && main.getArity() == 0) {
                if (main.getType().getFieldTypes().getArity() > 0) {
                    throw new CommandlineError("main function should only have keyword parameters.", main.getType().getKeywordParameterTypes(), module);
                }
                Map<String, IValue> args = parser.parseKeywordCommandLineArgs(module, commandline, func.getStaticType().getKeywordParameterTypes());
                IValue iValue = main.call(this.getMonitor(), new Type[0], new IValue[0], args).getValue();
                return iValue;
            }
            try {
                throw new CommandlineError("main function should either have one argument of type list[str], or keyword parameters", main.getType(), module);
            }
            catch (MatchFailed e) {
                this.getOutPrinter().println("Main function should either have a list[str] as a single parameter like so: 'void main(list[str] args)', or a set of keyword parameters with defaults like so: 'void main(bool myOption=false, str input=\"\")'");
                IValue iValue = null;
                return iValue;
            }
        }
        finally {
            this.setMonitor(old);
            this.setCurrentEnvt(oldEnv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IValue main(IRascalMonitor monitor, String module, String function, Map<String, IValue> args) {
        IRascalMonitor old = this.setMonitor(monitor);
        Environment oldEnv = this.getCurrentEnvt();
        try {
            ModuleEnvironment modEnv = this.getHeap().getModule(module);
            this.setCurrentEnvt(modEnv);
            Name name = Names.toName(function, modEnv.getLocation());
            Result func = this.getCurrentEnvt().getVariable(name);
            if (func instanceof OverloadedFunction) {
                OverloadedFunction overloaded = (OverloadedFunction)this.getCurrentEnvt().getVariable(name);
                func = overloaded.getFunctions().get(0);
            }
            if (func == null) {
                throw new UndeclaredVariable(function, name);
            }
            if (!(func instanceof AbstractFunction)) {
                throw new UnsupportedOperationException("main should be function");
            }
            AbstractFunction main = (AbstractFunction)func;
            if (main.hasKeywordArguments() && main.getArity() == 0) {
                if (main.getType().getFieldTypes().getArity() > 0) {
                    throw new CommandlineError("main function should only have keyword parameters.", main.getType().getKeywordParameterTypes(), module);
                }
                IValue iValue = main.call(this.getMonitor(), new Type[0], new IValue[0], args).getValue();
                return iValue;
            }
            try {
                throw new CommandlineError("main function should either have one argument of type list[str], or keyword parameters", main.getType(), module);
            }
            catch (MatchFailed e) {
                this.getOutPrinter().println("Main function should either have a list[str] as a single parameter like so: 'void main(list[str] args)', or a set of keyword parameters with defaults like so: 'void main(bool myOption=false, str input=\"\")'");
                IValue iValue = null;
                return iValue;
            }
        }
        finally {
            this.setMonitor(old);
            this.setCurrentEnvt(oldEnv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IValue call(String name, String module, Map<String, IValue> kwArgs, IValue ... args) {
        IRascalMonitor old = this.setMonitor(this.monitor);
        Environment oldEnv = this.getCurrentEnvt();
        try {
            ModuleEnvironment modEnv = this.getHeap().getModule(module);
            this.setCurrentEnvt(modEnv);
            IValue iValue = this.call(name, kwArgs, args);
            return iValue;
        }
        finally {
            this.setMonitor(old);
            this.setCurrentEnvt(oldEnv);
        }
    }

    private IValue call(String name, Map<String, IValue> kwArgs, IValue ... args) {
        QualifiedName qualifiedName = Names.toQualifiedName(name, this.getCurrentEnvt().getLocation());
        this.setCurrentAST(qualifiedName);
        return this.call(qualifiedName, kwArgs, args);
    }

    @Override
    public IValue call(QualifiedName qualifiedName, Map<String, IValue> kwArgs, IValue ... args) {
        ICallableValue func = (ICallableValue)((Object)this.getCurrentEnvt().getVariable(qualifiedName));
        Type[] types = new Type[args.length];
        int i = 0;
        for (IValue v : args) {
            types[i++] = v.getType();
        }
        if (func == null) {
            throw new UndeclaredFunction(Names.fullName(qualifiedName), types, this, this.getCurrentAST());
        }
        return func.call(this.getMonitor(), types, args, kwArgs).getValue();
    }

    @Override
    public IConstructor getGrammar(Environment env) {
        ModuleEnvironment root = (ModuleEnvironment)env.getRoot();
        return this.getParserGenerator().getGrammarFromModules(this.monitor, root.getName(), root.getSyntaxDefinition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IValue diagnoseAmbiguity(IRascalMonitor monitor, IConstructor parseTree) {
        IRascalMonitor old = this.setMonitor(monitor);
        try {
            ParserGenerator pgen = this.getParserGenerator();
            IValue iValue = pgen.diagnoseAmbiguity(parseTree);
            return iValue;
        }
        finally {
            this.setMonitor(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IConstructor getExpandedGrammar(IRascalMonitor monitor, ISourceLocation uri) {
        IRascalMonitor old = this.setMonitor(monitor);
        try {
            ParserGenerator pgen = this.getParserGenerator();
            String main = uri.getAuthority();
            ModuleEnvironment env = this.getHeap().getModule(main);
            IConstructor iConstructor = pgen.getExpandedGrammar(monitor, main, env.getSyntaxDefinition());
            return iConstructor;
        }
        finally {
            this.setMonitor(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISet getNestingRestrictions(IRascalMonitor monitor, IConstructor g2) {
        IRascalMonitor old = this.setMonitor(monitor);
        try {
            ParserGenerator pgen = this.getParserGenerator();
            ISet iSet = pgen.getNestingRestrictions(monitor, g2);
            return iSet;
        }
        finally {
            this.setMonitor(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParserGenerator getParserGenerator() {
        if (this.parserGenerator == null) {
            Evaluator self;
            if (this.isBootstrapper()) {
                throw new ImplementationError("Cyclic bootstrapping is occurring, probably because a module in the bootstrap dependencies is using the concrete syntax feature.");
            }
            Evaluator evaluator = self = this;
            synchronized (evaluator) {
                if (this.parserGenerator == null) {
                    this.parserGenerator = new ParserGenerator(this.getMonitor(), this.monitor instanceof PrintWriter ? (PrintWriter)((Object)this.monitor) : this.getErrorPrinter(), this.getValueFactory(), this.config);
                }
            }
        }
        return this.parserGenerator;
    }

    @Override
    public void setCurrentAST(AbstractAST currentAST) {
        this.currentAST = currentAST;
    }

    @Override
    public AbstractAST getCurrentAST() {
        return this.currentAST;
    }

    public void addRascalSearchPathContributor(IRascalSearchPathContributor contrib) {
        this.rascalPathResolver.addPathContributor(contrib);
    }

    public void addRascalSearchPath(ISourceLocation uri) {
        this.rascalPathResolver.addPathContributor(new URIContributor(uri));
    }

    public void addClassLoader(ClassLoader loader) {
        this.classLoaders.add(0, loader);
    }

    @Override
    public StackTrace getStackTrace() {
        StackTrace trace = new StackTrace();
        for (Environment env = this.currentEnvt; env != null; env = env.getCallerScope()) {
            trace.add(env.getLocation(), env.getName());
        }
        return trace.freeze();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<IValue> eval(Statement stat) {
        this.__setInterrupt(false);
        Profiler profiler = null;
        if (this.doProfiling && !this.profilerRunning) {
            profiler = new Profiler(this);
            profiler.start();
            this.profilerRunning = true;
        }
        this.currentAST = stat;
        try {
            Result<IValue> result = stat.interpret(this);
            if (profiler != null) {
                profiler.pleaseStop();
                profiler.report();
                this.profilerRunning = false;
            }
            this.getEventTrigger().fireIdleEvent();
            this.endAllJobs();
            return result;
        }
        catch (Throwable throwable) {
            try {
                if (profiler != null) {
                    profiler.pleaseStop();
                    profiler.report();
                    this.profilerRunning = false;
                }
                this.getEventTrigger().fireIdleEvent();
                this.endAllJobs();
                throw throwable;
            }
            catch (Return e) {
                throw new UnguardedReturn(stat);
            }
            catch (Failure e) {
                throw new UnguardedFail(stat, e);
            }
            catch (Insert e) {
                throw new UnguardedInsert(stat);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<IValue> eval(IRascalMonitor monitor, String command, ISourceLocation location) {
        IRascalMonitor old = this.setMonitor(monitor);
        try {
            Result<IValue> result = this.eval(command, location);
            return result;
        }
        finally {
            this.endAllJobs();
            this.setMonitor(old);
            this.getEventTrigger().fireIdleEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<IValue> evalMore(IRascalMonitor monitor, String commands, ISourceLocation location) {
        IRascalMonitor old = this.setMonitor(monitor);
        try {
            Result<IValue> result = this.evalMore(commands, location);
            return result;
        }
        finally {
            this.endAllJobs();
            this.setMonitor(old);
            this.getEventTrigger().fireIdleEvent();
        }
    }

    private Result<IValue> eval(String command, ISourceLocation location) throws ImplementationError {
        Command stat;
        this.__setInterrupt(false);
        NoActionExecutor actionExecutor = new NoActionExecutor();
        ITree tree = new RascalParser().parse("start__Command", location.getURI(), command.toCharArray(), Integer.MAX_VALUE, actionExecutor, new DefaultNodeFlattener(), new UPTRNodeFactory(false));
        if (!this.noBacktickOutsideStringConstant(command)) {
            ModuleEnvironment curMod = this.getCurrentModuleEnvironment();
            IFunction parsers = this.parserForCurrentModule(this.vf, curMod);
            tree = Import.parseFragments(this.vf, this.getMonitor(), parsers, tree, location, this.getCurrentModuleEnvironment());
        }
        if ((stat = new ASTBuilder().buildCommand(tree)) == null) {
            throw new ImplementationError("Disambiguation failed: it removed all alternatives");
        }
        return this.eval(stat);
    }

    private IFunction parserForCurrentModule(RascalFunctionValueFactory vf, ModuleEnvironment curMod) {
        IConstructor dummy = vf.constructor(RascalFunctionValueFactory.Symbol_Empty);
        IMap syntaxDefinition = curMod.getSyntaxDefinition();
        IMap grammar = (IMap)this.getParserGenerator().getGrammarFromModules(this.getMonitor(), curMod.getName(), syntaxDefinition).get("rules");
        IConstructor reifiedType = vf.reifiedType(dummy, grammar);
        return vf.parsers(reifiedType, vf.bool(false), vf.integer(Integer.MAX_VALUE), vf.bool(false), vf.integer(0), vf.integer(0), vf.bool(false), vf.bool(false), vf.set(new IValue[0]));
    }

    private Result<IValue> evalMore(String command, ISourceLocation location) throws ImplementationError {
        Commands stat;
        this.__setInterrupt(false);
        NoActionExecutor actionExecutor = new NoActionExecutor();
        ITree tree = new RascalParser().parse("start__Commands", location.getURI(), command.toCharArray(), Integer.MAX_VALUE, actionExecutor, new DefaultNodeFlattener(), new UPTRNodeFactory(false));
        if (!this.noBacktickOutsideStringConstant(command)) {
            IFunction parsers = this.parserForCurrentModule(this.vf, this.getCurrentModuleEnvironment());
            tree = Import.parseFragments(this.vf, this.getMonitor(), parsers, tree, location, this.getCurrentModuleEnvironment());
        }
        if ((stat = new ASTBuilder().buildCommands(tree)) == null) {
            throw new ImplementationError("Disambiguation failed: it removed all alternatives");
        }
        return this.eval(stat);
    }

    private boolean noBacktickOutsideStringConstant(String command) {
        boolean instring = false;
        byte[] b = command.getBytes();
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == 34) {
                instring = !instring;
                continue;
            }
            if (instring || b[i] != 96) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITree parseCommand(IRascalMonitor monitor, String command, ISourceLocation location) {
        IRascalMonitor old = this.setMonitor(monitor);
        try {
            ITree iTree = this.parseCommand(command, location);
            return iTree;
        }
        finally {
            this.setMonitor(old);
        }
    }

    private ITree parseCommand(String command, ISourceLocation location) {
        this.__setInterrupt(false);
        NoActionExecutor actionExecutor = new NoActionExecutor();
        ITree tree = new RascalParser().parse("start__Command", location.getURI(), command.toCharArray(), Integer.MAX_VALUE, actionExecutor, new DefaultNodeFlattener(), new UPTRNodeFactory(false));
        if (!this.noBacktickOutsideStringConstant(command)) {
            tree = Import.parseFragments(this.vf, this.getMonitor(), this.parserForCurrentModule(this.vf, this.getCurrentModuleEnvironment()), tree, location, this.getCurrentModuleEnvironment());
        }
        return tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITree parseCommands(IRascalMonitor monitor, String commands, ISourceLocation location) {
        IRascalMonitor old = this.setMonitor(monitor);
        try {
            this.__setInterrupt(false);
            NoActionExecutor actionExecutor = new NoActionExecutor();
            ITree tree = new RascalParser().parse("start__Commands", location.getURI(), commands.toCharArray(), Integer.MAX_VALUE, actionExecutor, new DefaultNodeFlattener(), new UPTRNodeFactory(false));
            if (!this.noBacktickOutsideStringConstant(commands)) {
                tree = Import.parseFragments(this.vf, this.getMonitor(), this.parserForCurrentModule(this.vf, this.getCurrentModuleEnvironment()), tree, location, this.getCurrentModuleEnvironment());
            }
            ITree iTree = tree;
            return iTree;
        }
        finally {
            this.setMonitor(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<IValue> eval(IRascalMonitor monitor, Command command) {
        IRascalMonitor old = this.setMonitor(monitor);
        try {
            Result<IValue> result = this.eval(command);
            return result;
        }
        finally {
            this.endAllJobs();
            this.setMonitor(old);
            this.getEventTrigger().fireIdleEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result<IValue> eval(Commands commands) {
        this.__setInterrupt(false);
        Profiler profiler = null;
        if (this.doProfiling && !this.profilerRunning) {
            profiler = new Profiler(this);
            profiler.start();
            this.profilerRunning = true;
        }
        try {
            Result<Object> last = ResultFactory.nothing();
            for (EvalCommand command : commands.getCommands()) {
                last = command.interpret(this);
            }
            Iterator<EvalCommand> iterator = last;
            return iterator;
        }
        finally {
            if (profiler != null) {
                profiler.pleaseStop();
                profiler.report();
                this.profilerRunning = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result<IValue> eval(Command command) {
        this.__setInterrupt(false);
        Profiler profiler = null;
        if (this.doProfiling && !this.profilerRunning) {
            profiler = new Profiler(this);
            profiler.start();
            this.profilerRunning = true;
        }
        try {
            if (command.isImport()) {
                Result result = this.job("loading modules", 1, (String jobName, BiConsumer<String, Integer> step) -> {
                    try {
                        Result<IValue> result = command.interpret(this);
                        return result;
                    }
                    finally {
                        step.accept(jobName, 1);
                    }
                });
                return result;
            }
            Result<IValue> result = command.interpret(this);
            return result;
        }
        finally {
            if (profiler != null) {
                profiler.pleaseStop();
                profiler.report();
                this.profilerRunning = false;
            }
        }
    }

    public Result<IValue> eval(IRascalMonitor monitor, Declaration declaration) {
        IRascalMonitor old = this.setMonitor(monitor);
        try {
            this.__setInterrupt(false);
            this.currentAST = declaration;
            Result<IValue> r = declaration.interpret(this);
            if (r != null) {
                Result<IValue> result = r;
                return result;
            }
            throw new NotYetImplemented(declaration);
        }
        finally {
            this.setMonitor(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImport(IRascalMonitor monitor, String ... string) {
        assert (monitor != null);
        IRascalMonitor old = this.setMonitor(monitor);
        this.interrupt = false;
        try {
            monitor.jobStart("loading modules", string.length);
            ISourceLocation uri = URIUtil.rootLocation("import");
            for (String module : string) {
                monitor.jobStep("loading modules", "Starting on " + module);
                Import.importModule(module, uri, this);
            }
        }
        finally {
            monitor.jobEnd("loading modules", true);
            this.setMonitor(old);
            this.setCurrentAST(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doNextImport(String jobName, String ... names) {
        IRascalMonitor old = this.setMonitor(this.monitor);
        this.interrupt = false;
        try {
            ISourceLocation uri = URIUtil.rootLocation("import");
            for (String module : names) {
                this.monitor.jobStep(jobName, "Starting on " + module);
                Import.importModule(module, uri, this);
            }
        }
        finally {
            this.setMonitor(old);
            this.setCurrentAST(null);
        }
    }

    public Set<String> reloadModules(IRascalMonitor monitor, Set<String> names, ISourceLocation errorLocation) {
        HashSet<String> reloaded = new HashSet<String>();
        this.reloadModules(monitor, names, errorLocation, true, reloaded);
        return Collections.unmodifiableSet(reloaded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadModules(IRascalMonitor monitor, Set<String> names, ISourceLocation errorLocation, boolean recurseToExtending, Set<String> affectedModules) {
        SaveWarningsMonitor wrapped = new SaveWarningsMonitor(monitor, this.getErrorPrinter());
        IRascalMonitor old = this.setMonitor(wrapped);
        try {
            HashSet<String> onHeap = new HashSet<String>();
            HashSet<String> extendingModules = new HashSet<String>();
            PrintWriter errStream = this.getErrorPrinter();
            for (String mod : names) {
                if (!this.heap.existsModule(mod)) continue;
                onHeap.add(mod);
                if (recurseToExtending) {
                    extendingModules.addAll(this.heap.getExtendingModules(mod));
                }
                this.heap.removeModule(this.heap.getModule(mod));
            }
            extendingModules.removeAll(names);
            this.job("loading modules", onHeap.size(), (String jobName, BiConsumer<String, Integer> step) -> {
                HashSet<String> todo;
                ModuleEnvironment env;
                for (String mod : onHeap) {
                    try {
                        wrapped.clear();
                        if (this.heap.existsModule(mod)) continue;
                        this.reloadModule(mod, errorLocation, affectedModules, (String)jobName);
                        if (this.heap.existsModule(mod)) continue;
                        errStream.println("** Something went wrong while reloading module " + mod + ":");
                        for (String s2 : wrapped.getWarnings()) {
                            errStream.println(s2);
                        }
                        errStream.println("*** Note: after fixing the error, you will have to manually reimport the modules that you already imported.");
                        errStream.println("*** if the error persists, start a new console session.");
                    }
                    finally {
                        step.accept(mod, 1);
                    }
                }
                HashSet<String> dependingImports = new HashSet<String>();
                HashSet<String> dependingExtends = new HashSet<String>();
                dependingImports.addAll(this.getImportingModules(names));
                dependingExtends.addAll(this.getExtendingModules(names));
                for (String mod : dependingImports) {
                    env = this.heap.getModule(mod);
                    todo = new HashSet<String>(env.getImports());
                    for (String imp : todo) {
                        if (!names.contains(imp)) continue;
                        env.unImport(imp);
                        ModuleEnvironment imported = this.heap.getModule(imp);
                        if (imported != null) {
                            env.addImport(imp, imported);
                            affectedModules.add(mod);
                            continue;
                        }
                        errStream.println("Could not reimport" + imp + " at " + errorLocation);
                        this.warning("could not reimport " + imp, errorLocation);
                    }
                }
                for (String mod : dependingExtends) {
                    env = this.heap.getModule(mod);
                    todo = new HashSet<String>(env.getExtends());
                    for (String ext : todo) {
                        if (!names.contains(ext)) continue;
                        env.unExtend(ext);
                        ModuleEnvironment extended = this.heap.getModule(ext);
                        if (extended != null) {
                            env.addExtend(ext);
                            continue;
                        }
                        errStream.println("Could not re-extend" + ext + " at " + errorLocation);
                        this.warning("could not re-extend " + ext, errorLocation);
                    }
                }
                if (recurseToExtending && !extendingModules.isEmpty()) {
                    this.reloadModules(monitor, extendingModules, errorLocation, false, affectedModules);
                }
                if (!names.isEmpty()) {
                    this.notifyConstructorDeclaredListeners();
                }
                return true;
            });
        }
        finally {
            this.setMonitor(old);
        }
    }

    private void reloadModule(String name, ISourceLocation errorLocation, Set<String> reloaded, String jobName) {
        try {
            Import.loadModule(errorLocation, name, this);
            reloaded.add(name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Set<String> getImportingModules(Set<String> names) {
        HashSet<String> found = new HashSet<String>();
        LinkedList<String> todo = new LinkedList<String>(names);
        while (!todo.isEmpty()) {
            String mod = todo.pop();
            Set<String> dependingModules = this.heap.getImportingModules(mod);
            dependingModules.removeAll(found);
            found.addAll(dependingModules);
            todo.addAll(dependingModules);
        }
        return found;
    }

    private Set<String> getExtendingModules(Set<String> names) {
        HashSet<String> found = new HashSet<String>();
        LinkedList<String> todo = new LinkedList<String>(names);
        while (!todo.isEmpty()) {
            String mod = todo.pop();
            Set<String> dependingModules = this.heap.getExtendingModules(mod);
            dependingModules.removeAll(found);
            found.addAll(dependingModules);
            todo.addAll(dependingModules);
        }
        return found;
    }

    @Override
    public void unwind(Environment old) {
        this.setCurrentEnvt(old);
    }

    @Override
    public void pushEnv() {
        Environment env = new Environment(this.getCurrentEnvt(), this.getCurrentLocation(), this.getCurrentEnvt().getName());
        this.setCurrentEnvt(env);
    }

    private ISourceLocation getCurrentLocation() {
        return this.currentAST != null ? this.currentAST.getLocation() : this.getCurrentEnvt().getLocation();
    }

    @Override
    public void pushEnv(String name) {
        Environment env = new Environment(this.getCurrentEnvt(), this.getCurrentLocation(), name);
        this.setCurrentEnvt(env);
    }

    @Override
    public Environment pushEnv(Statement s2) {
        Environment env = new Environment(this.getCurrentEnvt(), s2.getLocation(), this.getCurrentEnvt().getName());
        this.setCurrentEnvt(env);
        return env;
    }

    @Override
    public void printHelpMessage(PrintWriter out) {
        out.println("Welcome to the Rascal command shell.");
        out.println();
        out.println("Shell commands (optionally terminated with `;`):");
        out.println(":help                      Prints this message");
        out.println(":quit or EOF               Quits the shell");
        out.println(":set <option> <expression> Sets an option");
        out.println("e.g. profiling    true/false");
        out.println("     tracing      true/false");
        out.println("     errors       true/false");
        out.println("     debugging    true/false");
        out.println(":edit <modulename>         Opens an editor for that module");
        out.println(":test <optModuleName>      Runs all unit tests currently loaded, or only of a specific module");
        out.println(":declarations              Prints variables, functions, data and syntax definitions in scope");
        out.println(":undeclare <name>          Remove variable, function, data or syntax from this scope");
        out.println(":unimport  <name>          Remove import from current scope");
        out.println();
        out.println("Example rascal statements and declarations:");
        out.println("1 + 1;                     Expressions simply print their output and (static) type");
        out.println("int a;                     Declarations allocate a name in the current scope");
        out.println("a = 1;                     Assignments store a value in a (optionally previously declared) variable");
        out.println("int a = 1;                 Declaration with initialization");
        out.println("import IO;                 Importing a module makes its public members available");
        out.println("println(\"Hello World\")     Function calling");
        out.println();
        out.println("Please read the manual for further information");
        out.flush();
    }

    @Override
    public ModuleEnvironment getCurrentModuleEnvironment() {
        if (!(this.currentEnvt instanceof ModuleEnvironment)) {
            throw new ImplementationError("Current env should be a module environment");
        }
        return (ModuleEnvironment)this.currentEnvt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char[] getResourceContent(ISourceLocation location) throws IOException {
        char[] data;
        try (Reader textStream = null;){
            textStream = this.resolverRegistry.getCharacterReader(location);
            data = InputConverter.toChar(textStream);
        }
        return data;
    }

    @Override
    public ITree parseModuleAndFragments(IRascalMonitor monitor, ISourceLocation location, String jobName) throws IOException {
        return this.parseModuleAndFragments(monitor, jobName, this.getResourceContent(location), location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITree parseModuleAndFragments(IRascalMonitor monitor, String jobName, char[] data, ISourceLocation location) {
        IRascalMonitor old = this.setMonitor(monitor);
        try {
            ITree iTree = Import.parseModuleAndFragments(data, location, jobName, this);
            return iTree;
        }
        finally {
            this.setMonitor(old);
        }
    }

    @Override
    public void updateProperties() {
        this.doProfiling = this.config.getProfilingProperty();
        this.setCallTracing(this.config.getTracingProperty());
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    public Stack<IRascalFrame> getCallStack() {
        Stack<IRascalFrame> stack = new Stack<IRascalFrame>();
        for (Environment env = this.currentEnvt; env != null; env = env.getCallerScope()) {
            stack.add(0, env);
        }
        return stack;
    }

    @Override
    public Environment getCurrentEnvt() {
        return this.currentEnvt;
    }

    @Override
    public void setCurrentEnvt(Environment env) {
        this.currentEnvt = env;
    }

    @Override
    public IEvaluator<Result<IValue>> getEvaluator() {
        return this;
    }

    @Override
    public GlobalEnvironment getHeap() {
        return this.__getHeap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean runTests(IRascalMonitor monitor, Optional<String> optionalModuleName) {
        IRascalMonitor old = this.setMonitor(monitor);
        try {
            final boolean[] allOk = new boolean[]{true};
            final ITestResultListener l = this.testReporter != null ? this.testReporter : new DefaultTestResultListener(this.getOutPrinter(), this.getErrorPrinter());
            TestEvaluator teval = new TestEvaluator(this, new ITestResultListener(){

                @Override
                public void report(boolean successful, String test, ISourceLocation loc, String message, Throwable t2) {
                    if (!successful) {
                        allOk[0] = false;
                    }
                    l.report(successful, test, loc, message, t2);
                }

                @Override
                public void done() {
                    l.done();
                }

                @Override
                public void ignored(String test, ISourceLocation loc) {
                    l.ignored(test, loc);
                }

                @Override
                public void start(String context, int count) {
                    l.start(context, count);
                }
            });
            if (optionalModuleName.isPresent()) {
                teval.test(optionalModuleName.get());
            } else {
                teval.test();
            }
            boolean bl = allOk[0];
            return bl;
        }
        finally {
            this.setMonitor(old);
        }
    }

    @Override
    public IValueFactory getValueFactory() {
        return this.__getVf();
    }

    @Override
    public RascalFunctionValueFactory getFunctionValueFactory() {
        return (RascalFunctionValueFactory)this.__getVf();
    }

    public void setAccumulators(Accumulator accu) {
        this.__getAccumulators().push(accu);
    }

    @Override
    public Stack<Accumulator> getAccumulators() {
        return this.__getAccumulators();
    }

    @Override
    public void setAccumulators(Stack<Accumulator> accumulators) {
        this.accumulators = accumulators;
    }

    @Override
    public IRascalMonitor getMonitor() {
        if (this.monitor != null) {
            return this.monitor;
        }
        return new NullRascalMonitor();
    }

    public void overrideDefaultWriters(Reader newInput, PrintWriter newStdOut, PrintWriter newStdErr) {
        this.curInput = newInput;
        this.curErrWriter = newStdErr;
        this.curOutWriter = newStdOut;
    }

    public void revertToDefaultWriters() {
        this.curInput = null;
        if (this.curOutWriter != null) {
            this.curOutWriter.flush();
        }
        this.curOutWriter = null;
        if (this.curErrWriter != null) {
            this.curErrWriter.flush();
        }
        this.curErrWriter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<IValue> call(IRascalMonitor monitor, ICallableValue fun, Type[] argTypes, IValue[] argValues, Map<String, IValue> keyArgValues) {
        Profiler profiler = null;
        if (this.doProfiling && !this.profilerRunning) {
            profiler = new Profiler(this);
            profiler.start();
            this.profilerRunning = true;
            try {
                Result<IValue> result = fun.call(monitor, argTypes, argValues, keyArgValues);
                return result;
            }
            finally {
                if (profiler != null) {
                    profiler.pleaseStop();
                    profiler.report();
                    this.profilerRunning = false;
                }
            }
        }
        return fun.call(monitor, argTypes, argValues, keyArgValues);
    }

    public Result<IValue> call(IRascalMonitor monitor, ICallableValue fun, Type[] argTypes, IValue ... argValues) {
        return this.call(monitor, fun, argTypes, argValues, (Map<String, IValue>)null);
    }

    @Override
    public void addSuspendTriggerListener(IRascalSuspendTriggerListener listener) {
        this.suspendTriggerListeners.add(listener);
    }

    @Override
    public void removeSuspendTriggerListener(IRascalSuspendTriggerListener listener) {
        this.suspendTriggerListeners.remove(listener);
    }

    @Override
    public void notifyAboutSuspension(AbstractAST currentAST) {
        if (!this.suspendTriggerListeners.isEmpty() && currentAST.isBreakable()) {
            for (IRascalSuspendTriggerListener listener : this.suspendTriggerListeners) {
                listener.suspended(this, () -> this.getCallStack().size(), currentAST.getLocation());
            }
        }
    }

    public AbstractInterpreterEventTrigger getEventTrigger() {
        return this.eventTrigger;
    }

    public void setEventTrigger(AbstractInterpreterEventTrigger eventTrigger) {
        this.eventTrigger = eventTrigger;
    }

    @Override
    public void freeze() {
    }

    @Override
    public IEvaluator<Result<IValue>> fork() {
        return new Evaluator(this, this.rootScope);
    }

    public void setBootstrapperProperty(boolean b) {
        this.isBootstrapper = b;
    }

    public boolean isBootstrapper() {
        return this.isBootstrapper;
    }

    public void removeSearchPathContributor(IRascalSearchPathContributor contrib) {
        this.rascalPathResolver.remove(contrib);
    }

    @Override
    public List<IRascalSuspendTriggerListener> getSuspendTriggerListeners() {
        return this.suspendTriggerListeners;
    }

    @Override
    public void warning(String message, ISourceLocation src) {
        if (this.monitor != null) {
            this.monitor.warning(message, src);
        }
    }

    @Override
    public TraversalEvaluator __getCurrentTraversalEvaluator() {
        if (this.teStack.size() > 0) {
            return this.teStack.peek();
        }
        return null;
    }

    @Override
    public void __pushTraversalEvaluator(TraversalEvaluator te) {
        this.teStack.push(te);
    }

    @Override
    public TraversalEvaluator __popTraversalEvaluator() {
        return this.teStack.pop();
    }

    @Override
    public Map<String, String> completePartialIdentifier(String qualifier, String partialIdentifier) {
        if (partialIdentifier.startsWith("\\")) {
            partialIdentifier = partialIdentifier.substring(1);
        }
        String partialModuleName = qualifier + "::" + partialIdentifier;
        TreeMap<String, String> result = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                if (a.charAt(0) == '\\') {
                    a = a.substring(1);
                }
                if (b.charAt(0) == '\\') {
                    b = b.substring(1);
                }
                return a.compareTo(b);
            }
        });
        this.addCompletionsForModule(qualifier, partialIdentifier, partialModuleName, result, this.__getRootScope(), false);
        for (String mod : this.__getRootScope().getImports()) {
            this.addCompletionsForModule(qualifier, partialIdentifier, partialModuleName, result, this.__getRootScope().getImport(mod), true);
        }
        return result;
    }

    private void addCompletionsForModule(String qualifier, String partialIdentifier, String partialModuleName, SortedMap<String, String> result, ModuleEnvironment env, boolean skipPrivate) {
        boolean inQualifiedModule;
        for (Pair<String, LinkedHashSet<AbstractFunction>> pair : env.getFunctions()) {
            for (AbstractFunction f : pair.getSecond()) {
                String module = ((ModuleEnvironment)f.getEnv()).getName();
                if (skipPrivate && env.isNamePrivate(f.getName()) || !module.startsWith(qualifier)) continue;
                Evaluator.addCandidate(result, "function", pair.getFirst(), qualifier.isEmpty() ? "" : module, module.startsWith(partialModuleName) ? "" : partialIdentifier);
            }
        }
        boolean bl = inQualifiedModule = env.getName().equals(qualifier) || qualifier.isEmpty();
        if (inQualifiedModule) {
            for (Map.Entry<String, Result<IValue>> entry : env.getVariables().entrySet()) {
                if (skipPrivate && env.isNamePrivate(entry.getKey())) continue;
                Evaluator.addCandidate(result, "variable", entry.getKey(), qualifier, partialIdentifier);
            }
            for (Type type : env.getAbstractDatatypes()) {
                if (!inQualifiedModule) continue;
                Evaluator.addCandidate(result, "ADT", type.getName(), qualifier, partialIdentifier);
            }
            for (Type type : env.getAliases()) {
                Evaluator.addCandidate(result, "alias", type.getName(), qualifier, partialIdentifier);
            }
        }
        if (qualifier.isEmpty()) {
            Map<Type, Map<String, Type>> map = env.getAnnotations();
            for (Type t3 : map.keySet()) {
                for (String k : map.get(t3).keySet()) {
                    Evaluator.addCandidate(result, "annotation", k, "", partialIdentifier);
                }
            }
        }
    }

    private static void addCandidate(SortedMap<String, String> result, String category, String name, String qualifier, String originalTerm) {
        if (((String)name).startsWith(originalTerm) && !((String)name).equals(originalTerm)) {
            if (((String)name).contains("-")) {
                name = "\\" + (String)name;
            }
            if (!qualifier.isEmpty() && !((String)name).startsWith(qualifier)) {
                name = qualifier + "::" + (String)name;
            }
            result.put((String)name, category);
        }
    }

    @Override
    public Stack<IRascalFrame> getCurrentStack() {
        return this.getCallStack();
    }

    @Override
    public IRascalFrame getTopFrame() {
        return this.getCurrentEnvt();
    }

    @Override
    public ISourceLocation getCurrentPointOfExecution() {
        AbstractAST cpe = this.getCurrentAST();
        return cpe != null ? cpe.getLocation() : this.getCurrentEnvt().getLocation();
    }

    @Override
    public IRascalFrame getModule(String name) {
        return this.heap.getModule(name);
    }

    public void overwritePrintWriter(PrintWriter outWriter, PrintWriter errWriter) {
        this.curOutWriter = outWriter;
        this.curErrWriter = errWriter;
    }

    private static final class SaveWarningsMonitor
    implements IDEServices {
        private final List<String> warnings;
        private final IRascalMonitor monitor;
        private final PrintWriter stderr;

        public SaveWarningsMonitor(IRascalMonitor monitor, PrintWriter stderr) {
            this.monitor = monitor;
            this.warnings = new ArrayList<String>();
            this.stderr = stderr;
        }

        @Override
        public PrintWriter stderr() {
            return this.stderr;
        }

        @Override
        public void jobStart(String name, int workShare, int totalWork) {
            this.monitor.jobStart(name, workShare, totalWork);
        }

        @Override
        public void jobStep(String name, String msg, int inc) {
            this.monitor.jobStep(name, msg, inc);
        }

        @Override
        public int jobEnd(String name, boolean succeeded) {
            return this.monitor.jobEnd(name, succeeded);
        }

        @Override
        public boolean jobIsCanceled(String name) {
            return this.monitor.jobIsCanceled(name);
        }

        @Override
        public void jobTodo(String name, int work) {
            this.monitor.jobTodo(name, work);
        }

        @Override
        public void endAllJobs() {
            this.monitor.endAllJobs();
        }

        @Override
        public void warning(String message, ISourceLocation src) {
            this.warnings.add(src + ":" + message);
            this.monitor.warning(message, src);
        }

        public void clear() {
            this.warnings.clear();
        }

        public List<String> getWarnings() {
            return this.warnings;
        }

        @Override
        public void registerLanguage(IConstructor language) {
            if (this.monitor instanceof IDEServices) {
                ((IDEServices)this.monitor).registerLanguage(language);
            } else {
                IDEServices.super.registerLanguage(language);
            }
        }

        @Override
        public ISourceLocation resolveProjectLocation(ISourceLocation input) {
            if (this.monitor instanceof IDEServices) {
                return ((IDEServices)this.monitor).resolveProjectLocation(input);
            }
            return IDEServices.super.resolveProjectLocation(input);
        }

        @Override
        public void applyFileSystemEdits(IList edits) {
            if (this.monitor instanceof IDEServices) {
                ((IDEServices)this.monitor).applyFileSystemEdits(edits);
            } else {
                IDEServices.super.applyFileSystemEdits(edits);
            }
        }

        @Override
        public void browse(URI uri, String title, int viewColumn) {
            if (!(this.monitor instanceof IDEServices)) {
                return;
            }
            ((IDEServices)this.monitor).browse(uri, title, viewColumn);
        }

        @Override
        public void edit(ISourceLocation path) {
            if (!(this.monitor instanceof IDEServices)) {
                return;
            }
            ((IDEServices)this.monitor).edit(path);
        }

        @Override
        public void registerLocations(IString scheme, IString auth, IMap map) {
            if (!(this.monitor instanceof IDEServices)) {
                return;
            }
            ((IDEServices)this.monitor).registerLocations(scheme, auth, map);
        }

        @Override
        public void unregisterLocations(IString scheme, IString auth) {
            if (!(this.monitor instanceof IDEServices)) {
                return;
            }
            ((IDEServices)this.monitor).unregisterLocations(scheme, auth);
        }

        @Override
        public void registerDiagnostics(IList messages) {
            if (!(this.monitor instanceof IDEServices)) {
                return;
            }
            ((IDEServices)this.monitor).registerDiagnostics(messages);
        }

        @Override
        public void unregisterDiagnostics(IList resources) {
            if (!(this.monitor instanceof IDEServices)) {
                return;
            }
            ((IDEServices)this.monitor).unregisterDiagnostics(resources);
        }

        @Override
        public void logMessage(IConstructor msg) {
            if (!(this.monitor instanceof IDEServices)) {
                return;
            }
            ((IDEServices)this.monitor).logMessage(msg);
        }

        @Override
        public void showMessage(IConstructor message) {
            if (!(this.monitor instanceof IDEServices)) {
                return;
            }
            ((IDEServices)this.monitor).showMessage(message);
        }
    }
}

