/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.exceptions.IllegalOperationException;
import io.usethesource.vallang.exceptions.UndeclaredFieldException;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import org.rascalmpl.ast.Field;
import org.rascalmpl.ast.Name;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.result.ElementResult;
import org.rascalmpl.interpreter.result.LessThanOrEqualResult;
import org.rascalmpl.interpreter.result.ListOrRelationResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.result.SetResult;
import org.rascalmpl.interpreter.result.TupleResult;
import org.rascalmpl.interpreter.staticErrors.Arity;
import org.rascalmpl.interpreter.staticErrors.UndeclaredField;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;
import org.rascalmpl.interpreter.staticErrors.UnsupportedOperation;
import org.rascalmpl.interpreter.staticErrors.UnsupportedSubscriptArity;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.values.ValueFactoryFactory;

public class ListRelationResult
extends ListOrRelationResult<IList> {
    public ListRelationResult(Type type, IList rel, IEvaluatorContext ctx) {
        super(type, rel, ctx);
    }

    @Override
    public Result<IBool> isKeyDefined(Result<?>[] subscripts) {
        int len = ((IList)this.getValue()).getElementType().getArity();
        if (subscripts.length >= len) {
            throw new UnsupportedSubscriptArity(this.getStaticType(), subscripts.length, this.ctx.getCurrentAST());
        }
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), this.getValueFactory().bool(true), this.ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> add(Result<V> result) {
        return result.addListRelation(this);
    }

    @Override
    public Result<IBool> has(Name name) {
        return ResultFactory.bool(this.getStaticType().hasField(Names.name(name)), this.ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> subtract(Result<V> result) {
        return result.subtractListRelation(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> intersect(Result<V> result) {
        return result.intersectListRelation(this);
    }

    @Override
    public <V extends IValue> Result<IBool> equals(Result<V> that) {
        return that.equalToListRelation(this);
    }

    @Override
    public <V extends IValue> Result<IBool> nonEquals(Result<V> that) {
        return that.nonEqualToListRelation(this);
    }

    @Override
    public <V extends IValue> Result<IBool> lessThan(Result<V> that) {
        return that.lessThanListRelation(this);
    }

    @Override
    public <V extends IValue> LessThanOrEqualResult lessThanOrEqual(Result<V> that) {
        return that.lessThanOrEqualListRelation(this);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThan(Result<V> that) {
        return that.greaterThanListRelation(this);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThanOrEqual(Result<V> that) {
        return that.greaterThanOrEqualListRelation(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> compose(Result<V> right) {
        return right.composeListRelation(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> multiply(Result<V> that) {
        return that.multiplyListRelation(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> join(Result<V> that) {
        return that.joinListRelation(this);
    }

    @Override
    public <V extends IValue> Result<IBool> in(Result<V> that) {
        return that.inListRelation(this);
    }

    @Override
    public <V extends IValue> Result<IBool> notIn(Result<V> that) {
        return that.notInListRelation(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> subscript(Result<?>[] subscripts) {
        Type resultType;
        if (this.getStaticType().getElementType().isBottom()) {
            throw RuntimeExceptionFactory.noSuchElement(subscripts[0].getValue(), this.ctx.getCurrentAST(), this.ctx.getStackTrace());
        }
        int nSubs = subscripts.length;
        if (nSubs == 1 && subscripts[0].getStaticType().isInteger()) {
            if (((IList)this.getValue()).length() == 0) {
                throw RuntimeExceptionFactory.emptyList(this.ctx.getCurrentAST(), this.ctx.getStackTrace());
            }
            IInteger index = (IInteger)subscripts[0].getValue();
            int idx = index.intValue();
            if (idx < 0) {
                idx += ((IList)this.getValue()).length();
            }
            if (idx >= ((IList)this.getValue()).length() || idx < 0) {
                throw RuntimeExceptionFactory.indexOutOfBounds(index, this.ctx.getCurrentAST(), this.ctx.getStackTrace());
            }
            return ResultFactory.makeResult(this.getStaticType().getElementType(), ((IList)this.getValue()).get(idx), this.ctx);
        }
        if (nSubs >= this.getStaticType().getArity()) {
            throw new UnsupportedSubscriptArity(this.getStaticType(), nSubs, this.ctx.getCurrentAST());
        }
        int relArity = this.getStaticType().getArity();
        Type[] subscriptType = new Type[nSubs];
        boolean[] subscriptIsSet = new boolean[nSubs];
        Type valueType = TypeFactory.getInstance().valueType();
        for (int i = 0; i < nSubs; ++i) {
            subscriptType[i] = subscripts[i] == null ? valueType : subscripts[i].getStaticType();
        }
        boolean yieldList = relArity - nSubs == 1;
        Type[] resFieldType = new Type[relArity - nSubs];
        for (int i = 0; i < relArity; ++i) {
            Type relFieldType = this.getStaticType().getFieldType(i);
            if (i < nSubs) {
                if (subscriptType[i].isSet() && relFieldType.comparable(subscriptType[i].getElementType())) {
                    subscriptIsSet[i] = true;
                    continue;
                }
                if (subscripts[i] == null || relFieldType.comparable(subscriptType[i])) {
                    subscriptIsSet[i] = false;
                    continue;
                }
                throw new UnexpectedType(relFieldType, subscriptType[i], this.ctx.getCurrentAST());
            }
            resFieldType[i - nSubs] = relFieldType;
        }
        IListWriter wset = null;
        IListWriter wrel = null;
        if (yieldList) {
            resultType = this.getTypeFactory().listType(resFieldType[0]);
            wset = this.getValueFactory().listWriter();
        } else {
            resultType = this.getTypeFactory().lrelType(resFieldType);
            wrel = this.getValueFactory().listWriter();
        }
        for (IValue v : (IList)this.getValue()) {
            ITuple tup = (ITuple)v;
            boolean allEqual = true;
            for (int k = 0; k < nSubs; ++k) {
                if (subscriptIsSet[k] && (subscripts[k] == null || ((ISet)subscripts[k].getValue()).contains(tup.get(k))) || subscripts[k] == null || tup.get(k).equals(subscripts[k].getValue())) continue;
                allEqual = false;
            }
            if (!allEqual) continue;
            IValue[] args = new IValue[relArity - nSubs];
            for (int i = nSubs; i < relArity; ++i) {
                args[i - nSubs] = tup.get(i);
            }
            if (yieldList) {
                wset.append(args[0]);
                continue;
            }
            wrel.append(this.getValueFactory().tuple(args));
        }
        return ResultFactory.makeResult(resultType, yieldList ? wset.done() : wrel.done(), this.ctx);
    }

    @Override
    protected <V extends IValue> Result<IBool> elementOf(ElementResult<V> elementResult) {
        return ResultFactory.bool(((IList)this.getValue()).contains((IValue)elementResult.getValue()), this.ctx);
    }

    @Override
    protected <V extends IValue> Result<IBool> notElementOf(ElementResult<V> elementResult) {
        return ResultFactory.bool(!((IList)this.getValue()).contains((IValue)elementResult.getValue()), this.ctx);
    }

    @Override
    public <U extends IValue> Result<U> transitiveClosure() {
        if (((IList)this.getValue()).asRelation().arity() == 0 || ((IList)this.getValue()).asRelation().arity() == 2) {
            try {
                return ResultFactory.makeResult(this.type, ((IList)this.getValue()).asRelation().closure(), this.ctx);
            }
            catch (IllegalOperationException e) {
                throw new UnsupportedOperation("Illegal argument of transitive closure (+)", this.ctx.getCurrentAST());
            }
        }
        throw new Arity(2, ((IList)this.getValue()).asRelation().arity(), this.ctx.getCurrentAST());
    }

    @Override
    public <U extends IValue> Result<U> transitiveReflexiveClosure() {
        if (((IList)this.getValue()).asRelation().arity() == 0 || ((IList)this.getValue()).asRelation().arity() == 2) {
            try {
                return ResultFactory.makeResult(this.type, ((IList)this.getValue()).asRelation().closureStar(), this.ctx);
            }
            catch (IllegalOperationException e) {
                throw new UnsupportedOperation("Illegal argument of reflexive transitive closure (*)", this.ctx.getCurrentAST());
            }
        }
        throw new Arity(2, ((IList)this.getValue()).asRelation().arity(), this.ctx.getCurrentAST());
    }

    @Override
    public <U extends IValue> Result<U> fieldAccess(String name, TypeStore store) {
        Type tupleType = this.getStaticType().getFieldTypes();
        if (!this.getStaticType().hasFieldNames()) {
            throw new UndeclaredField(name, this.getStaticType(), this.ctx.getCurrentAST());
        }
        if (!this.getStaticType().hasField(name, store)) {
            throw new UndeclaredField(name, this.getStaticType(), this.ctx.getCurrentAST());
        }
        try {
            IListWriter w = this.getValueFactory().listWriter();
            for (IValue e : (IList)this.getValue()) {
                w.append(((ITuple)e).get(tupleType.getFieldIndex(name)));
            }
            return ResultFactory.makeResult(this.getTypeFactory().listType(tupleType.getFieldType(name)), w.done(), this.ctx);
        }
        catch (UndeclaredFieldException e) {
            throw new UndeclaredField(name, this.getStaticType(), this.ctx.getCurrentAST());
        }
    }

    @Override
    protected <U extends IValue> Result<U> composeListRelation(ListRelationResult that) {
        ListRelationResult left = that;
        ListRelationResult right = this;
        Type leftrelType = left.getStaticType();
        Type rightrelType = right.getStaticType();
        int leftArity = leftrelType.getArity();
        int rightArity = rightrelType.getArity();
        if (leftArity != 0 && leftArity != 2) {
            throw new Arity(2, leftArity, this.ctx.getCurrentAST());
        }
        if (rightArity != 0 && rightArity != 2) {
            throw new Arity(2, rightArity, this.ctx.getCurrentAST());
        }
        Type resultType = leftrelType.compose(rightrelType);
        return ResultFactory.makeResult(resultType, ((IList)left.getValue()).asRelation().compose(((IList)right.getValue()).asRelation()), this.ctx);
    }

    <U extends IValue, V extends IValue> Result<U> appendTuple(TupleResult tuple) {
        Type newType = this.getTypeFactory().listType(tuple.getStaticType().lub(this.getStaticType().getElementType()));
        return ResultFactory.makeResult(newType, ((IList)this.getValue()).append((IValue)tuple.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> joinListRelation(ListRelationResult that) {
        int i;
        int arity1 = ((IList)that.getValue()).asRelation().arity();
        int arity2 = ((IList)this.getValue()).asRelation().arity();
        Type tupleType1 = that.getStaticType().getElementType();
        Type tupleType2 = this.getStaticType().getElementType();
        Type[] fieldTypes = new Type[arity1 + arity2];
        for (i = 0; i < arity1; ++i) {
            fieldTypes[i] = tupleType1.getFieldType(i);
        }
        for (i = arity1; i < arity1 + arity2; ++i) {
            fieldTypes[i] = tupleType2.getFieldType(i - arity1);
        }
        Type tupleType = this.getTypeFactory().tupleType(fieldTypes);
        IListWriter writer = this.getValueFactory().listWriter();
        IValue[] fieldValues = new IValue[arity1 + arity2];
        for (IValue tuple1 : (IList)that.getValue()) {
            for (IValue tuple2 : (IList)this.getValue()) {
                int i2;
                for (i2 = 0; i2 < arity1; ++i2) {
                    fieldValues[i2] = ((ITuple)tuple1).get(i2);
                }
                for (i2 = arity1; i2 < arity1 + arity2; ++i2) {
                    fieldValues[i2] = ((ITuple)tuple2).get(i2 - arity1);
                }
                writer.append(this.getValueFactory().tuple(fieldValues));
            }
        }
        Type resultType = this.getTypeFactory().lrelTypeFromTuple(tupleType);
        return ResultFactory.makeResult(resultType, writer.done(), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> joinSet(SetResult that) {
        int arity2 = ((IList)this.getValue()).asRelation().arity();
        Type eltType = that.getStaticType().getElementType();
        Type tupleType = this.getStaticType().getElementType();
        Type[] fieldTypes = new Type[1 + arity2];
        fieldTypes[0] = eltType;
        for (int i = 1; i < 1 + arity2; ++i) {
            fieldTypes[i] = tupleType.getFieldType(i);
        }
        Type resultTupleType = this.getTypeFactory().tupleType(fieldTypes);
        ISetWriter writer = this.getValueFactory().setWriter();
        IValue[] fieldValues = new IValue[1 + arity2];
        for (IValue setValue : (ISet)that.getValue()) {
            for (IValue relValue : (IList)this.getValue()) {
                fieldValues[0] = setValue;
                for (int i = 1; i < 1 + arity2; ++i) {
                    fieldValues[i] = ((ITuple)relValue).get(i);
                }
                writer.insert(this.getValueFactory().tuple(fieldValues));
            }
        }
        Type resultType = this.getTypeFactory().relTypeFromTuple(resultTupleType);
        return ResultFactory.makeResult(resultType, writer.done(), this.ctx);
    }

    @Override
    public Result<IValue> fieldSelect(int[] selectedFields) {
        if (!this.getStaticType().getElementType().isBottom()) {
            for (int i : selectedFields) {
                if (i >= 0 && i < this.getStaticType().getArity()) continue;
                throw RuntimeExceptionFactory.indexOutOfBounds(this.ctx.getValueFactory().integer(i), this.ctx.getCurrentAST(), this.ctx.getStackTrace());
            }
        }
        return ResultFactory.makeResult(this.type.select(selectedFields), ((IList)this.value).asRelation().project(selectedFields), this.ctx);
    }

    @Override
    public Result<IValue> fieldSelect(Field[] selectedFields) {
        int nFields = selectedFields.length;
        int[] fieldIndices = new int[nFields];
        Type baseType = this.getStaticType();
        for (int i = 0; i < nFields; ++i) {
            Field f = selectedFields[i];
            if (f.isIndex()) {
                fieldIndices[i] = ((IInteger)f.getFieldIndex().interpret(this.ctx.getEvaluator()).getValue()).intValue();
            } else {
                String fieldName = Names.name(f.getFieldName());
                try {
                    fieldIndices[i] = baseType.getFieldIndex(fieldName);
                }
                catch (UndeclaredFieldException e) {
                    throw new UndeclaredField(fieldName, baseType, this.ctx.getCurrentAST());
                }
            }
            if (fieldIndices[i] >= 0 && (fieldIndices[i] <= baseType.getArity() || this.getStaticType().getElementType().isBottom())) continue;
            throw RuntimeExceptionFactory.indexOutOfBounds(ValueFactoryFactory.getValueFactory().integer(fieldIndices[i]), this.ctx.getCurrentAST(), this.ctx.getStackTrace());
        }
        return this.fieldSelect(fieldIndices);
    }
}

