/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.result.ElementResult;
import org.rascalmpl.interpreter.result.IntegerResult;
import org.rascalmpl.interpreter.result.LessThanOrEqualResult;
import org.rascalmpl.interpreter.result.NumberResult;
import org.rascalmpl.interpreter.result.RationalResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.result.ValueResult;
import org.rascalmpl.values.ValueFactoryFactory;

public class RealResult
extends ElementResult<IReal> {
    public RealResult(IReal real, IEvaluatorContext ctx) {
        this(real.getType(), real, ctx);
    }

    public RealResult(Type type, IReal real, IEvaluatorContext ctx) {
        super(type, real, ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> add(Result<V> result) {
        return result.addReal(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> multiply(Result<V> result) {
        return result.multiplyReal(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> divide(Result<V> result) {
        return result.divideReal(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> makeRange(Result<V> that) {
        return that.makeRangeFromReal(this);
    }

    @Override
    public <U extends IValue, V extends IValue, W extends IValue> Result<U> makeStepRange(Result<V> to, Result<W> step) {
        return to.makeStepRangeFromReal(this, step);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> subtract(Result<V> result) {
        return result.subtractReal(this);
    }

    @Override
    public <V extends IValue> Result<IBool> equals(Result<V> that) {
        return that.equalToReal(this);
    }

    @Override
    public <V extends IValue> Result<IBool> nonEquals(Result<V> that) {
        return that.nonEqualToReal(this);
    }

    @Override
    public <V extends IValue> LessThanOrEqualResult lessThanOrEqual(Result<V> result) {
        return result.lessThanOrEqualReal(this);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThan(Result<V> that) {
        return that.greaterThanReal(this);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThanOrEqual(Result<V> that) {
        return that.greaterThanOrEqualReal(this);
    }

    @Override
    public <V extends IValue> Result<IBool> lessThan(Result<V> that) {
        return that.lessThanReal(this);
    }

    @Override
    public <U extends IValue> Result<U> negative() {
        return ResultFactory.makeResult(this.type, ((IReal)this.getValue()).negate(), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> addInteger(IntegerResult n) {
        return n.widenToReal().add(this);
    }

    @Override
    protected <U extends IValue> Result<U> subtractInteger(IntegerResult n) {
        return n.widenToReal().subtract(this);
    }

    @Override
    protected <U extends IValue> Result<U> multiplyInteger(IntegerResult n) {
        return n.widenToReal().multiply(this);
    }

    @Override
    protected <U extends IValue> Result<U> divideInteger(IntegerResult n) {
        try {
            return n.widenToReal().divide(this);
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), this.ctx.getCurrentAST(), null);
        }
    }

    @Override
    protected <U extends IValue> Result<U> addRational(RationalResult n) {
        return n.widenToReal().add(this);
    }

    @Override
    protected <U extends IValue> Result<U> subtractRational(RationalResult n) {
        return n.widenToReal().subtract(this);
    }

    @Override
    protected <U extends IValue> Result<U> multiplyRational(RationalResult n) {
        return n.widenToReal().multiply(this);
    }

    @Override
    protected <U extends IValue> Result<U> divideRational(RationalResult n) {
        try {
            return n.widenToReal().divide(this);
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), this.ctx.getCurrentAST(), null);
        }
    }

    @Override
    protected <U extends IValue> Result<U> addReal(ElementResult<IReal> n) {
        return ResultFactory.makeResult(this.type, ((IReal)this.getValue()).add((IReal)n.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> subtractReal(ElementResult<IReal> n) {
        return ResultFactory.makeResult(this.type, ((IReal)n.getValue()).subtract((IReal)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> multiplyReal(ElementResult<IReal> n) {
        return ResultFactory.makeResult(this.type, ((IReal)this.getValue()).multiply((IReal)n.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> divideReal(ElementResult<IReal> n) {
        try {
            int prec = ValueFactoryFactory.getValueFactory().getPrecision();
            return ResultFactory.makeResult(this.type, ((IReal)n.getValue()).divide((IReal)this.getValue(), prec), this.ctx);
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), this.ctx.getCurrentAST(), null);
        }
    }

    @Override
    protected Result<IBool> equalToReal(RealResult that) {
        return ResultFactory.bool(((IReal)that.getValue()).equal((IReal)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected Result<IBool> equalToValue(ValueResult that) {
        return this.equalityBoolean(that);
    }

    @Override
    protected Result<IBool> equalToRational(RationalResult that) {
        return ResultFactory.bool(((IRational)that.getValue()).equal((IReal)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected Result<IBool> nonEqualToReal(RealResult that) {
        return ResultFactory.bool(!((IReal)that.getValue()).equal((IReal)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualReal(ElementResult<IReal> that) {
        return new LessThanOrEqualResult(((IReal)that.getValue()).less((IReal)this.getValue()).getValue(), ((IReal)that.getValue()).equal((IReal)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected Result<IBool> equalToInteger(IntegerResult that) {
        return that.widenToReal().equals(this);
    }

    @Override
    protected Result<IBool> nonEqualToInteger(IntegerResult that) {
        return that.widenToReal().nonEquals(this);
    }

    @Override
    protected Result<IBool> lessThanInteger(IntegerResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IInteger)that.getValue()).less((IReal)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> lessThanNumber(NumberResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((INumber)that.getValue()).less((IReal)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> lessThanReal(RealResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IReal)that.getValue()).less((IReal)this.getValue()), this.ctx);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualInteger(IntegerResult that) {
        return new LessThanOrEqualResult(((IInteger)that.getValue()).less((IReal)this.getValue()).getValue(), ((IInteger)that.getValue()).equal((IReal)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanInteger(IntegerResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IInteger)that.getValue()).greater((IReal)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualInteger(IntegerResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IInteger)that.getValue()).greaterEqual((IReal)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanNumber(NumberResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((INumber)that.getValue()).greater((IReal)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualReal(ElementResult<IReal> that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IReal)that.getValue()).greaterEqual((IReal)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualNumber(NumberResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((INumber)that.getValue()).greaterEqual((IReal)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanReal(ElementResult<IReal> that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IReal)that.getValue()).greater((IReal)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> lessThanRational(RationalResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IRational)that.getValue()).less((IReal)this.getValue()), this.ctx);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualRational(RationalResult that) {
        return new LessThanOrEqualResult(((IRational)that.getValue()).less((IReal)this.getValue()).getValue(), ((IRational)that.getValue()).equal((IReal)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanRational(RationalResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IRational)that.getValue()).greater((IReal)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualRational(RationalResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IRational)that.getValue()).greaterEqual((IReal)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> addNumber(NumberResult n) {
        return ResultFactory.makeResult(this.type, ((IReal)this.getValue()).add((INumber)n.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> subtractNumber(NumberResult n) {
        return ResultFactory.makeResult(this.type, ((INumber)n.getValue()).subtract((IReal)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> multiplyNumber(NumberResult n) {
        return ResultFactory.makeResult(this.type, ((IReal)this.getValue()).multiply((INumber)n.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> divideNumber(NumberResult n) {
        try {
            return ResultFactory.makeResult(this.type, ((INumber)n.getValue()).divide((IReal)this.getValue(), 60), this.ctx);
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), this.ctx.getCurrentAST(), null);
        }
    }

    @Override
    protected Result<IBool> equalToNumber(NumberResult that) {
        return ResultFactory.bool(((INumber)that.getValue()).equal((IReal)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected Result<IBool> nonEqualToNumber(NumberResult that) {
        return ResultFactory.bool(!((INumber)that.getValue()).equal((IReal)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualNumber(NumberResult that) {
        return new LessThanOrEqualResult(((INumber)that.getValue()).less((IReal)this.getValue()).getValue(), ((INumber)that.getValue()).equal((IReal)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> makeRangeFromInteger(IntegerResult from) {
        return this.makeRangeWithDefaultStep(this.toReal(from));
    }

    @Override
    protected <U extends IValue, V extends IValue> Result<U> makeStepRangeFromInteger(IntegerResult from, Result<V> second) {
        return IntegerResult.makeStepRangeFromToWithSecond(this.toReal(from), this, second, this.getValueFactory(), this.getTypeFactory(), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> makeRangeFromReal(ElementResult<IReal> from) {
        return this.makeRangeWithDefaultStep(from);
    }

    @Override
    protected <U extends IValue, V extends IValue> Result<U> makeStepRangeFromReal(ElementResult<IReal> from, Result<V> second) {
        return IntegerResult.makeStepRangeFromToWithSecond(from, this, second, this.getValueFactory(), this.getTypeFactory(), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> makeRangeFromNumber(NumberResult from) {
        return this.makeRangeWithDefaultStep(from);
    }

    private <U extends IValue, V extends INumber> Result<U> makeRangeWithDefaultStep(Result<V> from) {
        if (((INumber)from.getValue()).less((IReal)this.getValue()).getValue()) {
            return IntegerResult.makeStepRangeFromToWithSecond(from, this, ResultFactory.makeResult(this.getTypeFactory().realType().lub(from.getStaticType()), ((INumber)from.getValue()).add(this.getValueFactory().real(1.0)), this.ctx), this.getValueFactory(), this.getTypeFactory(), this.ctx);
        }
        return IntegerResult.makeStepRangeFromToWithSecond(from, this, ResultFactory.makeResult(this.getTypeFactory().realType().lub(from.getStaticType()), ((INumber)from.getValue()).subtract(this.getValueFactory().real(1.0)), this.ctx), this.getValueFactory(), this.getTypeFactory(), this.ctx);
    }
}

