/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.result.out;

import java.net.URI;
import org.rascalmpl.parser.gtd.location.PositionStore;
import org.rascalmpl.parser.gtd.result.AbstractNode;
import org.rascalmpl.parser.gtd.result.ExpandableContainerNode;
import org.rascalmpl.parser.gtd.result.action.IActionExecutor;
import org.rascalmpl.parser.gtd.result.out.FilteringTracker;
import org.rascalmpl.parser.gtd.result.out.INodeConstructorFactory;
import org.rascalmpl.parser.gtd.result.out.INodeFlattener;
import org.rascalmpl.parser.gtd.result.struct.Link;
import org.rascalmpl.parser.gtd.util.ArrayList;
import org.rascalmpl.parser.gtd.util.ForwardLink;
import org.rascalmpl.parser.gtd.util.HashMap;
import org.rascalmpl.parser.gtd.util.IndexedStack;

public class ListContainerNodeFlattener<P, T, S> {
    private static final ForwardLink<AbstractNode> NO_NODES = ForwardLink.TERMINATOR;
    private static final Object[] NO_CHILDREN = new Object[0];
    private final T[] noChildren = NO_CHILDREN;

    private Object buildAlternative(INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory, T[] prefix, ForwardLink<AbstractNode> postFix, Object production, ArrayList<T> gatheredAlternatives, IndexedStack<AbstractNode> stack, int depth, PositionStore positionStore, int offset, int endOffset, FilteringTracker filteringTracker, IActionExecutor<T> actionExecutor, Object environment) {
        Object newEnvironment = actionExecutor.enteringListProduction(production, environment);
        ArrayList<T> children = new ArrayList<T>();
        for (int i = 0; i < prefix.length; ++i) {
            children.add(prefix[i]);
        }
        int index = prefix.length - 1;
        int postFixLength = postFix.length;
        for (int i = 0; i < postFixLength; ++i) {
            AbstractNode node = (AbstractNode)postFix.element;
            int maxAmbDepth = postFix.maxAmbDepth;
            postFix = postFix.next;
            newEnvironment = actionExecutor.enteringListNode(production, index++, newEnvironment);
            if (!(node instanceof CycleNode)) {
                T constructedNode = converter.convert(nodeConstructorFactory, node, stack, depth, positionStore, filteringTracker, actionExecutor, newEnvironment, INodeFlattener.CacheMode.CACHE_MODE_NONE, maxAmbDepth);
                if (constructedNode == null) {
                    actionExecutor.exitedListProduction(production, true, newEnvironment);
                    return null;
                }
                children.add(constructedNode);
                continue;
            }
            CycleNode cycleNode = (CycleNode)node;
            T[] constructedCycle = this.constructCycle(converter, nodeConstructorFactory, production, cycleNode, stack, depth, positionStore, offset, endOffset, filteringTracker, actionExecutor, newEnvironment, maxAmbDepth);
            if (constructedCycle == null) {
                actionExecutor.exitedListProduction(production, true, newEnvironment);
                return null;
            }
            int constructedCycleLength = constructedCycle.length;
            if (constructedCycleLength == 1) {
                children.add(constructedCycle[0]);
                continue;
            }
            for (int j = 0; j < constructedCycleLength; ++j) {
                children.add(constructedCycle[j]);
            }
        }
        T result = nodeConstructorFactory.createListNode(children, production);
        if ((result = actionExecutor.filterListProduction(result, newEnvironment)) == null) {
            filteringTracker.setLastFiltered(offset, endOffset);
            actionExecutor.exitedListProduction(production, true, newEnvironment);
            return null;
        }
        actionExecutor.exitedListProduction(production, false, newEnvironment);
        gatheredAlternatives.add(result);
        return newEnvironment;
    }

    private T[] constructCycle(INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory, Object production, CycleNode cycleNode, IndexedStack<AbstractNode> stack, int depth, PositionStore positionStore, int offset, int endOffset, FilteringTracker filteringTracker, IActionExecutor<T> actionExecutor, Object environment, int maxAmbDepth) {
        Object[] convertedCycle;
        Object newEnvironment = actionExecutor.enteringListProduction(production, environment);
        AbstractNode[] cycleElements = cycleNode.cycle;
        int nrOfCycleElements = cycleElements.length;
        if (nrOfCycleElements == 1) {
            convertedCycle = new Object[1];
            T element = converter.convert(nodeConstructorFactory, cycleElements[0], stack, depth, positionStore, filteringTracker, actionExecutor, newEnvironment = actionExecutor.enteringListNode(production, 0, newEnvironment), INodeFlattener.CacheMode.CACHE_MODE_NONE, maxAmbDepth);
            if (element == null) {
                actionExecutor.exitedListProduction(production, true, newEnvironment);
                return null;
            }
            convertedCycle[0] = element;
        } else {
            convertedCycle = new Object[nrOfCycleElements + 1];
            newEnvironment = actionExecutor.enteringListNode(production, 0, newEnvironment);
            convertedCycle[0] = converter.convert(nodeConstructorFactory, cycleElements[nrOfCycleElements - 1], stack, depth, positionStore, filteringTracker, actionExecutor, newEnvironment, INodeFlattener.CacheMode.CACHE_MODE_NONE, maxAmbDepth);
            for (int i = 0; i < nrOfCycleElements; ++i) {
                T element = converter.convert(nodeConstructorFactory, cycleElements[i], stack, depth, positionStore, filteringTracker, actionExecutor, newEnvironment = actionExecutor.enteringListNode(production, i + 1, newEnvironment), INodeFlattener.CacheMode.CACHE_MODE_NONE, maxAmbDepth);
                if (element == null) {
                    actionExecutor.exitedListProduction(production, true, newEnvironment);
                    return null;
                }
                convertedCycle[i + 1] = element;
            }
        }
        T cycle = nodeConstructorFactory.createSubListCycleNode(production);
        cycle = actionExecutor.filterListCycle(cycle, environment);
        if (cycle == null) {
            return convertedCycle;
        }
        ArrayList<Object> children = new ArrayList<Object>();
        int convertedCycleLength = convertedCycle.length;
        for (int i = 0; i < convertedCycleLength; ++i) {
            children.add(convertedCycle[i]);
        }
        T elements = nodeConstructorFactory.createListNode(children, production);
        if ((elements = actionExecutor.filterListProduction(elements, newEnvironment)) == null) {
            filteringTracker.setLastFiltered(offset, endOffset);
            actionExecutor.exitedListProduction(production, true, newEnvironment);
            return null;
        }
        actionExecutor.exitedListProduction(production, false, newEnvironment);
        ArrayList<T> alternatives = new ArrayList<T>();
        alternatives.add(elements);
        alternatives.add(cycle);
        T constructedCycle = nodeConstructorFactory.createSubListAmbiguityNode(alternatives);
        constructedCycle = actionExecutor.filterListAmbiguity(constructedCycle, newEnvironment);
        if (constructedCycle == null) {
            filteringTracker.setLastFiltered(offset, endOffset);
            return null;
        }
        return new Object[]{constructedCycle};
    }

    protected void gatherAlternatives(INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory, Link child, ArrayList<T> gatheredAlternatives, Object production, IndexedStack<AbstractNode> stack, int depth, HashMap<ArrayList<Link>, SharedPrefix<T>> sharedPrefixCache, PositionStore positionStore, int offset, int endOffset, FilteringTracker filteringTracker, IActionExecutor<T> actionExecutor, Object environment, int maxAmbDepth) {
        AbstractNode childNode = child.getNode();
        if (!childNode.isEpsilon() || child.getPrefixes() != null) {
            CycleNode cycle;
            ArrayList<AbstractNode> blackList = new ArrayList<AbstractNode>();
            if (childNode.isEmpty() && (cycle = this.gatherCycle(child, new AbstractNode[]{childNode}, blackList)) != null) {
                if (cycle.cycle.length == 1) {
                    this.gatherProduction(converter, nodeConstructorFactory, child, new ForwardLink<AbstractNode>(NO_NODES, cycle, maxAmbDepth), gatheredAlternatives, production, stack, depth, sharedPrefixCache, positionStore, blackList, offset, endOffset, filteringTracker, actionExecutor, environment);
                } else {
                    ForwardLink<CycleNode> cycleLink = new ForwardLink<CycleNode>(NO_NODES, cycle, maxAmbDepth);
                    this.gatherProduction(converter, nodeConstructorFactory, child, new ForwardLink<AbstractNode>(cycleLink, childNode, maxAmbDepth), gatheredAlternatives, production, stack, depth, sharedPrefixCache, positionStore, blackList, offset, endOffset, filteringTracker, actionExecutor, environment);
                }
                return;
            }
            this.gatherProduction(converter, nodeConstructorFactory, child, new ForwardLink<AbstractNode>(NO_NODES, childNode, maxAmbDepth), gatheredAlternatives, production, stack, depth, sharedPrefixCache, positionStore, blackList, offset, endOffset, filteringTracker, actionExecutor, environment);
        } else {
            this.buildAlternative(converter, nodeConstructorFactory, this.noChildren, NO_NODES, production, gatheredAlternatives, stack, depth, positionStore, offset, endOffset, filteringTracker, actionExecutor, environment);
        }
    }

    private void gatherProduction(INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory, Link child, ForwardLink<AbstractNode> postFix, ArrayList<T> gatheredAlternatives, Object production, IndexedStack<AbstractNode> stack, int depth, HashMap<ArrayList<Link>, SharedPrefix<T>> sharedPrefixCache, PositionStore positionStore, ArrayList<AbstractNode> blackList, int offset, int endOffset, FilteringTracker filteringTracker, IActionExecutor<T> actionExecutor, Object environment) {
        ArrayList<Link> prefixes;
        while (true) {
            CycleNode cycle;
            if ((prefixes = child.getPrefixes()) == null) {
                this.buildAlternative(converter, nodeConstructorFactory, this.noChildren, postFix, production, gatheredAlternatives, stack, depth, positionStore, offset, endOffset, filteringTracker, actionExecutor, environment);
                return;
            }
            if (prefixes.size() != 1 && (postFix.maxAmbDepth > 0 || prefixes.size() <= 1)) break;
            Link prefix = prefixes.get(0);
            if (prefix == null) {
                this.buildAlternative(converter, nodeConstructorFactory, this.noChildren, postFix, production, gatheredAlternatives, stack, depth, positionStore, offset, endOffset, filteringTracker, actionExecutor, environment);
                return;
            }
            AbstractNode prefixNode = prefix.getNode();
            if (blackList.contains(prefixNode)) {
                return;
            }
            if (prefixNode.isEmpty() && !prefixNode.isNonterminalSeparator() && (cycle = this.gatherCycle(prefix, new AbstractNode[]{prefixNode}, blackList)) != null) {
                prefixNode = cycle;
            }
            child = prefix;
            postFix = new ForwardLink<AbstractNode>(postFix, prefixNode, postFix.maxAmbDepth);
        }
        postFix = new ForwardLink<AbstractNode>(postFix, postFix.maxAmbDepth - 1);
        this.gatherAmbiguousProduction(converter, nodeConstructorFactory, prefixes, postFix, gatheredAlternatives, production, stack, depth, sharedPrefixCache, positionStore, blackList, offset, endOffset, filteringTracker, actionExecutor, environment);
    }

    private void gatherAmbiguousProduction(INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory, ArrayList<Link> prefixes, ForwardLink<AbstractNode> postFix, ArrayList<T> gatheredAlternatives, Object production, IndexedStack<AbstractNode> stack, int depth, HashMap<ArrayList<Link>, SharedPrefix<T>> sharedPrefixCache, PositionStore positionStore, ArrayList<AbstractNode> blackList, int offset, int endOffset, FilteringTracker filteringTracker, IActionExecutor<T> actionExecutor, Object environment) {
        SharedPrefix<T> sharedPrefix = sharedPrefixCache.get(prefixes);
        if (sharedPrefix != null) {
            T[] cachedPrefix = sharedPrefix.prefix;
            if (cachedPrefix != null) {
                this.buildAlternative(converter, nodeConstructorFactory, cachedPrefix, postFix, production, gatheredAlternatives, stack, depth, positionStore, offset, endOffset, filteringTracker, actionExecutor, sharedPrefix.environment);
            }
            for (int i = prefixes.size() - 1; i >= 0; --i) {
                if (prefixes.get(i) != null) continue;
                this.buildAlternative(converter, nodeConstructorFactory, this.noChildren, postFix, production, gatheredAlternatives, stack, depth, positionStore, offset, endOffset, filteringTracker, actionExecutor, environment);
            }
            return;
        }
        ArrayList gatheredPrefixes = new ArrayList();
        for (int i = prefixes.size() - 1; i >= 0; --i) {
            CycleNode cycle;
            Link prefix = prefixes.get(i);
            if (prefix == null) {
                this.buildAlternative(converter, nodeConstructorFactory, this.noChildren, postFix, production, gatheredAlternatives, stack, depth, positionStore, offset, endOffset, filteringTracker, actionExecutor, environment);
                continue;
            }
            AbstractNode prefixNode = prefix.getNode();
            if (blackList.contains(prefixNode)) continue;
            if (prefixNode.isEmpty() && !prefixNode.isNonterminalSeparator() && (cycle = this.gatherCycle(prefix, new AbstractNode[]{prefixNode}, blackList)) != null) {
                this.gatherProduction(converter, nodeConstructorFactory, prefix, new ForwardLink<AbstractNode>(NO_NODES, cycle, postFix.maxAmbDepth), gatheredPrefixes, production, stack, depth, sharedPrefixCache, positionStore, blackList, offset, endOffset, filteringTracker, actionExecutor, environment);
                continue;
            }
            this.gatherProduction(converter, nodeConstructorFactory, prefix, new ForwardLink<AbstractNode>(NO_NODES, prefixNode, postFix.maxAmbDepth), gatheredPrefixes, production, stack, depth, sharedPrefixCache, positionStore, blackList, offset, endOffset, filteringTracker, actionExecutor, environment);
        }
        int nrOfGatheredPrefixes = gatheredPrefixes.size();
        if (nrOfGatheredPrefixes == 1) {
            Object prefixAlternative = gatheredPrefixes.get(0);
            ArrayList<T> prefixAlternativeChildrenList = nodeConstructorFactory.getChildren(prefixAlternative);
            int prefixLength = prefixAlternativeChildrenList.size();
            Object[] prefixAlternativeChildren = new Object[prefixLength];
            for (int i = prefixLength - 1; i >= 0; --i) {
                prefixAlternativeChildren[i] = prefixAlternativeChildrenList.get(i);
            }
            Object newEnvironment = this.buildAlternative(converter, nodeConstructorFactory, prefixAlternativeChildren, postFix, production, gatheredAlternatives, stack, depth, positionStore, offset, endOffset, filteringTracker, actionExecutor, environment);
            sharedPrefixCache.put(prefixes, new SharedPrefix<Object>((T[])(newEnvironment != null ? prefixAlternativeChildren : null), newEnvironment));
        } else if (nrOfGatheredPrefixes > 0) {
            ArrayList<T> alternatives = new ArrayList<T>();
            for (int i = nrOfGatheredPrefixes - 1; i >= 0; --i) {
                Object prefixAlternative = gatheredPrefixes.get(i);
                ArrayList<T> prefixAlternativeChildrenList = nodeConstructorFactory.getChildren(prefixAlternative);
                T alternativeSubList = nodeConstructorFactory.createSubListNode(prefixAlternativeChildrenList, production);
                alternatives.add(alternativeSubList);
            }
            T prefixResult = nodeConstructorFactory.createSubListAmbiguityNode(alternatives);
            if ((prefixResult = actionExecutor.filterListAmbiguity(prefixResult, environment)) == null) {
                filteringTracker.setLastFiltered(offset, endOffset);
                sharedPrefixCache.put(prefixes, new SharedPrefix(null, null));
                return;
            }
            if (!nodeConstructorFactory.isAmbiguityNode(prefixResult) && nodeConstructorFactory.getRhs(nodeConstructorFactory.getProductionFromNode(prefixResult)).equals(nodeConstructorFactory.getRhs(production))) {
                Object filteredAlternative = gatheredPrefixes.get(0);
                ArrayList<T> filteredAlternativeChildrenList = nodeConstructorFactory.getChildren(filteredAlternative);
                int prefixLength = filteredAlternativeChildrenList.size();
                Object[] filteredAlternativeChildren = new Object[prefixLength];
                for (int i = prefixLength - 1; i >= 0; --i) {
                    filteredAlternativeChildren[i] = filteredAlternativeChildrenList.get(i);
                }
                Object newEnvironment = this.buildAlternative(converter, nodeConstructorFactory, filteredAlternativeChildren, postFix, production, gatheredAlternatives, stack, depth, positionStore, offset, endOffset, filteringTracker, actionExecutor, environment);
                sharedPrefixCache.put(prefixes, new SharedPrefix<Object>((T[])(newEnvironment != null ? filteredAlternativeChildren : null), newEnvironment));
                return;
            }
            Object[] prefixNodes = new Object[]{prefixResult};
            Object newEnvironment = this.buildAlternative(converter, nodeConstructorFactory, prefixNodes, postFix, production, gatheredAlternatives, stack, depth, positionStore, offset, endOffset, filteringTracker, actionExecutor, environment);
            sharedPrefixCache.put(prefixes, new SharedPrefix<Object>((T[])(newEnvironment != null ? prefixNodes : null), newEnvironment));
        }
    }

    private CycleNode gatherCycle(Link child, AbstractNode[] postFix, ArrayList<AbstractNode> blackList) {
        AbstractNode originNode = child.getNode();
        blackList.add(originNode);
        block0: while (true) {
            ArrayList<Link> prefixes;
            if ((prefixes = child.getPrefixes()) == null) {
                return null;
            }
            int nrOfPrefixes = prefixes.size();
            for (int i = nrOfPrefixes - 1; i >= 0; --i) {
                Link prefix = prefixes.get(i);
                if (prefix == null) continue;
                AbstractNode prefixNode = prefix.getNode();
                if (prefixNode == originNode) {
                    return new CycleNode(postFix);
                }
                if (!prefixNode.isEmpty()) continue;
                int length = postFix.length;
                AbstractNode[] newPostFix = new AbstractNode[length + 1];
                System.arraycopy(postFix, 0, newPostFix, 1, length);
                newPostFix[0] = prefixNode;
                child = prefix;
                postFix = newPostFix;
                continue block0;
            }
            break;
        }
        return null;
    }

    public T convertToUPTR(INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory, ExpandableContainerNode<P> node, IndexedStack<AbstractNode> stack, int depth, PositionStore positionStore, FilteringTracker filteringTracker, IActionExecutor<T> actionExecutor, Object environment, int maxAmbDepth) {
        int index;
        int offset = node.getOffset();
        int endOffset = node.getEndOffset();
        Object sourceLocation = null;
        URI input = node.getInput();
        if (!node.isLayout() && input != null) {
            sourceLocation = nodeConstructorFactory.createPositionInformation(input, offset, endOffset, positionStore);
        }
        if ((index = stack.contains(node)) != -1) {
            T cycle = nodeConstructorFactory.createCycleNode(depth - index, node.getFirstProduction());
            if ((cycle = actionExecutor.filterListCycle(cycle, environment)) != null) {
                if (sourceLocation != null) {
                    cycle = nodeConstructorFactory.addPositionInformation(cycle, (S)sourceLocation);
                }
            } else {
                filteringTracker.setLastFiltered(offset, endOffset);
            }
            return cycle;
        }
        int childDepth = depth + 1;
        stack.push(node, depth);
        HashMap<ArrayList<Link>, SharedPrefix<T>> sharedPrefixCache = new HashMap<ArrayList<Link>, SharedPrefix<T>>();
        ArrayList gatheredAlternatives = new ArrayList();
        this.gatherAlternatives(converter, nodeConstructorFactory, node.getFirstAlternative(), gatheredAlternatives, node.getFirstProduction(), stack, childDepth, sharedPrefixCache, positionStore, offset, endOffset, filteringTracker, actionExecutor, environment, maxAmbDepth);
        ArrayList<Link> alternatives = node.getAdditionalAlternatives();
        ArrayList productions = node.getAdditionalProductions();
        if (alternatives != null) {
            for (int i = alternatives.size() - 1; i >= 0; --i) {
                this.gatherAlternatives(converter, nodeConstructorFactory, alternatives.get(i), gatheredAlternatives, productions.get(i), stack, childDepth, sharedPrefixCache, positionStore, offset, endOffset, filteringTracker, actionExecutor, environment, maxAmbDepth);
            }
        }
        Object result = null;
        int nrOfAlternatives = gatheredAlternatives.size();
        if (nrOfAlternatives == 1) {
            result = gatheredAlternatives.get(0);
            if (sourceLocation != null) {
                result = nodeConstructorFactory.addPositionInformation(result, sourceLocation);
            }
        } else if (nrOfAlternatives > 0) {
            for (int i = nrOfAlternatives - 1; i >= 0; --i) {
                Object alt = gatheredAlternatives.get(i);
                if (sourceLocation == null) continue;
                alt = nodeConstructorFactory.addPositionInformation(alt, (S)sourceLocation);
            }
            result = nodeConstructorFactory.createListAmbiguityNode(gatheredAlternatives);
            if ((result = actionExecutor.filterListAmbiguity(result, environment)) != null) {
                if (sourceLocation != null) {
                    result = nodeConstructorFactory.addPositionInformation(result, sourceLocation);
                }
            } else {
                filteringTracker.setLastFiltered(offset, endOffset);
            }
        }
        stack.dirtyPurge();
        return result;
    }

    protected static class SharedPrefix<T> {
        public final T[] prefix;
        public final Object environment;

        public SharedPrefix(T[] prefix, Object environment) {
            this.prefix = prefix;
            this.environment = environment;
        }
    }

    protected static class CycleNode
    extends AbstractNode {
        public final AbstractNode[] cycle;

        public CycleNode(AbstractNode[] cycle) {
            this.cycle = cycle;
        }

        @Override
        public int getTypeIdentifier() {
            throw new UnsupportedOperationException("CycleNode does not have an ID, it's for internal use only.");
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        public boolean isRejected() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isNonterminalSeparator() {
            throw new UnsupportedOperationException();
        }

        public void setRejected() {
            throw new UnsupportedOperationException();
        }
    }
}

