/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack.filter.follow;

import org.rascalmpl.parser.gtd.location.PositionStore;
import org.rascalmpl.parser.gtd.stack.filter.ICompletionFilter;

public class StringFollowRequirement
implements ICompletionFilter {
    private final int[] string;

    public StringFollowRequirement(int[] string) {
        this.string = string;
    }

    @Override
    public boolean isFiltered(int[] input, int start, int end, PositionStore positionStore) {
        if (end + this.string.length - 1 >= input.length) {
            return true;
        }
        for (int i = this.string.length - 1; i >= 0; --i) {
            if (input[end + i] == this.string[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEqual(ICompletionFilter otherCompletionFilter) {
        if (!(otherCompletionFilter instanceof StringFollowRequirement)) {
            return false;
        }
        StringFollowRequirement otherStringFollowFilter = (StringFollowRequirement)otherCompletionFilter;
        int[] otherString = otherStringFollowFilter.string;
        if (this.string.length != otherString.length) {
            return false;
        }
        for (int i = this.string.length - 1; i >= 0; --i) {
            if (this.string[i] == otherString[i]) continue;
            return false;
        }
        return true;
    }
}

