/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.semantics.dynamic;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Iterator;
import java.util.List;
import org.rascalmpl.ast.Name;
import org.rascalmpl.ast.QualifiedName;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.utils.Names;

public abstract class QualifiedName
extends org.rascalmpl.ast.QualifiedName {
    public QualifiedName(ISourceLocation __param1, IConstructor tree) {
        super(__param1, tree);
    }

    public static class Default
    extends QualifiedName.Default {
        private static final TypeFactory TF = TypeFactory.getInstance();
        private final String lastName;
        private String fullName;
        private String moduleName;

        public Default(ISourceLocation __param1, IConstructor tree, List<Name> __param2) {
            super(__param1, tree, __param2);
            this.lastName = ((Name.Lexical)__param2.get(__param2.size() - 1)).getString();
        }

        public boolean isQualified() {
            return this.getNames().size() > 1;
        }

        public String lastName() {
            return this.lastName;
        }

        public String moduleName() {
            if (this.moduleName == null) {
                List<Name> names = this.getNames();
                List<Name> prefix = names.subList(0, names.size() - 1);
                if (prefix.size() == 0) {
                    return null;
                }
                StringBuilder tmp = new StringBuilder(names.size() * 20);
                Iterator<Name> iter = prefix.iterator();
                while (iter.hasNext()) {
                    tmp.append(((Name.Lexical)iter.next()).getString());
                    if (!iter.hasNext()) continue;
                    tmp.append("::");
                }
                this.moduleName = tmp.toString();
            }
            return this.moduleName;
        }

        public String fullName() {
            if (this.fullName == null) {
                List<Name> names = this.getNames();
                List<Name> prefix = names.subList(0, names.size() - 1);
                if (prefix.size() == 0) {
                    return ((Name.Lexical)names.get(0)).getString();
                }
                StringBuilder tmp = new StringBuilder(names.size() * 20);
                Iterator<Name> iter = prefix.iterator();
                while (iter.hasNext()) {
                    String part = Names.name(iter.next());
                    tmp.append(part);
                    if (!iter.hasNext()) continue;
                    tmp.append("::");
                }
                tmp.append("::");
                tmp.append(((Name.Lexical)names.get(names.size() - 1)).getString());
                this.fullName = tmp.toString();
            }
            return this.fullName;
        }

        @Override
        public Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            if (this.getNames().size() == 1 && Names.name(this.getNames().get(0)).equals("_")) {
                return TF.valueType();
            }
            Result<IValue> varRes = env.getVariable(this);
            if (varRes == null || varRes.getStaticType() == null) {
                return TF.valueType();
            }
            return varRes.getStaticType();
        }
    }
}

