/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.locations;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.usethesource.vallang.ISourceLocation;
import java.time.Duration;
import java.util.function.Function;
import org.rascalmpl.util.locations.LineColumnOffsetMap;
import org.rascalmpl.util.locations.impl.ArrayLineOffsetMap;

public class ColumnMaps {
    private final LoadingCache<ISourceLocation, LineColumnOffsetMap> currentEntries = Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).softValues().build(l -> ArrayLineOffsetMap.build((String)getContents.apply((ISourceLocation)l)));

    public ColumnMaps(Function<ISourceLocation, String> getContents) {
    }

    public LineColumnOffsetMap get(ISourceLocation sloc) {
        return this.currentEntries.get(sloc.top());
    }

    public void clear(ISourceLocation sloc) {
        this.currentEntries.invalidate(sloc.top());
    }
}

