/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.maven;

import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISourceLocation;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.InputLocation;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.library.Messages;
import org.rascalmpl.util.maven.ArtifactCoordinate;
import org.rascalmpl.util.maven.Scope;

class Dependency {
    private final ArtifactCoordinate coordinate;
    private final Scope scope;
    private final @Nullable String systemPath;
    private final boolean optional;
    private final Set<ArtifactCoordinate.WithoutVersion> exclusions;
    private final ISourceLocation pomLocation;
    private final int line;
    private final int column;

    private Dependency(ArtifactCoordinate coordinate, Scope scope, @Nullable String systemPath, boolean optional, Set<ArtifactCoordinate.WithoutVersion> exclusions, ISourceLocation pomLocation, int line, int column) {
        this.coordinate = coordinate;
        this.scope = scope;
        this.systemPath = systemPath;
        this.optional = optional;
        this.exclusions = exclusions;
        this.pomLocation = pomLocation;
        this.line = line;
        this.column = column;
    }

    public ArtifactCoordinate getCoordinate() {
        return this.coordinate;
    }

    public Scope getScope() {
        return this.scope;
    }

    public @Nullable String getSystemPath() {
        return this.systemPath;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Set<ArtifactCoordinate.WithoutVersion> getExclusions() {
        return this.exclusions;
    }

    public ISourceLocation getPomLocation() {
        return this.pomLocation;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    static @Nullable Dependency build(org.apache.maven.model.Dependency d, IListWriter messages, ISourceLocation pomLocation) {
        Scope scope;
        String version = d.getVersion();
        if (version == null) {
            messages.append(Messages.error("Dependency " + d.getGroupId() + ":" + d.getArtifactId() + "is missing", pomLocation));
            version = "???";
        }
        ArtifactCoordinate coordinate = new ArtifactCoordinate(d.getGroupId(), d.getArtifactId(), version, d.getClassifier());
        switch (d.getScope() == null ? "compile" : d.getScope()) {
            case "provided": {
                scope = Scope.PROVIDED;
                break;
            }
            case "runtime": {
                scope = Scope.RUNTIME;
                break;
            }
            case "test": {
                scope = Scope.TEST;
                break;
            }
            case "system": {
                scope = Scope.SYSTEM;
                break;
            }
            case "import": {
                scope = Scope.IMPORT;
                break;
            }
            default: {
                scope = Scope.COMPILE;
            }
        }
        Set<ArtifactCoordinate.WithoutVersion> exclusions = d.getExclusions().stream().map(e -> ArtifactCoordinate.versionLess(e.getGroupId(), e.getArtifactId())).collect(Collectors.toUnmodifiableSet());
        int line = -1;
        int column = -1;
        InputLocation loc = d.getLocation("");
        if (loc != null) {
            line = loc.getLineNumber();
            column = loc.getColumnNumber();
        }
        return new Dependency(coordinate, scope, d.getSystemPath(), d.isOptional(), exclusions, pomLocation, line, column);
    }

    public String toString() {
        return this.coordinate.toString() + "@" + this.scope + (this.optional ? "(optional)" : "");
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.coordinate, this.scope, this.systemPath, this.optional, this.exclusions, this.pomLocation});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Dependency)) {
            return false;
        }
        Dependency other = (Dependency)obj;
        return Objects.equals(this.coordinate, other.coordinate) && this.scope == other.scope && Objects.equals(this.systemPath, other.systemPath) && this.optional == other.optional && Objects.equals(this.exclusions, other.exclusions) && Objects.equals(this.pomLocation, other.pomLocation);
    }

    boolean shouldInclude(Scope forScope) {
        if (this.optional) {
            return false;
        }
        if (forScope == this.scope && this.scope != Scope.PROVIDED && this.scope != Scope.TEST) {
            return true;
        }
        switch (forScope) {
            case TEST: {
                if (this.scope == Scope.COMPILE) {
                    return true;
                }
            }
            case COMPILE: {
                if (this.scope == Scope.PROVIDED) {
                    return true;
                }
            }
            case RUNTIME: {
                return this.scope == Scope.SYSTEM;
            }
        }
        return false;
    }
}

