/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.maven;

import io.usethesource.vallang.IValue;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.maven.settings.Proxy;
import org.rascalmpl.library.Messages;
import org.rascalmpl.uri.URIUtil;

class MavenProxySelector
extends ProxySelector {
    private final List<FilteredProxy> filteredProxies = new ArrayList<FilteredProxy>();

    public MavenProxySelector(List<Proxy> mavenProxies, List<IValue> messages) {
        for (Proxy mavenProxy : mavenProxies) {
            if (!mavenProxy.isActive()) continue;
            if (mavenProxy.getUsername() != null || mavenProxy.getPassword() != null) {
                messages.add(Messages.warning("Ignoring proxy '" + mavenProxy.getId() + "' in settings.xml that contains name/password authentication which we currently do not support.", URIUtil.unknownLocation()));
                continue;
            }
            Proxy.Type type = mavenProxy.getProtocol() == "socks5" ? Proxy.Type.SOCKS : Proxy.Type.HTTP;
            java.net.Proxy proxy = new java.net.Proxy(type, new InetSocketAddress(mavenProxy.getHost(), mavenProxy.getPort()));
            this.filteredProxies.add(new FilteredProxy(proxy, mavenProxy.getNonProxyHosts()));
        }
    }

    @Override
    public List<java.net.Proxy> select(URI uri) {
        ArrayList<java.net.Proxy> proxies = new ArrayList<java.net.Proxy>();
        for (FilteredProxy proxy : this.filteredProxies) {
            if (!proxy.isProxyFor(uri.getHost())) continue;
            proxies.add(proxy.getProxy());
        }
        if (proxies.isEmpty()) {
            proxies.add(java.net.Proxy.NO_PROXY);
        }
        return proxies;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }

    private static class FilteredProxy {
        private final java.net.Proxy proxy;
        private final List<Predicate<String>> nonProxyHosts;

        public FilteredProxy(java.net.Proxy proxy, String nonProxyHostSpec) {
            this.proxy = proxy;
            this.nonProxyHosts = new ArrayList<Predicate<String>>();
            for (String pattern : nonProxyHostSpec.split("\\|")) {
                String regex = pattern.replace("*", ".*");
                this.nonProxyHosts.add(Pattern.compile(regex).asMatchPredicate());
            }
        }

        public boolean isProxyFor(String host) {
            for (Predicate<String> isNonProxyHost : this.nonProxyHosts) {
                if (!isNonProxyHost.test(host)) continue;
                return false;
            }
            return true;
        }

        java.net.Proxy getProxy() {
            return this.proxy;
        }
    }
}

