/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AliasType
extends Type {
    private final String fName;
    private final Type fAliased;
    private final Type fParameters;

    AliasType(String name, Type aliased) {
        this.fName = name;
        this.fAliased = aliased;
        this.fParameters = TypeFactory.getInstance().voidType();
    }

    AliasType(String name, Type aliased, Type parameters) {
        this.fName = name;
        this.fAliased = aliased;
        this.fParameters = parameters;
    }

    @Override
    public TypeFactory.TypeReifier getTypeReifier(TypeFactory.TypeValues symbols) {
        return new Info(symbols);
    }

    @Override
    public boolean isParameterized() {
        return !this.fParameters.isBottom();
    }

    @Override
    public boolean isOpen() {
        return this.fParameters.isOpen() || this.fAliased.isOpen();
    }

    @Override
    public boolean isAliased() {
        return true;
    }

    @Override
    public boolean isFixedWidth() {
        return this.fAliased.isFixedWidth();
    }

    @Override
    public Type getTypeParameters() {
        return this.fParameters;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public Type getAliased() {
        return this.fAliased;
    }

    @Override
    protected boolean isSupertypeOf(Type type) {
        return type.isSubtypeOfAlias(this);
    }

    @Override
    public Type lub(Type other) {
        return other.lubWithAlias(this);
    }

    @Override
    public Type glb(Type type) {
        return type.glbWithAlias(this);
    }

    @Override
    protected Type lubWithAlias(Type type) {
        if (this == type) {
            return this;
        }
        if (this.getName().equals(type.getName())) {
            return TypeFactory.getInstance().aliasTypeFromTuple(new TypeStore(new TypeStore[0]), type.getName(), this.getAliased().lub(type.getAliased()), this.getTypeParameters().lub(type.getTypeParameters()));
        }
        return this.getAliased().lub(type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fName);
        if (this.isParameterized()) {
            sb.append("[");
            int idx = 0;
            for (Type elemType : this.fParameters) {
                if (idx++ > 0) {
                    sb.append(",");
                }
                sb.append(elemType.toString());
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public int hashCode() {
        return 49991 + 49831 * this.fName.hashCode() + 67349 * this.fAliased.hashCode() + 1433 * this.fParameters.hashCode();
    }

    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof AliasType) {
            AliasType other = (AliasType)o;
            return this.fName.equals(other.fName) && this.fAliased == other.fAliased && this.fParameters == other.fParameters;
        }
        return false;
    }

    @Override
    public <T, E extends Throwable> T accept(ITypeVisitor<T, E> visitor) throws E {
        return visitor.visitAlias(this);
    }

    @Override
    public int getArity() {
        return this.fAliased.getArity();
    }

    @Override
    public Type getBound() {
        return this.fAliased.getBound();
    }

    @Override
    public Type getElementType() {
        return this.fAliased.getElementType();
    }

    @Override
    public int getFieldIndex(String fieldName) {
        return this.fAliased.getFieldIndex(fieldName);
    }

    @Override
    public String getFieldName(int i) {
        return this.fAliased.getFieldName(i);
    }

    @Override
    public String getKeyLabel() {
        return this.fAliased.getKeyLabel();
    }

    @Override
    public String getValueLabel() {
        return this.fAliased.getValueLabel();
    }

    @Override
    public Type getFieldType(int i) {
        return this.fAliased.getFieldType(i);
    }

    @Override
    public Type getFieldType(String fieldName) {
        return this.fAliased.getFieldType(fieldName);
    }

    @Override
    public Type getFieldTypes() {
        return this.fAliased.getFieldTypes();
    }

    @Override
    public Type getKeyType() {
        return this.fAliased.getKeyType();
    }

    @Override
    public boolean isBottom() {
        return this.fAliased.isBottom();
    }

    @Override
    public Type getValueType() {
        return this.fAliased.getValueType();
    }

    @Override
    public Type compose(Type other) {
        return this.fAliased.compose(other);
    }

    @Override
    public boolean hasFieldNames() {
        return this.fAliased.hasFieldNames();
    }

    @Override
    public boolean hasKeywordField(String fieldName, TypeStore store) {
        return this.fAliased.hasKeywordField(fieldName, store);
    }

    @Override
    public Type instantiate(Map<Type, Type> bindings) {
        if (this.isParameterized()) {
            return TypeFactory.getInstance().getFromCache(new AliasType(this.fName, this.fAliased.instantiate(bindings), this.fParameters.instantiate(bindings)));
        }
        return this;
    }

    @Override
    public boolean match(Type matched, Map<Type, Type> bindings) throws FactTypeUseException {
        return super.match(matched, bindings) && this.fAliased.match(matched, bindings);
    }

    @Override
    public Iterator<Type> iterator() {
        return this.fAliased.iterator();
    }

    @Override
    public Type select(int ... fields) {
        return this.fAliased.select(fields);
    }

    @Override
    public Type select(String ... names) {
        return this.fAliased.select(names);
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.fAliased.hasField(fieldName);
    }

    @Override
    public boolean hasField(String fieldName, TypeStore store) {
        return this.fAliased.hasField(fieldName, store);
    }

    @Override
    protected boolean isSubtypeOfReal(Type type) {
        return this.fAliased.isSubtypeOfReal(type);
    }

    @Override
    protected boolean isSubtypeOfInteger(Type type) {
        return this.fAliased.isSubtypeOfInteger(type);
    }

    @Override
    protected boolean isSubtypeOfRational(Type type) {
        return this.fAliased.isSubtypeOfRational(type);
    }

    @Override
    protected boolean isSubtypeOfList(Type type) {
        return this.fAliased.isSubtypeOfList(type);
    }

    @Override
    protected boolean isSubtypeOfMap(Type type) {
        return this.fAliased.isSubtypeOfMap(type);
    }

    @Override
    protected boolean isSubtypeOfNumber(Type type) {
        return this.fAliased.isSubtypeOfNumber(type);
    }

    @Override
    protected boolean isSubtypeOfSet(Type type) {
        return this.fAliased.isSubtypeOfSet(type);
    }

    @Override
    protected boolean isSubtypeOfSourceLocation(Type type) {
        return this.fAliased.isSubtypeOfSourceLocation(type);
    }

    @Override
    protected boolean isSubtypeOfString(Type type) {
        return this.fAliased.isSubtypeOfString(type);
    }

    @Override
    protected boolean isSubtypeOfNode(Type type) {
        return this.fAliased.isSubtypeOfNode(type);
    }

    @Override
    protected boolean isSubtypeOfConstructor(Type type) {
        return this.fAliased.isSubtypeOfConstructor(type);
    }

    @Override
    protected boolean isSubtypeOfAbstractData(Type type) {
        return this.fAliased.isSubtypeOfAbstractData(type);
    }

    @Override
    protected boolean isSubtypeOfTuple(Type type) {
        return this.fAliased.isSubtypeOfTuple(type);
    }

    @Override
    protected boolean isSubtypeOfFunction(Type type) {
        return this.fAliased.isSubtypeOfFunction(type);
    }

    @Override
    protected boolean isSubtypeOfVoid(Type type) {
        return this.fAliased.isSubtypeOfVoid(type);
    }

    @Override
    protected boolean isSubtypeOfBool(Type type) {
        return this.fAliased.isSubtypeOfBool(type);
    }

    @Override
    protected boolean isSubtypeOfExternal(Type type) {
        return this.fAliased.isSubtypeOfExternal(type);
    }

    @Override
    protected boolean isSubtypeOfDateTime(Type type) {
        return this.fAliased.isSubtypeOfDateTime(type);
    }

    @Override
    protected Type lubWithReal(Type type) {
        return this.fAliased.lubWithReal(type);
    }

    @Override
    protected Type lubWithInteger(Type type) {
        return this.fAliased.lubWithInteger(type);
    }

    @Override
    protected Type lubWithRational(Type type) {
        return this.fAliased.lubWithRational(type);
    }

    @Override
    protected Type lubWithList(Type type) {
        return this.fAliased.lubWithList(type);
    }

    @Override
    protected Type lubWithMap(Type type) {
        return this.fAliased.lubWithMap(type);
    }

    @Override
    protected Type lubWithNumber(Type type) {
        return this.fAliased.lubWithNumber(type);
    }

    @Override
    protected Type lubWithSet(Type type) {
        return this.fAliased.lubWithSet(type);
    }

    @Override
    protected Type lubWithSourceLocation(Type type) {
        return this.fAliased.lubWithSourceLocation(type);
    }

    @Override
    protected Type lubWithString(Type type) {
        return this.fAliased.lubWithString(type);
    }

    @Override
    protected Type lubWithNode(Type type) {
        return this.fAliased.lubWithNode(type);
    }

    @Override
    protected Type lubWithConstructor(Type type) {
        return this.fAliased.lubWithConstructor(type);
    }

    @Override
    protected Type lubWithAbstractData(Type type) {
        return this.fAliased.lubWithAbstractData(type);
    }

    @Override
    protected Type lubWithTuple(Type type) {
        return this.fAliased.lubWithTuple(type);
    }

    @Override
    protected Type lubWithFunction(Type type) {
        return this.fAliased.lubWithFunction(type);
    }

    @Override
    protected Type lubWithValue(Type type) {
        return this.fAliased.lubWithValue(type);
    }

    @Override
    protected Type lubWithVoid(Type type) {
        return this.fAliased.lubWithVoid(type);
    }

    @Override
    protected Type lubWithBool(Type type) {
        return this.fAliased.lubWithBool(type);
    }

    @Override
    protected Type lubWithExternal(Type type) {
        return this.fAliased.lubWithExternal(type);
    }

    @Override
    protected Type lubWithDateTime(Type type) {
        return this.fAliased.lubWithDateTime(type);
    }

    @Override
    protected boolean isSubtypeOfValue(Type type) {
        return true;
    }

    @Override
    protected Type glbWithReal(Type type) {
        return this.fAliased.glbWithReal(type);
    }

    @Override
    protected Type glbWithInteger(Type type) {
        return this.fAliased.glbWithInteger(type);
    }

    @Override
    protected Type glbWithRational(Type type) {
        return this.fAliased.glbWithRational(type);
    }

    @Override
    protected Type glbWithList(Type type) {
        return this.fAliased.glbWithList(type);
    }

    @Override
    protected Type glbWithMap(Type type) {
        return this.fAliased.glbWithMap(type);
    }

    @Override
    protected Type glbWithNumber(Type type) {
        return this.fAliased.glbWithNumber(type);
    }

    @Override
    protected Type glbWithSet(Type type) {
        return this.fAliased.glbWithSet(type);
    }

    @Override
    protected Type glbWithSourceLocation(Type type) {
        return this.fAliased.glbWithSourceLocation(type);
    }

    @Override
    protected Type glbWithString(Type type) {
        return this.fAliased.glbWithString(type);
    }

    @Override
    protected Type glbWithNode(Type type) {
        return this.fAliased.glbWithNode(type);
    }

    @Override
    protected Type glbWithConstructor(Type type) {
        return this.fAliased.glbWithConstructor(type);
    }

    @Override
    protected Type glbWithAlias(Type type) {
        if (this == type) {
            return this;
        }
        if (this.getName().equals(type.getName())) {
            return TypeFactory.getInstance().aliasTypeFromTuple(new TypeStore(new TypeStore[0]), type.getName(), this.getAliased().glb(type.getAliased()), this.getTypeParameters().glb(type.getTypeParameters()));
        }
        return this.getAliased().glb(type);
    }

    @Override
    protected Type glbWithAbstractData(Type type) {
        return this.fAliased.glbWithAbstractData(type);
    }

    @Override
    protected Type glbWithTuple(Type type) {
        return this.fAliased.glbWithTuple(type);
    }

    @Override
    protected Type glbWithFunction(Type type) {
        return this.fAliased.glbWithFunction(type);
    }

    @Override
    protected Type glbWithValue(Type type) {
        return this.fAliased.glbWithValue(type);
    }

    @Override
    protected Type glbWithVoid(Type type) {
        return this.fAliased.glbWithVoid(type);
    }

    @Override
    protected Type glbWithBool(Type type) {
        return this.fAliased.glbWithBool(type);
    }

    @Override
    protected Type glbWithExternal(Type type) {
        return this.fAliased.glbWithExternal(type);
    }

    @Override
    protected Type glbWithDateTime(Type type) {
        return this.fAliased.glbWithDateTime(type);
    }

    @Override
    public Type getAbstractDataType() {
        return this.fAliased.getAbstractDataType();
    }

    @Override
    public IValue randomValue(Random random, TypeFactory.RandomTypesConfig typesConfig, IValueFactory vf, TypeStore store, Map<Type, Type> typeParameters, int maxDepth, int maxBreadth) {
        return this.getAliased().randomValue(random, typesConfig, vf, store, typeParameters, maxDepth, maxBreadth);
    }

    @Override
    public boolean intersects(Type other) {
        return false;
    }

    @Override
    protected boolean intersectsWithReal(Type type) {
        return this.fAliased.intersectsWithReal(type);
    }

    @Override
    protected boolean intersectsWithInteger(Type type) {
        return this.fAliased.intersectsWithInteger(type);
    }

    @Override
    protected boolean intersectsWithRational(Type type) {
        return this.fAliased.intersectsWithRational(type);
    }

    @Override
    protected boolean intersectsWithList(Type type) {
        return this.fAliased.intersectsWithList(type);
    }

    @Override
    protected boolean intersectsWithMap(Type type) {
        return this.fAliased.intersectsWithMap(type);
    }

    @Override
    protected boolean intersectsWithNumber(Type type) {
        return this.fAliased.intersectsWithNumber(type);
    }

    @Override
    protected boolean intersectsWithSet(Type type) {
        return this.fAliased.intersectsWithSet(type);
    }

    @Override
    protected boolean intersectsWithSourceLocation(Type type) {
        return this.fAliased.intersectsWithSourceLocation(type);
    }

    @Override
    protected boolean intersectsWithString(Type type) {
        return this.fAliased.intersectsWithString(type);
    }

    @Override
    protected boolean intersectsWithNode(Type type) {
        return this.fAliased.intersectsWithNode(type);
    }

    @Override
    protected boolean intersectsWithConstructor(Type type) {
        return this.fAliased.intersectsWithConstructor(type);
    }

    @Override
    protected boolean intersectsWithAbstractData(Type type) {
        return this.fAliased.intersectsWithAbstractData(type);
    }

    @Override
    protected boolean intersectsWithTuple(Type type) {
        return this.fAliased.intersectsWithTuple(type);
    }

    @Override
    protected boolean intersectsWithFunction(Type type) {
        return this.fAliased.intersectsWithFunction(type);
    }

    @Override
    protected boolean intersectsWithValue(Type type) {
        return this.fAliased.intersectsWithValue(type);
    }

    @Override
    protected boolean intersectsWithVoid(Type type) {
        return this.fAliased.intersectsWithVoid(type);
    }

    @Override
    protected boolean intersectsWithBool(Type type) {
        return this.fAliased.intersectsWithBool(type);
    }

    @Override
    protected boolean intersectsWithExternal(Type type) {
        return this.fAliased.intersectsWithExternal(type);
    }

    @Override
    protected boolean intersectsWithDateTime(Type type) {
        return this.fAliased.intersectsWithDateTime(type);
    }

    public static class Info
    extends TypeFactory.TypeReifier {
        public Info(TypeFactory.TypeValues symbols) {
            super(symbols);
        }

        @Override
        public Type getSymbolConstructorType() {
            return this.symbols().typeSymbolConstructor("alias", Type.TF.stringType(), "name", Type.TF.listType(this.symbols().symbolADT()), "parameters", this.symbols().symbolADT(), "aliased");
        }

        @Override
        public Type fromSymbol(IConstructor symbol, TypeStore store, Function<IConstructor, Set<IConstructor>> grammar) {
            String name = ((IString)symbol.get("name")).getValue();
            Type aliased = this.symbols().fromSymbol((IConstructor)symbol.get("aliased"), store, grammar);
            IList parameters = (IList)symbol.get("parameters");
            if (parameters.isEmpty()) {
                return aliased;
            }
            Type params = this.symbols().fromSymbols(parameters, store, grammar);
            return params.isOpen() ? Type.TF.aliasTypeFromTuple(store, name, aliased, params) : aliased;
        }

        @Override
        public IConstructor toSymbol(Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            return type.getAliased().asSymbol(vf, store, grammar, done);
        }

        @Override
        public void asProductions(Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            type.getAliased().asProductions(vf, store, grammar, done);
            type.getTypeParameters().asProductions(vf, store, grammar, done);
        }

        @Override
        public Type randomInstance(BiFunction<TypeStore, TypeFactory.RandomTypesConfig, Type> next, TypeStore store, TypeFactory.RandomTypesConfig rnd) {
            if (!rnd.isWithAliases()) {
                return this.tf().randomType(store, rnd);
            }
            return this.tf().aliasType(store, this.randomLabel(rnd), this.tf().randomType(store, rnd), new Type[0]);
        }
    }
}

