/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.FunctionDeclaration;
import org.rascalmpl.ast.Tag;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.exceptions.StackTrace;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.control_exceptions.MatchFailed;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.result.NamedFunction;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.StaticError;
import org.rascalmpl.interpreter.utils.JavaBridge;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.uri.URIUtil;

public class JavaMethod
extends NamedFunction {
    private final Object instance;
    private final Method method;
    private final boolean hasReflectiveAccess;
    private final JavaBridge javaBridge;

    public JavaMethod(IEvaluator<Result<IValue>> eval, FunctionDeclaration func, boolean varargs, Environment env, JavaBridge javaBridge) {
        this(eval, func.getSignature().typeOf(env, eval, false), func.getSignature().typeOf(env, eval, false).instantiate(env.getDynamicTypeBindings()), func, JavaMethod.hasTestMod(func.getSignature()), JavaMethod.isDefault(func), varargs, env, javaBridge);
    }

    @Override
    public Type getFormals() {
        FunctionDeclaration func = (FunctionDeclaration)this.getAst();
        List<Expression> formals = func.getSignature().getParameters().getFormals().getFormals();
        int arity = formals.size();
        Type[] types = new Type[arity];
        String[] labels = new String[arity];
        Type ft = this.getFunctionType();
        for (int i = 0; i < arity; ++i) {
            types[i] = ft.getFieldType(i);
            assert (formals.get(i).isTypedVariable());
            labels[i] = Names.name(formals.get(i).getName());
        }
        return TF.tupleType(types, labels);
    }

    private JavaMethod(IEvaluator<Result<IValue>> eval, Type staticType, Type dynamicType, FunctionDeclaration func, boolean varargs, boolean isTest, boolean isDefault, Environment env, JavaBridge javaBridge) {
        super(func, eval, staticType, dynamicType, JavaMethod.getFormals(func), Names.name(func.getSignature().getName()), isDefault, isTest, varargs, env);
        this.javaBridge = javaBridge;
        this.hasReflectiveAccess = this.hasReflectiveAccess(func);
        this.instance = javaBridge.getJavaClassInstance(func, eval.getMonitor(), env.getStore(), eval.getOutPrinter(), eval.getErrorPrinter(), eval.getInput(), eval);
        this.method = javaBridge.lookupJavaMethod(eval, func, env, this.hasReflectiveAccess);
    }

    @Override
    public JavaMethod cloneInto(Environment env) {
        return new JavaMethod(this.getEval(), this.getFunctionType(), this.getType(), (FunctionDeclaration)this.getAst(), this.isDefault, this.isTest, this.hasVarArgs, env, this.javaBridge);
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    private boolean hasReflectiveAccess(FunctionDeclaration func) {
        for (Tag tag : func.getTags().getTags()) {
            if (!Names.name(tag.getName()).equals("reflect")) continue;
            return true;
        }
        return false;
    }

    @Override
    public Result<IValue> call(Type[] actualStaticTypes, IValue[] actuals, Map<String, IValue> keyArgValues) {
        Type actualTypesTuple;
        Result<IValue> resultValue = this.getMemoizedResult(actuals, keyArgValues);
        if (resultValue != null) {
            return resultValue;
        }
        Type formals = this.getFormals();
        if (this.hasVarArgs) {
            actuals = this.computeVarArgsActuals(actuals, formals);
            actualTypesTuple = this.computeVarArgsActualTypes(actualStaticTypes, formals);
        } else {
            actualTypesTuple = TF.tupleType(actualStaticTypes);
        }
        if (!actualTypesTuple.isSubtypeOf(formals)) {
            throw new MatchFailed();
        }
        Object[] oActuals = this.addKeywordActuals(actuals, formals, keyArgValues);
        if (this.hasReflectiveAccess) {
            oActuals = this.addCtxActual(oActuals);
        }
        if (this.eval.getCallTracing()) {
            this.printStartTrace(actuals);
        }
        Environment old = this.ctx.getCurrentEnvt();
        try {
            this.ctx.pushEnv(this.getName());
            Environment env = this.ctx.getCurrentEnvt();
            HashMap<Type, Type> renamings = new HashMap<Type, Type>();
            HashMap<Type, Type> dynamicRenamings = new HashMap<Type, Type>();
            this.bindTypeParameters(actualTypesTuple, actuals, formals, renamings, dynamicRenamings, env);
            IValue result = this.invoke(oActuals);
            Type resultType = this.getReturnType().instantiate(env.getStaticTypeBindings());
            resultType = JavaMethod.unrenameType(renamings, resultType);
            resultValue = ResultFactory.makeResult(resultType, result, this.eval);
            resultValue = this.storeMemoizedResult(actuals, keyArgValues, resultValue);
            this.printEndTrace((IValue)resultValue.value);
            if (!this.getReturnType().isBottom() && this.getReturnType().instantiate(env.getStaticTypeBindings()).isBottom()) {
                throw new MatchFailed();
            }
            Result<IValue> result2 = resultValue;
            return result2;
        }
        catch (Throwable e) {
            this.printExcept(e);
            throw e;
        }
        finally {
            if (this.eval.getCallTracing()) {
                this.eval.decCallNesting();
            }
            this.ctx.unwind(old);
        }
    }

    private Object[] addCtxActual(Object[] oActuals) {
        Object[] newActuals = new Object[oActuals.length + 1];
        System.arraycopy(oActuals, 0, newActuals, 0, oActuals.length);
        newActuals[oActuals.length] = this.ctx;
        return newActuals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] addKeywordActuals(Object[] oldActuals, Type formals, Map<String, IValue> keyArgValues) {
        if (!this.getFunctionType().hasKeywordParameters()) {
            return oldActuals;
        }
        Environment env = new Environment(this.declarationEnvironment, URIUtil.rootLocation("initializer"), "keyword parameter initializer");
        Environment old = this.ctx.getCurrentEnvt();
        try {
            this.ctx.setCurrentEnvt(env);
            for (int i = 0; i < formals.getArity(); ++i) {
                String fieldName = formals.getFieldName(i);
                Type fieldType = formals.getFieldType(i);
                env.declareVariable(fieldType, fieldName);
                env.storeLocalVariable(fieldName, ResultFactory.makeResult(fieldType, (IValue)oldActuals[i], this.ctx));
            }
            Type kwType = this.getFunctionType().getKeywordParameterTypes();
            int amountOfKWArguments = kwType.getArity();
            Object[] newActuals = new Object[oldActuals.length + amountOfKWArguments];
            System.arraycopy(oldActuals, 0, newActuals, 0, oldActuals.length);
            this.bindKeywordArgs(keyArgValues);
            for (int i = 0; i < amountOfKWArguments; ++i) {
                newActuals[oldActuals.length + i] = ((Result)env.getFrameVariable(kwType.getFieldName(i))).getValue();
            }
            Object[] objectArray = newActuals;
            return objectArray;
        }
        finally {
            this.ctx.setCurrentEnvt(old);
        }
    }

    public IValue invoke(Object[] oActuals) {
        try {
            return (IValue)this.method.invoke(this.instance, oActuals);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof Throw) {
                Throw th = (Throw)targetException;
                StackTrace trace = new StackTrace();
                trace.addAll(th.getTrace());
                ISourceLocation loc = th.getLocation();
                if (loc == null || loc.getScheme().equals("TODO")) {
                    loc = this.getAst().getLocation();
                }
                trace.add(loc, null);
                th.setLocation(loc);
                trace.addAll(this.eval.getStackTrace());
                th.setTrace(trace.freeze());
                throw th;
            }
            if (targetException instanceof StaticError) {
                throw (StaticError)targetException;
            }
            if (targetException instanceof ImplementationError) {
                throw (ImplementationError)((Object)targetException);
            }
            if (this.ctx.getConfiguration().printErrors()) {
                targetException.printStackTrace();
            }
            throw RuntimeExceptionFactory.javaException(e.getTargetException(), this.getAst(), this.eval.getStackTrace());
        }
        catch (Throwable e) {
            if (this.ctx.getConfiguration().printErrors()) {
                e.printStackTrace();
            }
            throw RuntimeExceptionFactory.javaException(e, this.getAst(), this.eval.getStackTrace());
        }
    }
}

