/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.util;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import fi.iki.elonen.NanoHTTPD;
import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.io.input.ReaderInputStream;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.library.Prelude;
import org.rascalmpl.library.lang.json.internal.JsonValueReader;
import org.rascalmpl.library.lang.json.internal.JsonValueWriter;
import org.rascalmpl.types.RascalTypeFactory;
import org.rascalmpl.types.TypeReifier;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.functions.IFunction;

public class Webserver {
    private final IRascalValueFactory vf;
    private final TypeStore store;
    private final PrintWriter out;
    private final Map<ISourceLocation, NanoHTTPD> servers;
    private final Map<IConstructor, NanoHTTPD.Response.Status> statusValues = new HashMap<IConstructor, NanoHTTPD.Response.Status>();
    private final IRascalMonitor monitor;
    private Type requestType;
    private Type post;
    private Type get;
    private Type head;
    private Type delete;
    private Type put;
    private Type functionType;

    public Webserver(IRascalValueFactory vf, TypeStore store, PrintWriter out, IRascalMonitor monitor) {
        this.vf = vf;
        this.store = store;
        this.out = out;
        this.monitor = monitor;
        this.servers = new HashMap<ISourceLocation, NanoHTTPD>();
    }

    public void serve(ISourceLocation url, IFunction callback, IBool asDeamon) {
        Function<IValue, CompletableFuture<IValue>> executor;
        ArrayBlockingQueue<Runnable> mainThreadExecutor;
        URI uri = url.getURI();
        this.initMethodAndStatusValues(this.store);
        int port = uri.getPort() != -1 ? uri.getPort() : 80;
        String host = uri.getHost() != null ? uri.getHost() : "localhost";
        String string = host = host.equals("localhost") ? "127.0.0.1" : host;
        if (asDeamon.getValue()) {
            mainThreadExecutor = null;
            executor = this.buildRegularExecutor(callback);
        } else {
            mainThreadExecutor = new ArrayBlockingQueue<Runnable>(1024, true);
            executor = this.asyncExecutor(callback, mainThreadExecutor);
        }
        NanoHTTPD server = new NanoHTTPD(host, port){

            @Override
            public NanoHTTPD.Response serve(String uri, NanoHTTPD.Method method, Map<String, String> headers, Map<String, String> parms, Map<String, String> files) {
                try {
                    IConstructor request = this.makeRequest(uri, method, headers, parms, files);
                    CompletableFuture rascalResponse = (CompletableFuture)executor.apply(request);
                    return this.translateResponse(method, (IValue)rascalResponse.get());
                }
                catch (CancellationException e) {
                    this.stop();
                    return 1.newFixedLengthResponse(NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/plain", "Shutting down!");
                }
                catch (ExecutionException e) {
                    Throwable actualException = e.getCause();
                    if (actualException instanceof Throw) {
                        Throw rascalException = (Throw)actualException;
                        if (this.isCallFailed(rascalException)) {
                            return 1.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND, "text/plain", "404: NOT FOUND\n\n" + rascalException.getMessage());
                        }
                        return 1.newFixedLengthResponse(NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/plain", "500: INTERNAL ERROR\n\n" + rascalException.getMessage());
                    }
                    return this.handleGeneralThrowable(actualException);
                }
                catch (Throwable t2) {
                    return this.handleGeneralThrowable(t2);
                }
            }

            private boolean isCallFailed(Throw rascalException) {
                IValue exc = rascalException.getException();
                return exc.getType().isAbstractData() && ((IConstructor)exc).getConstructorType() == RuntimeExceptionFactory.CallFailed;
            }

            private NanoHTTPD.Response handleGeneralThrowable(Throwable actualException) {
                return 1.newFixedLengthResponse(NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/plain", "500 INTERNAL SERVER ERROR:\n\n" + actualException.getMessage());
            }

            private IConstructor makeRequest(String path, NanoHTTPD.Method method, Map<String, String> headers, Map<String, String> parms, Map<String, String> files) throws FactTypeUseException, IOException {
                HashMap<String, IValue> kws = new HashMap<String, IValue>();
                kws.put("parameters", this.makeMap(parms));
                kws.put("uploads", this.makeMap(files));
                kws.put("headers", this.makeMap(headers));
                switch (method) {
                    case HEAD: {
                        return Webserver.this.vf.constructor(Webserver.this.head, new IValue[]{Webserver.this.vf.string(path)}, kws);
                    }
                    case DELETE: {
                        return Webserver.this.vf.constructor(Webserver.this.delete, new IValue[]{Webserver.this.vf.string(path)}, kws);
                    }
                    case GET: {
                        return Webserver.this.vf.constructor(Webserver.this.get, new IValue[]{Webserver.this.vf.string(path)}, kws);
                    }
                    case PUT: {
                        return Webserver.this.vf.constructor(Webserver.this.put, new IValue[]{Webserver.this.vf.string(path), this.getContent(files, "content")}, kws);
                    }
                    case POST: {
                        return Webserver.this.vf.constructor(Webserver.this.post, new IValue[]{Webserver.this.vf.string(path), this.getContent(files, "postData")}, kws);
                    }
                }
                throw new IOException("Unhandled request " + method);
            }

            protected IValue getContent(Map<String, String> parms, String contentParamName) throws IOException {
                return Webserver.this.vf.function(Webserver.this.functionType, (argValues, keyArgValues) -> {
                    try {
                        TypeStore store = new TypeStore(new TypeStore[0]);
                        Type topType = new TypeReifier(Webserver.this.vf).valueToType((IConstructor)argValues[0], store);
                        if (topType.isString()) {
                            return this.getRawContent(parms, contentParamName);
                        }
                        IValue dtf = (IValue)keyArgValues.get("dateTimeFormat");
                        return new JsonValueReader(Webserver.this.vf, store, Webserver.this.monitor, null).setCalendarFormat(dtf != null ? ((IString)dtf).getValue() : "yyyy-MM-dd'T'HH:mm:ss'Z'").read(new JsonReader(this.getRawContentReader(parms, contentParamName)), topType);
                    }
                    catch (IOException | URISyntaxException e) {
                        throw RuntimeExceptionFactory.io(Webserver.this.vf.string(e.getMessage()));
                    }
                });
            }

            private Reader getRawContentReader(Map<String, String> parms, String contentParamName) throws FileNotFoundException {
                String path = parms.get(contentParamName);
                if (path != null && !path.isEmpty()) {
                    return new FileReader(path);
                }
                return new StringReader("");
            }

            private IString getRawContent(Map<String, String> parms, String contentParamName) throws URISyntaxException {
                String path = parms.get(contentParamName);
                if (path != null && !path.isEmpty()) {
                    return Prelude.readFile(Webserver.this.vf, false, URIUtil.createFileLocation(path), "UTF-8", true);
                }
                return Webserver.this.vf.string("");
            }

            private NanoHTTPD.Response translateResponse(NanoHTTPD.Method method, IValue value) throws IOException {
                IConstructor cons = (IConstructor)value;
                Webserver.this.initMethodAndStatusValues(Webserver.this.store);
                switch (cons.getName()) {
                    case "fileResponse": {
                        return this.translateFileResponse(method, cons);
                    }
                    case "jsonResponse": {
                        return this.translateJsonResponse(method, cons);
                    }
                    case "response": {
                        return this.translateTextResponse(method, cons);
                    }
                }
                throw new IOException("Unknown response kind: " + value);
            }

            private NanoHTTPD.Response translateJsonResponse(NanoHTTPD.Method method, IConstructor cons) {
                IMap header = (IMap)cons.get("header");
                IValue data = cons.get("val");
                NanoHTTPD.Response.Status status = this.translateStatus((IConstructor)cons.get("status"));
                IWithKeywordParameters<? extends IConstructor> kws = cons.asWithKeywordParameters();
                IValue dtf = kws.getParameter("dateTimeFormat");
                IValue dai = kws.getParameter("dateTimeAsInt");
                IValue formatters = kws.getParameter("formatter");
                IValue ecn = kws.getParameter("explicitConstructorNames");
                IValue edt = kws.getParameter("explicitDataTypes");
                JsonValueWriter writer = new JsonValueWriter().setCalendarFormat(dtf != null ? ((IString)dtf).getValue() : "yyyy-MM-dd'T'HH:mm:ss'Z'").setFormatters((IFunction)formatters).setDatesAsInt(dai != null ? ((IBool)dai).getValue() : true).setExplicitConstructorNames(ecn != null ? ((IBool)ecn).getValue() : false).setExplicitDataTypes(edt != null ? ((IBool)edt).getValue() : false);
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    JsonWriter out = new JsonWriter(new OutputStreamWriter((OutputStream)baos, Charset.forName("UTF8")));
                    writer.write(out, data);
                    out.flush();
                    out.close();
                    NanoHTTPD.Response response = 1.newFixedLengthResponse(status, "application/json", new ByteArrayInputStream(baos.toByteArray()), baos.size());
                    this.addHeaders(response, header);
                    return response;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not create piped inputstream");
                }
            }

            private NanoHTTPD.Response translateFileResponse(NanoHTTPD.Method method, IConstructor cons) {
                ISourceLocation l = (ISourceLocation)cons.get("file");
                IString mimeType = (IString)cons.get("mimeType");
                IMap header = (IMap)cons.get("header");
                try {
                    NanoHTTPD.Response response = 1.newChunkedResponse(NanoHTTPD.Response.Status.OK, mimeType.getValue(), URIResolverRegistry.getInstance().getInputStream(l));
                    this.addHeaders(response, header);
                    return response;
                }
                catch (IOException e) {
                    return 1.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND, "text/plain", l + " not found.\n" + e);
                }
            }

            private NanoHTTPD.Response translateTextResponse(NanoHTTPD.Method method, IConstructor cons) {
                IString mimeType = (IString)cons.get("mimeType");
                IMap header = (IMap)cons.get("header");
                IString data = (IString)cons.get("content");
                NanoHTTPD.Response.Status status = this.translateStatus((IConstructor)cons.get("status"));
                if (method != NanoHTTPD.Method.HEAD) {
                    switch (status) {
                        case BAD_REQUEST: 
                        case UNAUTHORIZED: 
                        case NOT_FOUND: 
                        case FORBIDDEN: 
                        case RANGE_NOT_SATISFIABLE: 
                        case INTERNAL_ERROR: {
                            if (data.length() != 0) break;
                            data = Webserver.this.vf.string(status.getDescription());
                        }
                    }
                }
                try {
                    NanoHTTPD.ContentType fixedContentType = new NanoHTTPD.ContentType(mimeType.getValue()).tryUTF8();
                    NanoHTTPD.Response response = 1.newChunkedResponse(status, fixedContentType.getContentTypeHeader(), this.toInputStream(data, Charset.forName(fixedContentType.getEncoding())));
                    this.addHeaders(response, header);
                    return response;
                }
                catch (IOException e) {
                    return 1.newFixedLengthResponse(NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/html", e.getMessage());
                }
            }

            private InputStream toInputStream(IString data, Charset encoding) throws IOException {
                return ((ReaderInputStream.Builder)new ReaderInputStream.Builder().setReader(data.asReader())).setCharset(encoding).get();
            }

            private void addHeaders(NanoHTTPD.Response response, IMap header) {
                response.addHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                response.addHeader("Pragma", "no-cache");
                response.addHeader("Expires", "0");
                for (IValue key : header) {
                    response.addHeader(((IString)key).getValue(), ((IString)header.get(key)).getValue());
                }
            }

            private NanoHTTPD.Response.Status translateStatus(IConstructor cons) {
                Webserver.this.initMethodAndStatusValues(Webserver.this.store);
                return Webserver.this.statusValues.get(cons);
            }

            private IMap makeMap(Map<String, String> headers) {
                IMapWriter writer = Webserver.this.vf.mapWriter();
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    writer.put(Webserver.this.vf.string(entry.getKey()), Webserver.this.vf.string(entry.getValue()));
                }
                return (IMap)writer.done();
            }
        };
        try {
            server.start(5000, asDeamon.getValue());
            this.servers.put(url, server);
            if (!asDeamon.getValue()) {
                this.out.println("Starting http server in non-daemon mode, hit ctrl-c to stop it");
                this.out.flush();
                while (!this.monitor.jobIsCanceled("Server: " + server)) {
                    try {
                        Runnable job = (Runnable)mainThreadExecutor.poll(10L, TimeUnit.MILLISECONDS);
                        if (job == null) continue;
                        job.run();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
                server.stop();
                this.servers.remove(url);
            }
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.vf.string(e.getMessage()), null, null);
        }
    }

    public void shutdown(ISourceLocation server) {
        NanoHTTPD nano = this.servers.get(server);
        if (nano == null) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)server, "could not shutdown");
        }
        nano.stop();
        this.servers.remove(server);
    }

    protected void finalize() throws Throwable {
        for (NanoHTTPD server : this.servers.values()) {
            if (server == null || !server.wasStarted()) continue;
            server.stop();
        }
    }

    private Function<IValue, CompletableFuture<IValue>> buildRegularExecutor(IFunction target) {
        return request -> {
            CompletableFuture<IValue> result = new CompletableFuture<IValue>();
            this.executeCallback(target, result, (IValue)request, true);
            return result;
        };
    }

    private Function<IValue, CompletableFuture<IValue>> asyncExecutor(IFunction callback, BlockingQueue<Runnable> mainThreadExecutor) {
        return request -> {
            CompletableFuture result = new CompletableFuture();
            try {
                mainThreadExecutor.put(() -> this.executeCallback(callback, result, (IValue)request, false));
            }
            catch (InterruptedException e) {
                result.cancel(true);
            }
            return result;
        };
    }

    private void executeCallback(IFunction callback, CompletableFuture<IValue> target, IValue request, boolean asDaemon) {
        try {
            target.complete((IValue)callback.call(request));
        }
        catch (Throwable t2) {
            target.completeExceptionally(t2);
        }
    }

    private void initMethodAndStatusValues(TypeStore store) {
        if (this.statusValues.isEmpty() || this.requestType == null) {
            TypeFactory tf = TypeFactory.getInstance();
            Type statusType = store.lookupAbstractDataType("Status");
            this.statusValues.put(this.vf.constructor(store.lookupConstructor(statusType, "ok", tf.voidType())), NanoHTTPD.Response.Status.OK);
            this.statusValues.put(this.vf.constructor(store.lookupConstructor(statusType, "created", tf.voidType())), NanoHTTPD.Response.Status.CREATED);
            this.statusValues.put(this.vf.constructor(store.lookupConstructor(statusType, "accepted", tf.voidType())), NanoHTTPD.Response.Status.ACCEPTED);
            this.statusValues.put(this.vf.constructor(store.lookupConstructor(statusType, "noContent", tf.voidType())), NanoHTTPD.Response.Status.NO_CONTENT);
            this.statusValues.put(this.vf.constructor(store.lookupConstructor(statusType, "partialContent", tf.voidType())), NanoHTTPD.Response.Status.PARTIAL_CONTENT);
            this.statusValues.put(this.vf.constructor(store.lookupConstructor(statusType, "redirect", tf.voidType())), NanoHTTPD.Response.Status.REDIRECT);
            this.statusValues.put(this.vf.constructor(store.lookupConstructor(statusType, "notModified", tf.voidType())), NanoHTTPD.Response.Status.NOT_MODIFIED);
            this.statusValues.put(this.vf.constructor(store.lookupConstructor(statusType, "badRequest", tf.voidType())), NanoHTTPD.Response.Status.BAD_REQUEST);
            this.statusValues.put(this.vf.constructor(store.lookupConstructor(statusType, "unauthorized", tf.voidType())), NanoHTTPD.Response.Status.UNAUTHORIZED);
            this.statusValues.put(this.vf.constructor(store.lookupConstructor(statusType, "forbidden", tf.voidType())), NanoHTTPD.Response.Status.FORBIDDEN);
            this.statusValues.put(this.vf.constructor(store.lookupConstructor(statusType, "notFound", tf.voidType())), NanoHTTPD.Response.Status.NOT_FOUND);
            this.statusValues.put(this.vf.constructor(store.lookupConstructor(statusType, "rangeNotSatisfiable", tf.voidType())), NanoHTTPD.Response.Status.RANGE_NOT_SATISFIABLE);
            this.statusValues.put(this.vf.constructor(store.lookupConstructor(statusType, "internalError", tf.voidType())), NanoHTTPD.Response.Status.INTERNAL_ERROR);
            this.requestType = store.lookupAbstractDataType("Request");
            RascalTypeFactory rtf = RascalTypeFactory.getInstance();
            this.functionType = tf.functionType(tf.valueType(), tf.tupleType(rtf.reifiedType(tf.valueType())), tf.tupleEmpty());
            this.get = store.lookupConstructor(this.requestType, "get", tf.tupleType(tf.stringType()));
            this.put = store.lookupConstructor(this.requestType, "put", tf.tupleType(tf.stringType(), this.functionType));
            this.post = store.lookupConstructor(this.requestType, "post", tf.tupleType(tf.stringType(), this.functionType));
            this.delete = store.lookupConstructor(this.requestType, "delete", tf.tupleType(tf.stringType()));
            this.head = store.lookupConstructor(this.requestType, "head", tf.tupleType(tf.stringType()));
        }
    }
}

