/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.semantics.dynamic;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import java.util.List;
import org.rascalmpl.ast.Body;
import org.rascalmpl.ast.Header;
import org.rascalmpl.ast.Module;
import org.rascalmpl.ast.Toplevel;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.env.GlobalEnvironment;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.utils.Names;

public abstract class Module {
    public static String getModuleName(org.rascalmpl.ast.Module module) {
        return Names.fullName(module.getHeader().getName());
    }

    public static class Default
    extends Module.Default {
        public Default(ISourceLocation __param1, IConstructor tree, Header __param2, Body __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> eval) {
            String name = Module.getModuleName(this);
            GlobalEnvironment heap = eval.__getHeap();
            ModuleEnvironment env = heap.getModule(name);
            if (env == null) {
                env = new ModuleEnvironment(name, heap);
                heap.addModule(env);
            }
            Environment oldEnv = eval.getCurrentEnvt();
            eval.setCurrentEnvt(env);
            try {
                List<Toplevel> decls = this.getBody().getToplevels();
                eval.__getTypeDeclarator().evaluateDeclarations(decls, eval.getCurrentEnvt(), false);
                for (Toplevel l : decls) {
                    l.interpret(eval);
                }
            }
            catch (RuntimeException e) {
                env.setInitialized(false);
                throw e;
            }
            finally {
                eval.setCurrentEnvt(oldEnv);
            }
            return ResultFactory.nothing();
        }
    }
}

