/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.file;

import io.usethesource.vallang.ISourceLocation;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.rascalmpl.uri.file.FileURIResolver;

public class UNCResolver
extends FileURIResolver {
    private boolean onWindows = System.getProperty("os.name").toLowerCase().startsWith("win");

    @Override
    protected String getPath(ISourceLocation uri) {
        if (!this.onWindows) {
            throw new RuntimeException(new FileNotFoundException(uri.toString() + "; UNC is only available on Windows"));
        }
        if (uri.hasAuthority()) {
            Object path = uri.getPath();
            if (((String)path).startsWith("/")) {
                path = ((String)path).substring(1);
            }
            if (((String)path).endsWith(":")) {
                path = (String)path + "\\";
            }
            return "\\\\" + uri.getAuthority() + "\\" + (String)path;
        }
        return uri.getPath();
    }

    @Override
    public String scheme() {
        return "unc";
    }
}

