/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.jar;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.rascalmpl.uri.zip.CompressedFSTree;
import org.rascalmpl.uri.zip.EntryEnumerator;
import org.rascalmpl.uri.zip.IndexedFSEntry;

public class JarFileTree
extends CompressedFSTree {
    public JarFileTree(File jar) {
        super(IndexedFSEntry.forFile(jar), JarFileTree.openJar(jar));
    }

    private static EntryEnumerator openJar(File jar) {
        return () -> {
            final JarFile jarFile = new JarFile(jar);
            final Enumeration<JarEntry> actual = jarFile.entries();
            return new EntryEnumerator.CloseableIterator(){

                @Override
                public void close() throws IOException {
                    jarFile.close();
                }

                @Override
                public boolean hasNext() {
                    return actual.hasMoreElements();
                }

                @Override
                public ZipEntry next() {
                    return (ZipEntry)actual.nextElement();
                }
            };
        };
    }
}

