/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.project;

import io.usethesource.vallang.ISourceLocation;
import java.io.IOException;
import org.rascalmpl.uri.ILogicalSourceLocationResolver;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;

public class TargetURIResolver
implements ILogicalSourceLocationResolver {
    private ISourceLocation root;
    private String name;

    public TargetURIResolver(ISourceLocation root, String name) {
        this.root = this.guessTarget(root);
        this.name = name;
    }

    private ISourceLocation guessTarget(ISourceLocation root) {
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        ISourceLocation bin = URIUtil.getChildLocation(root, "bin");
        ISourceLocation targetClasses = URIUtil.getChildLocation(root, "target/classes");
        if (reg.exists(bin) && !reg.exists(targetClasses)) {
            return bin;
        }
        if (reg.exists(targetClasses)) {
            return targetClasses;
        }
        if (reg.exists(URIUtil.getChildLocation(root, "pom.xml"))) {
            return targetClasses;
        }
        return bin;
    }

    @Override
    public ISourceLocation resolve(ISourceLocation input) throws IOException {
        if (!input.getAuthority().equals(this.name)) {
            return null;
        }
        return URIUtil.getChildLocation(this.root, input.getPath());
    }

    @Override
    public String scheme() {
        return "target";
    }

    @Override
    public String authority() {
        return this.name;
    }
}

