/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.persistent;

import io.usethesource.capsule.util.iterator.ArrayIterator;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Iterator;
import org.checkerframework.checker.nullness.qual.Nullable;

class Node
implements INode {
    protected static final Type NODE_TYPE = TF.nodeType();
    protected static final Type VALUE_TYPE = TypeFactory.getInstance().valueType();
    protected final String name;
    protected final IValue[] children;

    static INode newNode(String name, IValue[] children) {
        return new Node(name, children);
    }

    Node(String name, IValue[] children) {
        this.name = name.intern();
        this.children = children;
    }

    static INode newNode(String name, IList children) {
        return new Node(name, children);
    }

    private Node(String name, IList children) {
        IValue[] childArray = new IValue[children.length()];
        this.name = name.intern();
        for (int i = 0; i < childArray.length; ++i) {
            childArray[i] = children.get(i);
        }
        this.children = childArray;
    }

    @Override
    public String toString() {
        return this.defaultToString();
    }

    @Override
    public Type getType() {
        return NODE_TYPE;
    }

    @Override
    public int arity() {
        return this.children.length;
    }

    @Override
    public INode setChildren(IValue[] childArray) {
        return new Node(this.name, childArray);
    }

    @Override
    public IValue get(int i) {
        return this.children[i];
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Iterator<IValue> iterator() {
        return ArrayIterator.of(this.children);
    }

    @Override
    public Iterable<IValue> getChildren() {
        return this;
    }

    @Override
    public INode set(int i, IValue arg) {
        IValue[] newChildren = (IValue[])this.children.clone();
        newChildren[i] = arg;
        return Node.newNode(this.name, newChildren);
    }

    public int hashCode() {
        int hash = this.name.hashCode();
        for (int i = this.children.length - 1; i >= 0; --i) {
            hash = (hash << 23) + (hash >> 5);
            hash ^= this.children[i].hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Node other = (Node)o;
        if (this.name != other.name) {
            return false;
        }
        IValue[] otherChildren = other.children;
        int nrOfChildren = this.children.length;
        if (otherChildren.length != nrOfChildren) {
            return false;
        }
        for (int i = nrOfChildren - 1; i >= 0; --i) {
            if (otherChildren[i].equals(this.children[i])) continue;
            return false;
        }
        return true;
    }
}

