/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;

public abstract class OptionalExpression
extends AbstractAST {
    public OptionalExpression(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasExpression() {
        return false;
    }

    public org.rascalmpl.ast.Expression getExpression() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isExpression() {
        return false;
    }

    public boolean isNoExpression() {
        return false;
    }

    public static class NoExpression
    extends OptionalExpression {
        public NoExpression(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isNoExpression() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitOptionalExpressionNoExpression(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof NoExpression)) {
                return false;
            }
            NoExpression tmp = (NoExpression)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 19;
        }

        @Override
        public Object clone() {
            return NoExpression.newInstance(this.getClass(), this.src, null);
        }
    }

    public static class Expression
    extends OptionalExpression {
        private final org.rascalmpl.ast.Expression expression;

        public Expression(ISourceLocation src, IConstructor node, org.rascalmpl.ast.Expression expression) {
            super(src, node);
            this.expression = expression;
        }

        @Override
        public boolean isExpression() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitOptionalExpressionExpression(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.expression.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.expression.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Expression)) {
                return false;
            }
            Expression tmp = (Expression)o;
            return tmp.expression.equals(this.expression);
        }

        @Override
        public int hashCode() {
            return 557 + 601 * this.expression.hashCode();
        }

        @Override
        public org.rascalmpl.ast.Expression getExpression() {
            return this.expression;
        }

        @Override
        public boolean hasExpression() {
            return true;
        }

        @Override
        public Object clone() {
            return Expression.newInstance(this.getClass(), this.src, null, this.clone(this.expression));
        }
    }
}

