/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import java.util.Iterator;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.matching.BasicBooleanResult;
import org.rascalmpl.interpreter.matching.IMatchingResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.values.iterators.IteratorFactory;

public class EnumeratorResult
extends BasicBooleanResult {
    private IMatchingResult pat;
    private Iterator<?> iterator;
    private Expression expression;
    private Type elementType;
    private boolean firstTime;

    public EnumeratorResult(IEvaluatorContext ctx, IMatchingResult matchPattern, Expression expression) {
        super(ctx, expression);
        this.pat = matchPattern;
        this.expression = expression;
    }

    @Override
    public void init() {
        this.firstTime = true;
    }

    @Override
    public boolean hasNext() {
        if (this.firstTime) {
            this.hasNext = true;
            return true;
        }
        if (this.hasNext) {
            boolean hn;
            boolean bl = hn = this.pat.hasNext() || this.iterator.hasNext();
            if (!hn) {
                this.hasNext = false;
            }
            return hn;
        }
        return false;
    }

    @Override
    public boolean next() {
        if (this.firstTime) {
            this.firstTime = false;
            Result<IValue> result = this.expression.interpret(this.ctx.getEvaluator());
            this.elementType = IteratorFactory.elementType(this.ctx, result);
            this.iterator = IteratorFactory.make(this.ctx, this.pat, result, true);
        }
        while (this.pat.hasNext()) {
            if (!this.pat.next()) continue;
            return true;
        }
        while (this.iterator.hasNext()) {
            IValue v = (IValue)this.iterator.next();
            this.pat.initMatch(ResultFactory.makeResult(this.elementType, v, this.ctx));
            while (this.pat.hasNext()) {
                if (!this.pat.next()) continue;
                return true;
            }
        }
        this.hasNext = false;
        return false;
    }
}

