/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IExternalValue;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.exceptions.IllegalOperationException;
import io.usethesource.vallang.io.StandardTextWriter;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.visitors.IValueVisitor;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.FunctionDeclaration;
import org.rascalmpl.ast.KeywordFormal;
import org.rascalmpl.ast.KeywordFormals;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.result.ComposedFunctionResult;
import org.rascalmpl.interpreter.result.ICallableValue;
import org.rascalmpl.interpreter.result.LessThanOrEqualResult;
import org.rascalmpl.interpreter.result.OverloadedFunction;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.UnexpectedKeywordArgumentType;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;
import org.rascalmpl.interpreter.utils.LimitedResultWriter;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.functions.IFunction;

public abstract class AbstractFunction
extends Result<IValue>
implements IExternalValue,
ICallableValue,
IFunction {
    protected static final TypeFactory TF = TypeFactory.getInstance();
    protected final Environment declarationEnvironment;
    protected final IEvaluator<Result<IValue>> eval;
    protected final Type staticFunctionType;
    protected final Type dynamicFunctionType;
    protected final boolean hasVarArgs;
    protected boolean hasKeyArgs;
    protected final Map<String, Expression> keywordParameterDefaults = new HashMap<String, Expression>();
    protected final AbstractAST ast;
    protected final IValueFactory vf;
    private int hash = -1;

    public AbstractFunction(AbstractAST ast, IEvaluator<Result<IValue>> eval, Type functionType, Type dynamicFunctionType, List<KeywordFormal> initializers, boolean varargs, Environment env) {
        super(functionType, null, eval);
        this.ast = ast;
        this.staticFunctionType = functionType;
        this.dynamicFunctionType = dynamicFunctionType;
        this.eval = eval;
        this.hasVarArgs = varargs;
        this.hasKeyArgs = functionType.hasKeywordParameters();
        this.declarationEnvironment = env;
        this.vf = eval.getValueFactory();
        for (KeywordFormal init : initializers) {
            String label = Names.name(init.getName());
            this.keywordParameterDefaults.put(label, init.getExpression());
        }
    }

    @Override
    public IConstructor encodeAsConstructor() {
        AbstractAST ast2 = this.getAst();
        return this.getValueFactory().constructor(RascalValueFactory.Function_Function, ast2 != null ? ast2.getLocation() : URIUtil.correctLocation("unknown", "", ""));
    }

    protected static List<KeywordFormal> getFormals(FunctionDeclaration func) {
        KeywordFormals keywordFormals = func.getSignature().getParameters().getKeywordFormals();
        return keywordFormals.hasKeywordFormalList() ? keywordFormals.getKeywordFormalList() : Collections.emptyList();
    }

    public boolean isTest() {
        return false;
    }

    @Override
    public Type getKeywordArgumentTypes(Environment env) {
        return this.staticFunctionType.isFunction() ? this.staticFunctionType.getKeywordParameterTypes() : TF.voidType();
    }

    public boolean hasKeywordParameter(String label) {
        return this.staticFunctionType.hasKeywordParameter(label);
    }

    @Override
    public int getArity() {
        return this.staticFunctionType.getArity();
    }

    public boolean isPatternDispatched() {
        return false;
    }

    public boolean isConcretePatternDispatched() {
        return false;
    }

    public Type getFormals() {
        return this.staticFunctionType.getFieldTypes();
    }

    public AbstractAST getAst() {
        return this.ast;
    }

    public boolean hasTag(String key) {
        return false;
    }

    public IValue getTag(String key) {
        return null;
    }

    public String getIndexedLabel() {
        return null;
    }

    public int getIndexedArgumentPosition() {
        return -1;
    }

    public IConstructor getIndexedProduction() {
        return null;
    }

    @Override
    public IValue getValue() {
        return this;
    }

    public Environment getEnv() {
        return this.declarationEnvironment;
    }

    public boolean mayMatch(Type actuals) {
        if (actuals.isSubtypeOf(this.getFormals())) {
            return true;
        }
        if (this.hasVarArgs) {
            return this.mayMatchVarArgsFunction(actuals);
        }
        return false;
    }

    @Override
    public boolean hasVarArgs() {
        return this.hasVarArgs;
    }

    @Override
    public boolean hasKeywordArguments() {
        return this.hasKeyArgs;
    }

    public Map<String, Expression> getKeywordParameterDefaults() {
        return this.keywordParameterDefaults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<IValue> call(IRascalMonitor monitor, Type[] argTypes, IValue[] argValues, Map<String, IValue> keyArgValues) {
        IRascalMonitor old = this.ctx.getEvaluator().setMonitor(monitor);
        try {
            Result<IValue> result = this.call(argTypes, argValues, keyArgValues);
            return result;
        }
        finally {
            this.ctx.getEvaluator().setMonitor(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IValue> T call(Map<String, IValue> keywordParameters, IValue ... parameters) {
        IEvaluator<Result<IValue>> iEvaluator = this.ctx.getEvaluator();
        synchronized (iEvaluator) {
            return ICallableValue.super.call(keywordParameters, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IValue> T monitoredCall(IRascalMonitor monitor, Map<String, IValue> keywordParameters, IValue ... parameters) {
        IEvaluator<Result<IValue>> iEvaluator = this.ctx.getEvaluator();
        synchronized (iEvaluator) {
            return ICallableValue.super.monitoredCall(monitor, keywordParameters, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IValue> T monitoredCall(IRascalMonitor monitor, IValue ... parameters) {
        IEvaluator<Result<IValue>> iEvaluator = this.ctx.getEvaluator();
        synchronized (iEvaluator) {
            return ICallableValue.super.monitoredCall(monitor, Collections.emptyMap(), parameters);
        }
    }

    private boolean mayMatchVarArgsFunction(Type actuals) {
        int i;
        int arity = this.getFormals().getArity();
        if (arity - 1 > actuals.getArity()) {
            return false;
        }
        for (i = 0; i < arity - 1; ++i) {
            if (actuals.getFieldType(i).isSubtypeOf(this.getFormals().getFieldType(i))) continue;
            return false;
        }
        Type elementType = this.getFormals().getFieldType(i).getElementType();
        while (i < actuals.getArity()) {
            if (!actuals.getFieldType(i).isSubtypeOf(elementType)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public abstract boolean isDefault();

    private void printNesting(StringBuilder b) {
        for (int i = 0; i < this.ctx.getCallNesting(); ++i) {
            b.append('>');
        }
    }

    private String strval(IValue value) {
        LimitedResultWriter w = new LimitedResultWriter(50);
        try {
            new StandardTextWriter(true, 2).write(value, w);
            return ((Object)w).toString();
        }
        catch (IOException e) {
            return "...";
        }
        catch (RuntimeException e) {
            return ((Object)w).toString();
        }
    }

    protected void printHeader(StringBuilder b, IValue[] actuals) {
        b.append(this.moduleName());
        b.append("::");
        b.append(this.getName());
        b.append('(');
        Type formals = this.getFormals();
        int n = Math.min(formals.getArity(), actuals.length);
        for (int i = 0; i < n; ++i) {
            b.append(this.strval(actuals[i]));
            if (i >= formals.getArity() - 1) continue;
            b.append(", ");
        }
        b.append(')');
    }

    protected void printStartTrace(IValue[] actuals) {
        StringBuilder b = new StringBuilder();
        b.append("call  >");
        this.printNesting(b);
        this.printHeader(b, actuals);
        this.eval.getOutPrinter().println(b.toString());
        this.eval.getOutPrinter().flush();
        this.eval.incCallNesting();
    }

    private String moduleName() {
        String name = this.getEnv().getName();
        int ind = name.lastIndexOf("::");
        if (ind != -1) {
            name = name.substring(ind + 2);
        }
        return name;
    }

    protected void printExcept(Throwable e) {
        if (this.eval.getCallTracing()) {
            StringBuilder b = new StringBuilder();
            b.append("except>");
            this.printNesting(b);
            b.append(this.moduleName());
            b.append("::");
            b.append(this.getName());
            b.append(": ");
            String msg = e.getMessage();
            b.append(msg == null ? e.getClass().getSimpleName() : msg);
            this.eval.getOutPrinter().println(b.toString());
            this.eval.getOutPrinter().flush();
        }
    }

    protected void printEndTrace(IValue result) {
        if (this.eval.getCallTracing()) {
            StringBuilder b = new StringBuilder();
            b.append("return>");
            this.printNesting(b);
            b.append(this.moduleName());
            b.append("::");
            b.append(this.getName());
            if (result != null) {
                b.append(":");
                b.append(this.strval(result));
            }
            this.eval.getOutPrinter().println(b);
            this.eval.getOutPrinter().flush();
        }
    }

    protected Type bindTypeParameters(Type actualStaticTypes, IValue[] actuals, Type formals, Map<Type, Type> renamings, Map<Type, Type> dynamicRenamings, Environment env) {
        try {
            if (actualStaticTypes.isOpen()) {
                actualStaticTypes = AbstractFunction.renameType(actualStaticTypes, renamings, env.getLocation());
            }
            HashMap<Type, Type> staticBindings = new HashMap<Type, Type>();
            try {
                if (formals.match(actualStaticTypes, staticBindings)) {
                    env.storeStaticTypeBindings(staticBindings);
                }
            }
            catch (FactTypeUseException factTypeUseException) {
                // empty catch block
            }
            return actualStaticTypes;
        }
        catch (FactTypeUseException e) {
            throw new UnexpectedType(formals, actualStaticTypes, this.ast);
        }
    }

    protected static Type unrenameType(Map<Type, Type> renamings, Type resultType) {
        if (resultType.isOpen()) {
            HashMap<Type, Type> unrenamings = new HashMap<Type, Type>();
            for (Map.Entry<Type, Type> entry : renamings.entrySet()) {
                unrenamings.put(entry.getValue(), entry.getKey());
            }
            resultType = resultType.instantiate(unrenamings);
        }
        return resultType;
    }

    public static Type renameType(Type actualTypes, Map<Type, Type> renamings, ISourceLocation uniquePrefix) {
        actualTypes.match(TypeFactory.getInstance().voidType(), renamings);
        for (Map.Entry<Type, Type> entry : renamings.entrySet()) {
            Type key = entry.getKey();
            renamings.put(key, TypeFactory.getInstance().parameterType(key.getName() + ":" + uniquePrefix, key.getBound()));
        }
        actualTypes = actualTypes.instantiate(renamings);
        return actualTypes;
    }

    protected IValue[] computeVarArgsActuals(IValue[] actuals, Type formals) {
        int i;
        int arity = formals.getArity();
        IValue[] newActuals = new IValue[arity];
        if (formals.getArity() == actuals.length && actuals[actuals.length - 1].getType().isSubtypeOf(formals.getFieldType(formals.getArity() - 1))) {
            return actuals;
        }
        for (i = 0; i < arity - 1; ++i) {
            newActuals[i] = actuals[i];
        }
        Type lub = TF.voidType();
        for (int j = i; j < actuals.length; ++j) {
            lub = lub.lub(actuals[j].getType());
        }
        IListWriter list = this.vf.listWriter();
        list.insertAt(0, actuals, i, actuals.length - arity + 1);
        newActuals[i] = list.done();
        return newActuals;
    }

    protected Type computeVarArgsActualTypes(Type actualTypes, Type formals) {
        int i;
        if (actualTypes.isSubtypeOf(formals)) {
            return actualTypes;
        }
        int arity = formals.getArity();
        Type[] types = new Type[arity];
        String[] labels = new String[arity];
        for (i = 0; i < arity - 1; ++i) {
            types[i] = actualTypes.getFieldType(i);
            labels[i] = formals.getFieldName(i);
        }
        Type lub = TF.voidType();
        for (int j = i; j < actualTypes.getArity(); ++j) {
            lub = lub.lub(actualTypes.getFieldType(j));
        }
        types[i] = TF.listType(lub);
        labels[i] = formals.getFieldName(i);
        return TF.tupleType(types, labels);
    }

    protected Type computeVarArgsActualTypes(Type[] actualTypes, Type formals) {
        Type actualTuple = TF.tupleType(actualTypes);
        if (actualTuple.isSubtypeOf(formals)) {
            return actualTuple;
        }
        int arity = formals.getArity();
        Type[] types = new Type[arity];
        for (int i = 0; i < arity - 1; ++i) {
            types[i] = actualTypes[i];
        }
        Type lub = TF.voidType();
        for (int j = i; j < actualTypes.length; ++j) {
            lub = lub.lub(actualTypes[j]);
        }
        types[i] = TF.listType(lub);
        return TF.tupleType(types);
    }

    @Override
    public <T, E extends Throwable> T accept(IValueVisitor<T, E> v) throws E {
        return v.visitExternal(this);
    }

    @Override
    public boolean match(IValue other) {
        return other == this;
    }

    public boolean isIdentical(IValue other) throws FactTypeUseException {
        return other == this;
    }

    @Override
    public <V extends IValue> LessThanOrEqualResult lessThanOrEqual(Result<V> that) {
        return super.lessThanOrEqual(that);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> add(Result<V> that) {
        return that.addFunctionNonDeterministic(this);
    }

    public OverloadedFunction addFunctionNonDeterministic(AbstractFunction that) {
        return new OverloadedFunction(this).add(that);
    }

    public OverloadedFunction addFunctionNonDeterministic(OverloadedFunction that) {
        return new OverloadedFunction(this).join(that);
    }

    public ComposedFunctionResult addFunctionNonDeterministic(ComposedFunctionResult that) {
        return new ComposedFunctionResult.NonDeterministic(that, this, this.ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> compose(Result<V> right) {
        return right.composeFunction(this);
    }

    public ComposedFunctionResult composeFunction(AbstractFunction that) {
        return new ComposedFunctionResult(that, this, this.ctx);
    }

    public ComposedFunctionResult composeFunction(OverloadedFunction that) {
        return new ComposedFunctionResult(that, this, this.ctx);
    }

    public ComposedFunctionResult composeFunction(ComposedFunctionResult that) {
        return new ComposedFunctionResult(that, this, this.ctx);
    }

    @Override
    public String toString() {
        return this.getHeader() + ";";
    }

    public String getHeader() {
        String sep = "";
        Object strFormals = "";
        for (Type tp : this.getFormals()) {
            strFormals = (String)strFormals + sep + tp;
            sep = ", ";
        }
        String name = this.getName();
        if (name == null) {
            name = "";
        }
        String kwFormals = "";
        return this.getReturnType() + " " + name + "(" + (String)strFormals + kwFormals + ")";
    }

    @Override
    public final Type getType() {
        return this.dynamicFunctionType;
    }

    public Type getFunctionType() {
        return this.getStaticType();
    }

    public boolean isTypePreserving() {
        Type t2 = this.getReturnType();
        return this.getFunctionType().equivalent(TF.functionType(t2, t2, TF.tupleEmpty()));
    }

    public String getName() {
        return "";
    }

    public Type getReturnType() {
        return this.staticFunctionType.getReturnType();
    }

    @Override
    public IEvaluator<Result<IValue>> getEval() {
        return this.eval;
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = 7 + (this.ast != null ? this.ast.hashCode() * 23 : 23);
        }
        return this.hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            AbstractFunction other = (AbstractFunction)obj;
            return other.declarationEnvironment == this.declarationEnvironment && other.ast.equals(this.ast);
        }
        return false;
    }

    public String getResourceScheme() {
        return null;
    }

    public boolean hasResourceScheme() {
        return false;
    }

    public String getResolverScheme() {
        return null;
    }

    public boolean hasResolverScheme() {
        return false;
    }

    @Override
    public boolean mayHaveKeywordParameters() {
        return false;
    }

    @Override
    public IWithKeywordParameters<? extends IValue> asWithKeywordParameters() {
        throw new IllegalOperationException("Facade cannot be viewed as with keyword parameters.", this.getStaticType());
    }

    protected void bindKeywordArgs(Map<String, IValue> keyArgValues) {
        Environment env = this.ctx.getCurrentEnvt();
        if (this.staticFunctionType.hasKeywordParameters()) {
            for (String kwparam : this.staticFunctionType.getKeywordParameterTypes().getFieldNames()) {
                Type kwType = this.staticFunctionType.getKeywordParameterType(kwparam);
                String isSetName = AbstractFunction.makeIsSetKeywordParameterName(kwparam);
                env.declareVariable(TF.boolType(), isSetName);
                if (keyArgValues != null && keyArgValues.containsKey(kwparam)) {
                    IValue r = keyArgValues.get(kwparam);
                    if (!r.getType().isSubtypeOf(kwType)) {
                        throw new UnexpectedKeywordArgumentType(kwparam, kwType, r.getType(), this.ctx.getCurrentAST());
                    }
                    env.declareVariable(kwType, kwparam);
                    env.storeVariable(kwparam, ResultFactory.makeResult(kwType, r, this.ctx));
                    env.storeVariable(isSetName, ResultFactory.makeResult(TF.boolType(), this.getValueFactory().bool(true), this.ctx));
                    continue;
                }
                env.declareVariable(kwType, kwparam);
                Expression def = this.getKeywordParameterDefaults().get(kwparam);
                Result<IValue> kwResult = def.interpret(this.eval);
                env.storeVariable(kwparam, ResultFactory.makeResult(kwType, kwResult.getValue(), this.ctx));
                env.storeVariable(isSetName, ResultFactory.makeResult(TF.boolType(), this.getValueFactory().bool(false), this.ctx));
            }
        }
    }

    public static String makeIsSetKeywordParameterName(String kwparam) {
        return "$" + kwparam + "isSet";
    }
}

