/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.types.TypeReifier;

public class Type {
    private final IValueFactory vf;
    private final IMap emptyMap;

    public Type(IValueFactory vf) {
        this.vf = vf;
        this.emptyMap = (IMap)vf.mapWriter().done();
    }

    public IValue typeOf(IValue v) {
        return new TypeReifier(this.vf).typeToValue(v.getType(), new TypeStore(new TypeStore[0]), (IMap)this.vf.mapWriter().done()).get("symbol");
    }

    public IBool eq(IValue x, IValue y) {
        return this.vf.bool(x.equals(y));
    }

    public IValue make(IValue type, IString name, IList args) {
        return this.make(type, name, args, this.emptyMap);
    }

    public IValue make(IValue type, IString name, IList args, IMap keywordParameters) {
        Map<String, IValue> kwmap;
        TypeStore store = new TypeStore(new TypeStore[0]);
        io.usethesource.vallang.type.Type t2 = new TypeReifier(this.vf).valueToType((IConstructor)type, store);
        IValue[] children = new IValue[args.length()];
        io.usethesource.vallang.type.Type[] argsTypes = new io.usethesource.vallang.type.Type[args.length()];
        for (int i = 0; i < args.length(); ++i) {
            children[i] = args.get(i);
            argsTypes[i] = children[i].getType();
        }
        if (keywordParameters.size() == 0) {
            kwmap = Collections.emptyMap();
        } else {
            Iterator<Map.Entry<IValue, IValue>> iter = keywordParameters.entryIterator();
            kwmap = new HashMap();
            while (iter.hasNext()) {
                Map.Entry<IValue, IValue> entry = iter.next();
                kwmap.put(((IString)entry.getKey()).getValue(), entry.getValue());
            }
        }
        try {
            io.usethesource.vallang.type.Type constructor = store.lookupConstructor(t2, name.getValue(), TypeFactory.getInstance().tupleType(argsTypes));
            if (constructor == null) {
                throw RuntimeExceptionFactory.illegalArgument(type, null, null);
            }
            return this.vf.constructor(constructor, children, kwmap);
        }
        catch (FactTypeUseException e) {
            throw RuntimeExceptionFactory.illegalArgument(type, null, null);
        }
    }

    public IBool intersects(IConstructor sym1, IConstructor sym2) {
        TypeReifier tr = new TypeReifier(this.vf);
        io.usethesource.vallang.type.Type t1 = tr.symbolToType(sym1);
        io.usethesource.vallang.type.Type t2 = tr.symbolToType(sym2);
        return this.vf.bool(t1.intersects(t2));
    }

    public IBool subtype(IConstructor sym1, IConstructor sym2) {
        TypeReifier tr = new TypeReifier(this.vf);
        io.usethesource.vallang.type.Type t1 = tr.symbolToType(sym1);
        io.usethesource.vallang.type.Type t2 = tr.symbolToType(sym2);
        return this.vf.bool(t1.isSubtypeOf(t2));
    }

    public IConstructor lub(IConstructor sym1, IConstructor sym2) {
        TypeReifier tr = new TypeReifier(this.vf);
        TypeStore ts = new TypeStore(new TypeStore[0]);
        io.usethesource.vallang.type.Type t1 = tr.symbolToType(sym1);
        io.usethesource.vallang.type.Type t2 = tr.symbolToType(sym2);
        return (IConstructor)tr.typeToValue(t1.lub(t2), ts, this.vf.map()).get("symbol");
    }

    public IConstructor glb(IConstructor sym1, IConstructor sym2) {
        TypeReifier tr = new TypeReifier(this.vf);
        TypeStore ts = new TypeStore(new TypeStore[0]);
        io.usethesource.vallang.type.Type t1 = tr.symbolToType(sym1);
        io.usethesource.vallang.type.Type t2 = tr.symbolToType(sym2);
        return (IConstructor)tr.typeToValue(t1.glb(t2), ts, this.vf.map()).get("symbol");
    }
}

