/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Command;
import org.rascalmpl.ast.Commands;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.Module;
import org.rascalmpl.ast.Statement;
import org.rascalmpl.ast.Sym;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.interpreter.asserts.Ambiguous;
import org.rascalmpl.parser.gtd.util.PointerKeyedHashMap;
import org.rascalmpl.semantics.dynamic.Tree;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.ProductionAdapter;
import org.rascalmpl.values.parsetrees.SymbolAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class ASTBuilder {
    private static final String MODULE_SORT = "Module";
    private final PointerKeyedHashMap<IValue, Expression> constructorCache = new PointerKeyedHashMap();
    private static final HashMap<String, Constructor<?>> astConstructors = new HashMap();
    private static final HashMap<String, Class<?>> astClasses = new HashMap();
    private static final ClassLoader classLoader = ASTBuilder.class.getClassLoader();

    public static <T extends AbstractAST> T make(String sort, ISourceLocation src, Object ... args) {
        return ASTBuilder.make(sort, "Default", src, args);
    }

    public static <T extends Expression> T makeExp(String cons, ISourceLocation src, Object ... args) {
        return (T)((Expression)ASTBuilder.make("Expression", cons, src, args));
    }

    public static <T extends Statement> T makeStat(String cons, ISourceLocation src, Object ... args) {
        return (T)((Statement)ASTBuilder.make("Statement", cons, src, args));
    }

    public static <T extends AbstractAST> T makeLex(String sort, ISourceLocation src, Object ... args) {
        return ASTBuilder.make(sort, "Lexical", src, args);
    }

    public static <T extends AbstractAST> T make(String sort, String cons, ISourceLocation src, Object ... args) {
        Object[] newArgs = new Object[args.length + 2];
        System.arraycopy(args, 0, newArgs, 2, args.length);
        newArgs[0] = src;
        return (T)ASTBuilder.callMakerMethod(sort, cons, newArgs, null);
    }

    public Module buildModule(ITree tree) throws FactTypeUseException {
        if (TreeAdapter.isAppl(tree)) {
            if (this.sortName(tree).equals(MODULE_SORT)) {
                return (Module)this.buildValue(tree);
            }
            return (Module)this.buildSort(tree, MODULE_SORT);
        }
        if (TreeAdapter.isAmb(tree)) {
            throw new Ambiguous(tree);
        }
        throw new ImplementationError("Parse of module returned invalid tree.");
    }

    public Expression buildExpression(ITree parseTree) {
        return (Expression)this.buildSort(parseTree, "Expression");
    }

    public Statement buildStatement(ITree parseTree) {
        return (Statement)this.buildSort(parseTree, "Statement");
    }

    public Command buildCommand(ITree parseTree) {
        return (Command)this.buildSort(parseTree, "Command");
    }

    public Sym buildSym(ITree parseTree) {
        return (Sym)this.buildSort(parseTree, "Sym");
    }

    public Commands buildCommands(ITree parseTree) {
        return (Commands)this.buildSort(parseTree, "Commands");
    }

    public <T extends AbstractAST> T buildSort(ITree parseTree, String sort) {
        if (TreeAdapter.isAppl(parseTree)) {
            ITree tree = TreeAdapter.getStartTop(parseTree);
            if (this.sortName(tree).equals(sort)) {
                return (T)this.buildValue(tree);
            }
        } else if (TreeAdapter.isAmb(parseTree)) {
            throw new Ambiguous(parseTree);
        }
        throw new ImplementationError("This is not a " + sort + ": " + parseTree);
    }

    public AbstractAST buildValue(IValue arg) {
        ITree tree = (ITree)arg;
        if (TreeAdapter.isList(tree)) {
            throw new ImplementationError("buildValue should not be called on a list");
        }
        if (TreeAdapter.isAmb(tree)) {
            throw new Ambiguous(tree);
        }
        if (!TreeAdapter.isAppl(tree)) {
            throw new UnsupportedOperationException();
        }
        if (this.isLexical(tree)) {
            if (TreeAdapter.isRascalLexical(tree)) {
                return this.buildLexicalNode(tree);
            }
            return this.buildLexicalNode((ITree)((IList)((ITree)arg).get("args")).get(0));
        }
        if (TreeAdapter.isOpt(tree)) {
            IList args = TreeAdapter.getArgs(tree);
            if (args.isEmpty()) {
                return null;
            }
            return this.buildValue(args.get(0));
        }
        if (this.sortName(tree).equals("Pattern") && this.isNewEmbedding(tree)) {
            return this.newLift(tree, true);
        }
        if (this.sortName(tree).equals("Expression") && this.isNewEmbedding(tree)) {
            return this.newLift(tree, false);
        }
        return this.buildContextFreeNode((ITree)arg);
    }

    private List<AbstractAST> buildList(ITree in) {
        ArrayList<AbstractAST> result = new ArrayList<AbstractAST>(TreeAdapter.getListLength(in));
        IList args = in.getArgs();
        int seps = TreeAdapter.getSeparatorCount(in);
        for (int i = 0; i < args.length(); ++i) {
            ITree arg = (ITree)args.get(i);
            result.add(this.buildValue(arg));
            i += seps;
        }
        return result;
    }

    private AbstractAST buildContextFreeNode(ITree tree) {
        String constructorName = TreeAdapter.getConstructorName(tree);
        if (constructorName == null) {
            throw new ImplementationError("All Rascal productions should have a constructor name: " + TreeAdapter.getProduction(tree));
        }
        String cons = this.capitalize(constructorName);
        String sort = this.sortName(tree);
        if (sort.length() == 0) {
            throw new ImplementationError("Could not retrieve sort name for " + tree);
        }
        switch (sort = sort.equalsIgnoreCase("pattern") ? "Expression" : this.capitalize(sort)) {
            case "Mapping": {
                sort = "Mapping_Expression";
                break;
            }
            case "KeywordArgument": {
                sort = "KeywordArgument_Expression";
                break;
            }
            case "KeywordArguments": {
                sort = "KeywordArguments_Expression";
            }
        }
        Constructor<?> constructor = ASTBuilder.getConstructor(sort, cons);
        int parameterCount = constructor.getParameterCount();
        Object[] actuals = new Object[parameterCount];
        int i = 0;
        actuals[i++] = TreeAdapter.getLocation(tree);
        actuals[i++] = tree;
        IList args = tree.getArgs();
        for (int j = 0; j < args.length(); j += 2) {
            ITree argTree = (ITree)args.get(j);
            if (TreeAdapter.isLiteral(argTree) || TreeAdapter.isCILiteral(argTree) || TreeAdapter.isEmpty(argTree)) continue;
            actuals[i++] = TreeAdapter.isList(argTree) ? this.buildList(argTree) : this.buildValue(argTree);
        }
        return ASTBuilder.callMakerMethod(constructor, actuals, null);
    }

    private AbstractAST buildLexicalNode(ITree tree) {
        String sort = this.capitalize(this.sortName(tree));
        if (sort.length() == 0) {
            throw new ImplementationError("could not retrieve sort name for " + tree);
        }
        Object[] actuals = new Object[]{TreeAdapter.getLocation(tree), tree, new String(TreeAdapter.yield(tree))};
        return ASTBuilder.callMakerMethod(sort, "Lexical", actuals, null);
    }

    private String getPatternLayout(ITree tree) {
        IConstructor prod = TreeAdapter.getProduction(tree);
        String cons = ProductionAdapter.getConstructorName(prod);
        if (cons.equals("concrete")) {
            return "???";
        }
        throw new ImplementationError("Unexpected embedding syntax:" + prod);
    }

    private Expression cache(IConstructor in, Expression out) {
        this.constructorCache.putUnsafe(in, out);
        return out;
    }

    private Expression liftRec(ITree tree, boolean lexicalFather, String layoutOfFather) {
        Expression cached = this.constructorCache.get(tree);
        if (cached != null) {
            return cached;
        }
        if (layoutOfFather == null) {
            throw new ImplementationError("layout is null");
        }
        if (TreeAdapter.isAppl(tree)) {
            String newLayout;
            String cons = TreeAdapter.getConstructorName(tree);
            if (cons != null && cons.equals("hole")) {
                return this.liftHole(tree);
            }
            boolean lex = lexicalFather ? !TreeAdapter.isSort(tree) : TreeAdapter.isLexical(tree);
            IList args = TreeAdapter.getArgs(tree);
            String layout = layoutOfFather;
            if (cons != null && !lex && (newLayout = this.getLayoutName(TreeAdapter.getProduction(tree))) != null) {
                layout = newLayout;
            }
            ArrayList<Expression> kids = new ArrayList<Expression>(args.length());
            for (IValue arg : args) {
                Expression ast = this.liftRec((ITree)arg, lex, layout);
                if (ast == null) {
                    return null;
                }
                kids.add(ast);
            }
            if (TreeAdapter.isList(tree)) {
                return this.cache(tree, new Tree.List(TreeAdapter.getProduction(tree), TreeAdapter.getLocation(tree), kids));
            }
            if (TreeAdapter.isOpt(tree)) {
                return this.cache(tree, new Tree.Optional(TreeAdapter.getProduction(tree), TreeAdapter.getLocation(tree), kids));
            }
            return this.cache(tree, new Tree.Appl(TreeAdapter.getProduction(tree), TreeAdapter.getLocation(tree), kids));
        }
        if (TreeAdapter.isCycle(tree)) {
            return new Tree.Cycle(TreeAdapter.getLocation(tree), TreeAdapter.getCycleType(tree), TreeAdapter.getCycleLength(tree));
        }
        if (TreeAdapter.isAmb(tree)) {
            ISet args = TreeAdapter.getAlternatives(tree);
            ArrayList<Expression> kids = new ArrayList<Expression>(args.size());
            for (IValue arg : args) {
                kids.add(this.liftRec((ITree)arg, lexicalFather, layoutOfFather));
            }
            if (kids.size() == 0) {
                return null;
            }
            if (kids.size() == 1) {
                return (Expression)kids.get(0);
            }
            return this.cache(tree, new Tree.Amb(TreeAdapter.getLocation(tree), tree, kids));
        }
        if (!TreeAdapter.isChar(tree)) {
            throw new ImplementationError("unexpected tree type: " + tree);
        }
        return this.cache(tree, new Tree.Char(TreeAdapter.getLocation(tree), tree));
    }

    private Expression liftHole(ITree tree) {
        assert (tree.asWithKeywordParameters().hasParameter("holeType"));
        IConstructor type = (IConstructor)tree.asWithKeywordParameters().getParameter("holeType");
        tree = (ITree)TreeAdapter.getArgs(tree).get(0);
        IList args = TreeAdapter.getArgs(tree);
        IConstructor nameTree = (IConstructor)args.get(4);
        ISourceLocation src = TreeAdapter.getLocation(tree);
        Tree.MetaVariable result = new Tree.MetaVariable(src, tree, type, TreeAdapter.yield(nameTree));
        return result;
    }

    private String getLayoutName(IConstructor production) {
        if (ProductionAdapter.isDefault(production)) {
            for (IValue sym : ProductionAdapter.getSymbols(production)) {
                if (!SymbolAdapter.isLayouts(SymbolAdapter.delabel((IConstructor)sym))) continue;
                return SymbolAdapter.getName((IConstructor)sym);
            }
        }
        return null;
    }

    private String sortName(ITree tree) {
        if (TreeAdapter.isAppl(tree)) {
            return TreeAdapter.getSortName(tree);
        }
        if (TreeAdapter.isAmb(tree)) {
            return this.sortName((ITree)TreeAdapter.getAlternatives(tree).iterator().next());
        }
        return "";
    }

    private String capitalize(String sort) {
        if (sort.length() == 0) {
            return sort;
        }
        if (sort.length() > 1) {
            return Character.toUpperCase(sort.charAt(0)) + sort.substring(1);
        }
        return sort.toUpperCase();
    }

    private static ImplementationError unexpectedError(Throwable e) {
        return new ImplementationError("Unexpected error in AST construction: " + e, e);
    }

    private boolean isNewEmbedding(ITree tree) {
        String name = TreeAdapter.getConstructorName(tree);
        assert (name != null);
        return name.equals("concrete") && (name = TreeAdapter.getConstructorName(tree = (ITree)TreeAdapter.getArgs(tree).get(0))).equals("$parsed");
    }

    private boolean isLexical(ITree tree) {
        return TreeAdapter.isRascalLexical(tree);
    }

    private AbstractAST newLift(ITree tree, boolean match) {
        ITree concrete = (ITree)TreeAdapter.getArgs(tree).get(0);
        ITree fragment = (ITree)TreeAdapter.getArgs(concrete).get(7);
        return this.liftRec(fragment, false, this.getPatternLayout(tree));
    }

    private static Class<?> loadClass(String name) throws ClassNotFoundException {
        if (astClasses.containsKey(name)) {
            return astClasses.get(name);
        }
        Class<?> result = null;
        try {
            result = classLoader.loadClass("org.rascalmpl.semantics.dynamic." + name);
        }
        catch (ClassNotFoundException e) {
            result = classLoader.loadClass("org.rascalmpl.ast." + name);
        }
        astClasses.put(name, result);
        return result;
    }

    private static Constructor<?> getConstructor(String sort, String cons) {
        try {
            String name = sort + "$" + cons;
            Constructor<?> constructor = astConstructors.get(name);
            if (constructor == null) {
                Class<?> clazz = ASTBuilder.loadClass(name);
                constructor = clazz.getConstructors()[0];
                constructor.setAccessible(true);
                astConstructors.put(name, constructor);
            }
            return constructor;
        }
        catch (SecurityException e) {
            throw ASTBuilder.unexpectedError(e);
        }
        catch (IllegalArgumentException e) {
            throw ASTBuilder.unexpectedError(e);
        }
        catch (ClassNotFoundException e) {
            throw ASTBuilder.unexpectedError(e);
        }
    }

    private static AbstractAST callMakerMethod(String sort, String cons, Object[] actuals, Object[] keywordActuals) {
        try {
            return (AbstractAST)ASTBuilder.getConstructor(sort, cons).newInstance(actuals);
        }
        catch (SecurityException e) {
            throw ASTBuilder.unexpectedError(e);
        }
        catch (IllegalArgumentException e) {
            throw ASTBuilder.unexpectedError(e);
        }
        catch (IllegalAccessException e) {
            throw ASTBuilder.unexpectedError(e);
        }
        catch (InvocationTargetException e) {
            throw ASTBuilder.unexpectedError(e);
        }
        catch (InstantiationException e) {
            throw ASTBuilder.unexpectedError(e);
        }
    }

    private static AbstractAST callMakerMethod(Constructor<?> constructor, Object[] actuals, Object[] keywordActuals) {
        try {
            return (AbstractAST)constructor.newInstance(actuals);
        }
        catch (SecurityException e) {
            throw ASTBuilder.unexpectedError(e);
        }
        catch (IllegalArgumentException e) {
            throw ASTBuilder.unexpectedError(e);
        }
        catch (IllegalAccessException e) {
            throw ASTBuilder.unexpectedError(e);
        }
        catch (InvocationTargetException e) {
            throw ASTBuilder.unexpectedError(e);
        }
        catch (InstantiationException e) {
            throw ASTBuilder.unexpectedError(e);
        }
    }
}

