/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.util;

public class ObjectIntegerKeyedHashSet<E> {
    private Entry<E>[] entries;
    private int hashMask;
    private int bitSize = 2;
    private int threshold;
    private int load;

    public ObjectIntegerKeyedHashSet() {
        int nrOfEntries = 1 << this.bitSize;
        this.hashMask = nrOfEntries - 1;
        this.entries = new Entry[nrOfEntries];
        this.threshold = nrOfEntries;
        this.load = 0;
    }

    private void rehash() {
        int nrOfEntries = 1 << ++this.bitSize;
        int newHashMask = nrOfEntries - 1;
        Entry<E>[] oldEntries = this.entries;
        Entry[] newEntries = new Entry[nrOfEntries];
        Entry<Object> currentEntryRoot = new Entry<Object>(null, 0, 0, null);
        Entry<Object> shiftedEntryRoot = new Entry<Object>(null, 0, 0, null);
        int oldSize = oldEntries.length;
        for (int i = oldSize - 1; i >= 0; --i) {
            Entry<E> e = oldEntries[i];
            if (e == null) continue;
            Entry<Object> lastCurrentEntry = currentEntryRoot;
            Entry<Object> lastShiftedEntry = shiftedEntryRoot;
            int lastPosition = -1;
            do {
                int position;
                if ((position = e.hash & newHashMask) == i) {
                    if (position != lastPosition) {
                        lastCurrentEntry.next = e;
                    }
                    lastCurrentEntry = e;
                    continue;
                }
                if (position != lastPosition) {
                    lastShiftedEntry.next = e;
                }
                lastShiftedEntry = e;
            } while ((e = e.next) != null);
            lastCurrentEntry.next = null;
            lastShiftedEntry.next = null;
            newEntries[i] = currentEntryRoot.next;
            newEntries[i | oldSize] = shiftedEntryRoot.next;
        }
        this.threshold <<= 1;
        this.entries = newEntries;
        this.hashMask = newHashMask;
    }

    private void ensureCapacity() {
        if (this.load > this.threshold) {
            this.rehash();
        }
    }

    public boolean put(E element, int element2) {
        this.ensureCapacity();
        int hash = element.hashCode() ^ element2 << 5;
        int position = hash & this.hashMask;
        Entry<E> currentStartEntry = this.entries[position];
        if (currentStartEntry != null) {
            Entry<E> entry = currentStartEntry;
            do {
                if (hash != entry.hash || entry.element2 != element2 || !entry.element.equals(element)) continue;
                return false;
            } while ((entry = entry.next) != null);
        }
        this.entries[position] = new Entry<E>(element, element2, hash, currentStartEntry);
        ++this.load;
        return true;
    }

    public void putUnsafe(E element, int element2) {
        this.ensureCapacity();
        int hash = element.hashCode() ^ element2 << 5;
        int position = hash & this.hashMask;
        this.entries[position] = new Entry<E>(element, element2, hash, this.entries[position]);
        ++this.load;
    }

    public boolean remove(E element, int element2) {
        int hash = element.hashCode() ^ element2 << 5;
        int position = hash & this.hashMask;
        Entry<E> previous = null;
        Entry<E> currentStartEntry = this.entries[position];
        if (currentStartEntry != null) {
            Entry<E> entry = currentStartEntry;
            do {
                if (hash == entry.hash && entry.element2 == element2 && entry.element.equals(element)) {
                    if (previous == null) {
                        this.entries[position] = entry.next;
                    } else {
                        previous.next = entry.next;
                    }
                    --this.load;
                    return true;
                }
                previous = entry;
            } while ((entry = entry.next) != null);
        }
        return false;
    }

    public boolean contains(E element, int element2) {
        int hash = element.hashCode() ^ element2 << 5;
        int position = hash & this.hashMask;
        Entry<E> entry = this.entries[position];
        while (entry != null) {
            if (hash == entry.hash && element2 == entry.element2 && element.equals(entry.element)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public E getEquivalent(E element, int element2) {
        int hash = element.hashCode() ^ element2 << 5;
        int position = hash & this.hashMask;
        Entry<E> entry = this.entries[position];
        while (entry != null) {
            if (hash == entry.hash && element2 == entry.element2 && element.equals(entry.element)) {
                return entry.element;
            }
            entry = entry.next;
        }
        return null;
    }

    public void clear() {
        this.entries = new Entry[this.entries.length];
        this.load = 0;
    }

    private static class Entry<E> {
        public final int hash;
        public final E element;
        public final int element2;
        public Entry<E> next;

        public Entry(E element, int element2, int hash, Entry<E> next) {
            this.element = element;
            this.element2 = element2;
            this.hash = hash;
            this.next = next;
        }
    }
}

