/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.shell;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.function.Function;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.env.GlobalEnvironment;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.interpreter.load.StandardLibraryContributor;
import org.rascalmpl.interpreter.utils.RascalManifest;
import org.rascalmpl.library.Messages;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.classloaders.SourceLocationClassLoader;
import org.rascalmpl.uri.project.IDEProjectURIResolver;
import org.rascalmpl.uri.project.IDETargetURIResolver;
import org.rascalmpl.uri.project.ProjectURIResolver;
import org.rascalmpl.uri.project.TargetURIResolver;
import org.rascalmpl.values.ValueFactoryFactory;

public class ShellEvaluatorFactory {
    public static Evaluator getBasicEvaluator(Reader input, PrintWriter stdout, PrintWriter stderr, IRascalMonitor monitor) {
        return ShellEvaluatorFactory.getBasicEvaluator(input, stdout, stderr, monitor, "$");
    }

    public static Evaluator getBasicEvaluator(Reader input, PrintWriter stdout, PrintWriter stderr, IRascalMonitor monitor, String rootEnvironment) {
        GlobalEnvironment heap = new GlobalEnvironment();
        ModuleEnvironment root = heap.addModule(new ModuleEnvironment(rootEnvironment, heap));
        Evaluator evaluator = new Evaluator(ValueFactoryFactory.getValueFactory(), input, stderr, stdout, root, heap, monitor);
        evaluator.addRascalSearchPathContributor(StandardLibraryContributor.getInstance());
        return evaluator;
    }

    public static Evaluator getDefaultEvaluator(Reader input, PrintWriter stdout, PrintWriter stderr, IRascalMonitor monitor) {
        return ShellEvaluatorFactory.getDefaultEvaluator(input, stdout, stderr, monitor, "$");
    }

    public static Evaluator getDefaultEvaluator(Reader input, PrintWriter stdout, PrintWriter stderr, IRascalMonitor monitor, String rootEnvironment) {
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        if (!reg.getRegisteredInputSchemes().contains("project") && !reg.getRegisteredLogicalSchemes().contains("project")) {
            return ShellEvaluatorFactory.getDefaultEvaluatorForLocation(URIUtil.rootLocation("cwd"), input, stdout, stderr, monitor, rootEnvironment);
        }
        return ShellEvaluatorFactory.getBasicEvaluator(input, stdout, stderr, monitor, rootEnvironment);
    }

    public static Evaluator getDefaultEvaluatorForPathConfig(ISourceLocation projectRoot, PathConfig pcfg, Reader input, PrintWriter stdout, PrintWriter stderr, IRascalMonitor monitor) {
        ShellEvaluatorFactory.setupProjectResolver(projectRoot, monitor);
        return ShellEvaluatorFactory.getDefaultEvaluatorForPathConfig(projectRoot, pcfg, input, stdout, stderr, monitor, "$");
    }

    private static Evaluator getDefaultEvaluatorForPathConfig(ISourceLocation projectRoot, PathConfig pcfg, Reader input, PrintWriter stdout, PrintWriter stderr, IRascalMonitor monitor, String rootEnvironment) {
        Evaluator evaluator = ShellEvaluatorFactory.getBasicEvaluator(input, stdout, stderr, monitor, rootEnvironment);
        for (IValue srcPath : pcfg.getSrcs()) {
            evaluator.addRascalSearchPath((ISourceLocation)srcPath);
        }
        boolean isRascal = projectRoot != null && new RascalManifest().getProjectName(projectRoot).equals("rascal");
        IList libs = isRascal ? pcfg.getLibs() : pcfg.getLibsAndTarget();
        for (IValue lib : libs) {
            evaluator.addRascalSearchPath((ISourceLocation)lib);
        }
        evaluator.addClassLoader(new SourceLocationClassLoader(libs, ClassLoader.getSystemClassLoader()));
        return evaluator;
    }

    private static void setupProjectResolver(ISourceLocation projectRoot, IRascalMonitor monitor) {
        if (monitor instanceof IDEServices) {
            ShellEvaluatorFactory.registerProjectAndTargetResolver(((IDEServices)monitor)::resolveProjectLocation);
        } else {
            ShellEvaluatorFactory.registerProjectAndTargetResolver(projectRoot);
        }
    }

    public static Evaluator getDefaultEvaluatorForLocation(ISourceLocation projectFile, Reader input, PrintWriter stdout, PrintWriter stderr, IRascalMonitor monitor) {
        return ShellEvaluatorFactory.getDefaultEvaluatorForLocation(projectFile, input, stdout, stderr, monitor, "$");
    }

    public static Evaluator getDefaultEvaluatorForLocation(ISourceLocation projectFile, Reader input, PrintWriter stdout, PrintWriter stderr, IRascalMonitor monitor, String rootEnvironment) {
        ISourceLocation projectRoot = PathConfig.inferProjectRoot(projectFile);
        ShellEvaluatorFactory.setupProjectResolver(projectRoot, monitor);
        PathConfig pcfg = PathConfig.fromSourceProjectRascalManifest(projectRoot, PathConfig.RascalConfigMode.INTERPRETER, true);
        pcfg.reportConfigurationInfo();
        if (!pcfg.getMessages().isEmpty()) {
            Messages.write(pcfg.getMessages(), pcfg.getProjectRoot(), stdout);
        }
        return ShellEvaluatorFactory.getDefaultEvaluatorForPathConfig(projectRoot, pcfg, input, stdout, stderr, monitor, rootEnvironment);
    }

    private static void registerProjectAndTargetResolver(ISourceLocation projectFile) {
        String projectName;
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        ISourceLocation projectRoot = PathConfig.inferProjectRoot(projectFile);
        if (projectRoot != null && !(projectName = new RascalManifest().getProjectName(projectRoot)).equals("")) {
            reg.registerLogical(new ProjectURIResolver(projectRoot, projectName));
            reg.registerLogical(new TargetURIResolver(projectRoot, projectName));
        }
    }

    private static void registerProjectAndTargetResolver(Function<ISourceLocation, ISourceLocation> resolver) {
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        reg.registerLogical(new IDEProjectURIResolver(resolver));
        reg.registerLogical(new IDETargetURIResolver(resolver));
    }
}

