/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.unicode;

import java.io.IOException;
import java.io.InputStream;

class ConcatInputStream
extends InputStream {
    private final InputStream first;
    private boolean firstEmpty;
    private final InputStream second;

    public ConcatInputStream(InputStream first, InputStream second) {
        this.first = first;
        this.firstEmpty = false;
        this.second = second;
    }

    @Override
    public int read() throws IOException {
        if (!this.firstEmpty) {
            int firstResult = this.first.read();
            if (firstResult != -1) {
                return firstResult;
            }
            this.firstEmpty = true;
        }
        return this.second.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.firstEmpty) {
            int readTotal = this.first.read(b, off, len);
            if (readTotal == len) {
                return readTotal;
            }
            if (readTotal < 0) {
                readTotal = 0;
            }
            this.firstEmpty = true;
            int secondRead = this.second.read(b, off + readTotal, len - readTotal);
            if (readTotal == 0 && secondRead <= 0) {
                return -1;
            }
            if (secondRead < 0) {
                return readTotal;
            }
            return readTotal + secondRead;
        }
        return this.second.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        try {
            this.first.close();
        }
        catch (IOException e) {
            this.second.close();
            throw e;
        }
        this.second.close();
    }
}

