---
title: "module lang::std::tests::ASCII"
id: ASCII
slug: /Library/lang/std/tests/ASCII
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

#### Usage

```rascal
import lang::std::tests::ASCII;
```

#### Dependencies
```rascal
import lang::std::ASCII;
import Exception;
```


## syntax Ascii {#lang-std-tests-ASCII-Ascii}

```rascal
lexical Ascii = [\a00-\a7f];
```

# Tests
## test ascii1 {#lang-std-tests-ASCII-ascii1}

```rascal
test bool ascii1() = Ascii _ := [Ascii] "a";
```

## test alnum1 {#lang-std-tests-ASCII-alnum1}

```rascal
test bool alnum1() = Alnum _ := [Alnum] "A";
```

## test alnum2 {#lang-std-tests-ASCII-alnum2}

```rascal
test bool alnum2() = Alnum _ := [Alnum] "a";
```

## test alnum3 {#lang-std-tests-ASCII-alnum3}

```rascal
test bool alnum3() = Alnum _ := [Alnum] "0";
```

## test alpha1 {#lang-std-tests-ASCII-alpha1}

```rascal
test bool alpha1() = Alpha _ := [Alpha] "A";
```

## test alpha2 {#lang-std-tests-ASCII-alpha2}

```rascal
test bool alpha2() = Alpha _ := [Alpha] "a";
```

## test upper1 {#lang-std-tests-ASCII-upper1}

```rascal
test bool upper1() = Upper _ := [Upper] "A";
```

## test lower1 {#lang-std-tests-ASCII-lower1}

```rascal
test bool lower1() = Lower _ := [Lower] "a";
```

## test blank1 {#lang-std-tests-ASCII-blank1}

```rascal
test bool blank1() = Blank _ := [Blank] " ";
```

## test blank2 {#lang-std-tests-ASCII-blank2}

```rascal
test bool blank2() = Blank _ := [Blank] "\t";
```

## test ctrl1 {#lang-std-tests-ASCII-ctrl1}

```rascal
test bool ctrl1() = Ctrl _ := [Ctrl] "\a00";
```

## test ctrl2 {#lang-std-tests-ASCII-ctrl2}

```rascal
test bool ctrl2() = Ctrl _ := [Ctrl] "\a1f";
```

## test ctrl3 {#lang-std-tests-ASCII-ctrl3}

```rascal

test bool ctrl3() = Ctrl c := [Ctrl] "\a7f";
```

## test digit1 {#lang-std-tests-ASCII-digit1}

```rascal
test bool digit1() = Digit _ := [Digit] "0";
```

## test hexnumber1 {#lang-std-tests-ASCII-hexnumber1}

```rascal
test bool hexnumber1() = HexNumber _ := [HexNumber] "A";
```

## test hexnumber2 {#lang-std-tests-ASCII-hexnumber2}

```rascal
test bool hexnumber2() = HexNumber _ := [HexNumber] "F";
```

## test hexnumber3 {#lang-std-tests-ASCII-hexnumber3}

```rascal
test bool hexnumber3() = HexNumber _ := [HexNumber] "a";
```

## test hexnumber4 {#lang-std-tests-ASCII-hexnumber4}

```rascal
test bool hexnumber4() = HexNumber _ := [HexNumber] "f";
```

## test hexnumber5 {#lang-std-tests-ASCII-hexnumber5}

```rascal
test bool hexnumber5() = HexNumber _ := [HexNumber] "0";
```

## test hexnumber6 {#lang-std-tests-ASCII-hexnumber6}

```rascal
test bool hexnumber6() = HexNumber _ := [HexNumber] "9";
```

## test hexnumber7 {#lang-std-tests-ASCII-hexnumber7}

```rascal

test bool hexnumber7() = HexNumber _ := [HexNumber] "G";
```

## test hexnumber8 {#lang-std-tests-ASCII-hexnumber8}

```rascal

test bool hexnumber8() = HexNumber _ := [HexNumber] "g";
```

## test space1 {#lang-std-tests-ASCII-space1}

```rascal
test bool space1() = Space _ := [Space] "\t";
```

## test space2 {#lang-std-tests-ASCII-space2}

```rascal
test bool space2() = Space _ := [Space] "\n";
```

## test space3 {#lang-std-tests-ASCII-space3}

```rascal
test bool space3() = Space _ := [Space] "\a0B";
```

## test space4 {#lang-std-tests-ASCII-space4}

```rascal
test bool space4() = Space _ := [Space] "\a0C";
```

## test space5 {#lang-std-tests-ASCII-space5}

```rascal
test bool space5() = Space _ := [Space] "\r";
```

## test space6 {#lang-std-tests-ASCII-space6}

```rascal
test bool space6() = Space _ := [Space] " ";
```

