/*
 * Decompiled with CFR 0.152.
 */
package engineering.swat.watch.impl.jdk;

import engineering.swat.watch.WatchEvent;
import engineering.swat.watch.WatchScope;
import engineering.swat.watch.impl.EventHandlingWatch;
import engineering.swat.watch.impl.jdk.JDKBaseWatch;
import engineering.swat.watch.impl.jdk.JDKDirectoryWatch;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JDKFileTreeWatch
extends JDKBaseWatch {
    private final Logger logger = LogManager.getLogger();
    private final Path rootPath;
    private final Path relativePathParent;
    private final Map<Path, JDKFileTreeWatch> childWatches = new ConcurrentHashMap<Path, JDKFileTreeWatch>();
    private final JDKDirectoryWatch internal;

    public JDKFileTreeWatch(Path fullPath, Executor exec, BiConsumer<EventHandlingWatch, WatchEvent> eventHandler, Predicate<WatchEvent> eventFilter) {
        this(fullPath, Path.of("", new String[0]), exec, eventHandler, eventFilter);
    }

    public JDKFileTreeWatch(final Path rootPath, final Path relativePathParent, Executor exec, BiConsumer<EventHandlingWatch, WatchEvent> eventHandler, Predicate<WatchEvent> eventFilter) {
        super(rootPath.resolve(relativePathParent), exec, eventHandler, eventFilter);
        this.rootPath = rootPath;
        this.relativePathParent = relativePathParent;
        BiConsumer<EventHandlingWatch, WatchEvent> internalEventHandler = eventHandler.andThen(new AsyncChildWatchesUpdater());
        this.internal = new JDKDirectoryWatch(this.path, exec, internalEventHandler, eventFilter){

            @Override
            public WatchEvent relativize(WatchEvent event) {
                assert (Objects.equals(event.calculateFullPath().getParent(), rootPath.resolve(relativePathParent)));
                Path fileName = event.getFileName();
                return new WatchEvent(event.getKind(), rootPath, fileName == null ? relativePathParent : relativePathParent.resolve(fileName));
            }

            @Override
            protected WatchEvent translate(java.nio.file.WatchEvent<?> jdkEvent) {
                Path child;
                WatchEvent.Kind kind = this.translate(jdkEvent.kind());
                Path relativePath = null;
                if (kind != WatchEvent.Kind.OVERFLOW && (child = (Path)jdkEvent.context()) != null) {
                    relativePath = relativePathParent.resolve(child);
                }
                WatchEvent event = new WatchEvent(kind, rootPath, relativePath);
                JDKFileTreeWatch.this.logger.trace("Translated: {} to {}", (Object)jdkEvent, (Object)event);
                return event;
            }
        };
    }

    private void syncChildWatchesWithFileSystem() {
        HashSet<Path> toBeClosed = new HashSet<Path>(this.childWatches.keySet());
        try (Stream<Path> children = Files.find(this.path, 1, (p, attrs) -> p != this.path && attrs.isDirectory(), new FileVisitOption[0]);){
            children.forEach(p -> {
                Path child = p.getFileName();
                if (child != null) {
                    toBeClosed.remove(child);
                    this.openChildWatch(child);
                } else {
                    this.logger.error("File tree watch (for: {}) could not open a child watch for: {}", (Object)this.path, p);
                }
            });
        }
        catch (IOException e) {
            this.logger.error("File tree watch (for: {}) could not iterate over its children ({})", (Object)this.path, (Object)e);
        }
        for (Path child : toBeClosed) {
            this.tryCloseChildWatch(child);
        }
    }

    private @Nullable JDKFileTreeWatch openChildWatch(Path child) {
        assert (!child.isAbsolute());
        Function<Path, JDKFileTreeWatch> newChildWatch = p -> new JDKFileTreeWatch(this.rootPath, this.relativePathParent.resolve(child), this.exec, this.eventHandler, this.eventFilter);
        JDKFileTreeWatch childWatch = this.childWatches.computeIfAbsent(child, newChildWatch);
        if (this.internal.isClosed()) {
            this.tryClose(childWatch);
            return null;
        }
        try {
            childWatch.startIfFirstTime();
        }
        catch (IOException e) {
            this.logger.error("Could not open (nested) file tree watch for: {} ({})", (Object)child, (Object)e);
        }
        return childWatch;
    }

    private void tryCloseChildWatch(Path child) {
        try {
            this.closeChildWatch(child);
        }
        catch (IOException e) {
            this.logger.error("Could not close (nested) file tree watch for: {} ({})", (Object)this.path.resolve(child), (Object)e);
        }
    }

    private void closeChildWatch(Path child) throws IOException {
        assert (!child.isAbsolute());
        JDKFileTreeWatch childWatch = this.childWatches.remove(child);
        if (childWatch != null) {
            childWatch.close();
        }
    }

    private @Nullable IOException tryClose(Closeable c) {
        try {
            c.close();
            return null;
        }
        catch (IOException ex) {
            this.logger.error("Could not close watch", (Throwable)ex);
            return ex;
        }
        catch (Exception ex) {
            this.logger.error("Could not close watch", (Throwable)ex);
            return new IOException("Unexpected exception when closing", ex);
        }
    }

    @Override
    public WatchScope getScope() {
        return WatchScope.PATH_AND_ALL_DESCENDANTS;
    }

    @Override
    public void handleEvent(WatchEvent event) {
        this.internal.handleEvent(event);
    }

    @Override
    public synchronized void close() throws IOException {
        IOException firstFail = this.tryClose(this.internal);
        for (JDKFileTreeWatch c : this.childWatches.values()) {
            IOException currentFail = this.tryClose(c);
            if (currentFail == null || firstFail != null) continue;
            firstFail = currentFail;
        }
        if (firstFail != null) {
            throw firstFail;
        }
    }

    @Override
    protected synchronized void start() throws IOException {
        this.internal.open();
        this.syncChildWatchesWithFileSystem();
    }

    private class AsyncChildWatchesUpdater
    implements BiConsumer<EventHandlingWatch, WatchEvent> {
        private AsyncChildWatchesUpdater() {
        }

        @Override
        public void accept(EventHandlingWatch watch, WatchEvent event) {
            JDKFileTreeWatch.this.exec.execute(() -> {
                switch (event.getKind()) {
                    case OVERFLOW: {
                        this.acceptOverflow();
                        break;
                    }
                    case CREATED: {
                        this.getFileNameAndThen(event, this::acceptCreated);
                        break;
                    }
                    case DELETED: {
                        this.getFileNameAndThen(event, this::acceptDeleted);
                        break;
                    }
                }
            });
        }

        private void getFileNameAndThen(WatchEvent event, Consumer<Path> consumer) {
            Path child = event.getFileName();
            if (child != null) {
                consumer.accept(child);
            } else {
                JDKFileTreeWatch.this.logger.error("Could not get file name of event: {}", (Object)event);
            }
        }

        private void acceptOverflow() {
            JDKFileTreeWatch.this.syncChildWatchesWithFileSystem();
            for (JDKFileTreeWatch childWatch : JDKFileTreeWatch.this.childWatches.values()) {
                this.reportOverflowTo(childWatch);
            }
        }

        private void acceptCreated(Path child) {
            JDKFileTreeWatch childWatch;
            if (Files.isDirectory(JDKFileTreeWatch.this.path.resolve(child), new LinkOption[0]) && (childWatch = JDKFileTreeWatch.this.openChildWatch(child)) != null) {
                this.reportOverflowTo(childWatch);
            }
        }

        private void acceptDeleted(Path child) {
            JDKFileTreeWatch.this.tryCloseChildWatch(child);
        }

        private void reportOverflowTo(JDKFileTreeWatch childWatch) {
            WatchEvent overflow = new WatchEvent(WatchEvent.Kind.OVERFLOW, childWatch.rootPath, childWatch.relativePathParent);
            childWatch.handleEvent(overflow);
        }
    }
}

