/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io.binary.util;

import io.usethesource.vallang.io.binary.util.ArrayUtil;
import io.usethesource.vallang.io.binary.util.ClearableWindow;
import io.usethesource.vallang.io.binary.util.TrackLastRead;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LinearCircularLookupWindow<T>
implements TrackLastRead<T>,
ClearableWindow {
    private @Nullable T[] data;
    private long written;
    private final int maxSize;

    public LinearCircularLookupWindow(int size) {
        this.data = new Object[Math.min(512, size)];
        this.written = 0L;
        this.maxSize = size + 1;
    }

    private int translate(long index) {
        return (int)(index % (long)this.data.length);
    }

    @Override
    public T lookBack(int offset) {
        assert ((long)(offset + 1) <= this.written && offset < this.maxSize);
        @Nullable T result = this.data[this.translate(this.written - (long)(offset + 1))];
        if (result == null) {
            throw new RuntimeException("Lookback of " + offset + "was invalid");
        }
        return result;
    }

    @Override
    public void read(T obj) {
        this.growIfNeeded();
        this.data[this.translate((long)this.written++)] = obj;
    }

    private void growIfNeeded() {
        if (this.written <= (long)this.maxSize && this.written == (long)this.data.length && this.data.length != this.maxSize) {
            this.data = Arrays.copyOf(this.data, Math.min(this.data.length * 2, this.maxSize));
        }
    }

    @Override
    public int size() {
        return this.maxSize;
    }

    @Override
    public void clear() {
        ArrayUtil.fill(this.data, null);
    }
}

