/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Type;
import org.rascalmpl.ast.Variable;

public abstract class Declarator
extends AbstractAST {
    public Declarator(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasVariables() {
        return false;
    }

    public List<Variable> getVariables() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasType() {
        return false;
    }

    public Type getType() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isDefault() {
        return false;
    }

    public static class Default
    extends Declarator {
        private final Type type;
        private final List<Variable> variables;

        public Default(ISourceLocation src, IConstructor node, Type type, List<Variable> variables) {
            super(src, node);
            this.type = type;
            this.variables = variables;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitDeclaratorDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.type.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.type.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.variables) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return tmp.type.equals(this.type) && tmp.variables.equals(this.variables);
        }

        @Override
        public int hashCode() {
            return 257 + 307 * this.type.hashCode() + 577 * this.variables.hashCode();
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public boolean hasType() {
            return true;
        }

        @Override
        public List<Variable> getVariables() {
            return this.variables;
        }

        @Override
        public boolean hasVariables() {
            return true;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null, this.clone(this.type), this.clone(this.variables));
        }
    }
}

