/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.exceptions.UndeclaredFieldException;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeStore;
import org.rascalmpl.ast.Field;
import org.rascalmpl.ast.Name;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.result.ElementResult;
import org.rascalmpl.interpreter.result.LessThanOrEqualResult;
import org.rascalmpl.interpreter.result.ListRelationResult;
import org.rascalmpl.interpreter.result.RelationResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.UndeclaredField;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;
import org.rascalmpl.interpreter.staticErrors.UnsupportedSubscript;
import org.rascalmpl.interpreter.staticErrors.UnsupportedSubscriptArity;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.values.ValueFactoryFactory;

public class TupleResult
extends ElementResult<ITuple> {
    public TupleResult(Type type, ITuple tuple, IEvaluatorContext ctx) {
        super(type, tuple, ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> add(Result<V> that) {
        return that.addTuple(this);
    }

    @Override
    public Result<IValue> fieldSelect(int[] selectedFields) {
        return ResultFactory.makeResult(this.type.select(selectedFields), ((ITuple)this.value).select(selectedFields), this.ctx);
    }

    @Override
    public Result<IBool> isKeyDefined(Result<?>[] subscripts) {
        if (subscripts.length != 1) {
            throw new UnsupportedSubscriptArity(this.getStaticType(), subscripts.length, this.ctx.getCurrentAST());
        }
        Result<?> key = subscripts[0];
        if (!key.getStaticType().isSubtypeOf(this.getTypeFactory().integerType())) {
            throw new UnexpectedType(this.getTypeFactory().integerType(), key.getStaticType(), this.ctx.getCurrentAST());
        }
        int idx = ((IInteger)key.getValue()).intValue();
        int len = ((ITuple)this.getValue()).arity();
        if (idx >= 0 && idx >= len || idx < 0 && idx < -len) {
            return ResultFactory.makeResult(this.getTypeFactory().boolType(), this.getValueFactory().bool(false), this.ctx);
        }
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), this.getValueFactory().bool(true), this.ctx);
    }

    @Override
    public Result<IBool> isDefined(Name name) {
        if (this.type.hasField(Names.name(name))) {
            return ResultFactory.makeResult(this.getTypeFactory().boolType(), this.getValueFactory().bool(true), this.ctx);
        }
        throw new UndeclaredField(Names.name(name), this.getStaticType(), this.ctx.getCurrentAST());
    }

    @Override
    public Result<IValue> fieldSelect(Field[] selectedFields) {
        int nFields = selectedFields.length;
        int[] fieldIndices = new int[nFields];
        Type baseType = this.getStaticType();
        for (int i = 0; i < nFields; ++i) {
            Field f = selectedFields[i];
            if (f.isIndex()) {
                fieldIndices[i] = ((IInteger)f.getFieldIndex().interpret(this.ctx.getEvaluator()).getValue()).intValue();
            } else {
                String fieldName = Names.name(f.getFieldName());
                try {
                    fieldIndices[i] = baseType.getFieldIndex(fieldName);
                }
                catch (UndeclaredFieldException e) {
                    throw new UndeclaredField(fieldName, baseType, this.ctx.getCurrentAST());
                }
            }
            if (fieldIndices[i] >= 0 && fieldIndices[i] <= baseType.getArity()) continue;
            throw RuntimeExceptionFactory.indexOutOfBounds(ValueFactoryFactory.getValueFactory().integer(fieldIndices[i]), this.ctx.getCurrentAST(), this.ctx.getStackTrace());
        }
        return this.fieldSelect(fieldIndices);
    }

    @Override
    public Result<IBool> has(Name name) {
        return ResultFactory.bool(this.getStaticType().hasField(Names.name(name)), this.ctx);
    }

    @Override
    public <U extends IValue> Result<U> fieldAccess(String name, TypeStore store) {
        if (!this.getStaticType().hasFieldNames()) {
            throw new UndeclaredField(name, this.getStaticType(), this.ctx.getCurrentAST());
        }
        if (!this.getStaticType().hasField(name, store)) {
            throw new UndeclaredField(name, this.getStaticType(), this.ctx.getCurrentAST());
        }
        try {
            int index = this.getStaticType().getFieldIndex(name);
            Type type = this.getStaticType().getFieldType(index);
            return ResultFactory.makeResult(type, ((ITuple)this.getValue()).get(index), this.ctx);
        }
        catch (UndeclaredFieldException e) {
            throw new UndeclaredField(name, this.getStaticType(), this.ctx.getCurrentAST());
        }
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> fieldUpdate(String name, Result<V> repl, TypeStore store) {
        if (!this.getStaticType().hasFieldNames()) {
            throw new UndeclaredField(name, this.getStaticType(), this.ctx.getCurrentAST());
        }
        try {
            int index = this.getStaticType().getFieldIndex(name);
            Type type = this.getStaticType().getFieldType(index);
            if (!type.isSubtypeOf(repl.getStaticType())) {
                throw new UnexpectedType(type, repl.getStaticType(), this.ctx.getCurrentAST());
            }
            return ResultFactory.makeResult(this.getStaticType(), ((ITuple)this.getValue()).set(index, (IValue)repl.getValue()), this.ctx);
        }
        catch (UndeclaredFieldException e) {
            throw new UndeclaredField(name, this.getStaticType(), this.ctx.getCurrentAST());
        }
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> subscript(Result<?>[] subscripts) {
        if (subscripts.length > 1) {
            throw new UnsupportedSubscriptArity(this.getStaticType(), subscripts.length, this.ctx.getCurrentAST());
        }
        Result<?> subsBase = subscripts[0];
        if (subsBase == null) {
            throw new UnsupportedSubscript(this.type, null, this.ctx.getCurrentAST());
        }
        if (!subsBase.getStaticType().isInteger()) {
            throw new UnsupportedSubscript(this.getTypeFactory().integerType(), subsBase.getStaticType(), this.ctx.getCurrentAST());
        }
        IInteger index = (IInteger)subsBase.getValue();
        int idx = index.intValue();
        if (idx < 0) {
            idx += ((ITuple)this.getValue()).arity();
        }
        if (idx >= ((ITuple)this.getValue()).arity() || idx < 0) {
            throw RuntimeExceptionFactory.indexOutOfBounds(index, this.ctx.getCurrentAST(), this.ctx.getStackTrace());
        }
        Type elementType = this.getStaticType().getFieldType(idx);
        IValue element = ((ITuple)this.getValue()).get(idx);
        return ResultFactory.makeResult(elementType, element, this.ctx);
    }

    @Override
    public <V extends IValue> Result<IBool> equals(Result<V> that) {
        return that.equalToTuple(this);
    }

    @Override
    public <V extends IValue> Result<IBool> nonEquals(Result<V> that) {
        return that.nonEqualToTuple(this);
    }

    @Override
    public <V extends IValue> Result<IBool> lessThan(Result<V> result) {
        return result.lessThanTuple(this);
    }

    @Override
    public <V extends IValue> LessThanOrEqualResult lessThanOrEqual(Result<V> result) {
        return result.lessThanOrEqualTuple(this);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThan(Result<V> result) {
        return result.greaterThanTuple(this);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThanOrEqual(Result<V> result) {
        return result.greaterThanOrEqualTuple(this);
    }

    @Override
    protected <U extends IValue> Result<U> addTuple(TupleResult that) {
        int i;
        TupleResult left = that;
        TupleResult right = this;
        Type leftType = left.getStaticType();
        Type rightType = right.getStaticType();
        int leftArity = leftType.getArity();
        int rightArity = rightType.getArity();
        int newArity = leftArity + rightArity;
        Type[] fieldTypes = new Type[newArity];
        IValue[] fieldValues = new IValue[newArity];
        for (i = 0; i < leftArity; ++i) {
            fieldTypes[i] = leftType.getFieldType(i);
            fieldValues[i] = ((ITuple)left.getValue()).get(i);
        }
        for (i = 0; i < rightArity; ++i) {
            fieldTypes[leftArity + i] = rightType.getFieldType(i);
            fieldValues[leftArity + i] = ((ITuple)right.getValue()).get(i);
        }
        ITuple newValue = this.getValueFactory().tuple(fieldValues);
        if (leftType.hasFieldNames() && rightType.hasFieldNames()) {
            int i2;
            String[] fieldNames = new String[newArity];
            boolean consistentLabels = true;
            for (i2 = 0; i2 < leftArity; ++i2) {
                fieldNames[i2] = leftType.getFieldName(i2);
            }
            block3: for (i2 = 0; i2 < rightArity; ++i2) {
                fieldNames[leftArity + i2] = rightType.getFieldName(i2);
                if (!consistentLabels) continue;
                for (int j = 0; j < leftArity; ++j) {
                    if (!fieldNames[j].equals(fieldNames[leftArity + i2])) continue;
                    consistentLabels = false;
                    break block3;
                }
            }
            if (consistentLabels) {
                return ResultFactory.makeResult(this.getTypeFactory().tupleType(fieldTypes, fieldNames), newValue, this.ctx);
            }
        }
        return ResultFactory.makeResult(this.getTypeFactory().tupleType(fieldTypes), newValue, this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> addRelation(RelationResult that) {
        return that.insertTuple(this);
    }

    @Override
    protected <U extends IValue> Result<U> subtractRelation(RelationResult that) {
        if (that.getStaticType().getElementType().getArity() == this.getStaticType().getArity()) {
            return that.removeElement(this);
        }
        return super.subtractRelation(that);
    }

    @Override
    protected <U extends IValue> Result<U> addListRelation(ListRelationResult that) {
        return that.appendTuple(this);
    }

    @Override
    protected <U extends IValue> Result<U> subtractListRelation(ListRelationResult that) {
        if (that.getStaticType().getElementType().getArity() == this.getStaticType().getArity()) {
            return that.removeElement(this);
        }
        return super.subtractListRelation(that);
    }

    @Override
    protected Result<IBool> equalToTuple(TupleResult that) {
        return that.equalityBoolean(this);
    }

    @Override
    protected Result<IBool> nonEqualToTuple(TupleResult that) {
        return that.nonEqualityBoolean(this);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualTuple(TupleResult that) {
        return that.lessThanOrEqualTuple(this);
    }

    @Override
    protected Result<IBool> greaterThanTuple(TupleResult that) {
        LessThanOrEqualResult loe = that.lessThanOrEqualTuple(this);
        return loe.isLess();
    }

    @Override
    protected Result<IBool> lessThanTuple(TupleResult that) {
        LessThanOrEqualResult loe = this.lessThanOrEqualTuple(that);
        return loe.isLess();
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualTuple(TupleResult that) {
        ITuple left = (ITuple)that.getValue();
        int leftArity = left.arity();
        ITuple right = (ITuple)this.getValue();
        int rightArity = right.arity();
        for (int i = 0; i < Math.min(leftArity, rightArity); ++i) {
            IValue leftArg = left.get(i);
            IValue rightArg = right.get(i);
            LessThanOrEqualResult loe = ResultFactory.makeResult(leftArg.getType(), leftArg, this.ctx).lessThanOrEqual(ResultFactory.makeResult(rightArg.getType(), rightArg, this.ctx));
            if (loe.getLess()) {
                return loe;
            }
            if (loe.getEqual()) continue;
            return new LessThanOrEqualResult(false, false, this.ctx);
        }
        return new LessThanOrEqualResult(leftArity < rightArity, leftArity == rightArity, this.ctx);
    }
}

