/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.utils;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.io.StandardTextWriter;
import io.usethesource.vallang.type.Type;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import org.rascalmpl.exceptions.StackTrace;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.asserts.Ambiguous;
import org.rascalmpl.interpreter.control_exceptions.InterruptException;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.staticErrors.StaticError;
import org.rascalmpl.interpreter.utils.LimitedResultWriter;
import org.rascalmpl.parser.gtd.exception.ParseError;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class ReadEvalPrintDialogMessages {
    public static final String PROMPT = "rascal>";
    public static final String CONTINUE_PROMPT = ">>>>>>>";
    public static final String CANCELLED = "cancelled";

    public static String resultMessage(Result<IValue> result) {
        Object content;
        IValue value = result.getValue();
        if (value != null) {
            Type type = result.getStaticType();
            if (type.isAbstractData() && type.isSubtypeOf(RascalValueFactory.Tree)) {
                content = type.toString() + ": `" + TreeAdapter.yield((IConstructor)value, 1000) + "`\n";
                StandardTextWriter stw = new StandardTextWriter(false);
                LimitedResultWriter lros = new LimitedResultWriter(1000);
                try {
                    stw.write(value, lros);
                }
                catch (RuntimeException runtimeException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                content = (String)content + "Tree: " + lros.toString();
            } else {
                content = result.toString(4096) + "\n";
            }
        } else {
            content = "ok\n";
        }
        return content;
    }

    public static void parseErrorMessage(PrintWriter content, String command, String scheme, ParseError pe, StandardTextWriter writer) {
        if (pe.getLocation().getScheme().equals(scheme)) {
            String[] commandLines = command.split("\n");
            int lastLine = commandLines.length;
            int lastColumn = commandLines[lastLine - 1].length();
            if (pe.getEndLine() + 1 != lastLine || lastColumn > pe.getEndColumn()) {
                int i;
                for (i = 0; i < pe.getEndColumn() + PROMPT.length(); ++i) {
                    content.append(' ');
                }
                content.append('^');
                content.append(' ');
                content.append("Parse error here");
                if (i > 80) {
                    content.append("\nParse error at column ");
                    content.append("" + pe.getEndColumn());
                }
                content.append("\n");
            }
        } else {
            ReadEvalPrintDialogMessages.printSourceLocation(content, pe.getLocation(), writer);
            content.println(": Parse error");
        }
        content.flush();
    }

    public static String interruptedExceptionMessage(InterruptException i) {
        String content = i.getMessage();
        return content;
    }

    public static String ambiguousMessage(Ambiguous e) {
        StringBuilder content = new StringBuilder();
        content.append(e.getLocation());
        content.append(':');
        content.append(' ');
        content.append(e.getMessage());
        content.append('\t');
        ITree tree = e.getTree();
        if (tree != null) {
            content.append("diagnose using: ");
            content.append(ReadEvalPrintDialogMessages.getValueString(e.getTree()));
        }
        content.append('\n');
        return content.toString();
    }

    private static String getValueString(IConstructor tree) {
        String val = tree.toString();
        val = val.replaceAll("\\\\", Matcher.quoteReplacement("\\\\"));
        val = val.replaceAll("\"", Matcher.quoteReplacement("\\\""));
        val = val.replaceAll("<", Matcher.quoteReplacement("\\<"));
        val = val.replaceAll(">", Matcher.quoteReplacement("\\>"));
        return "\"" + val + "\"";
    }

    public static void throwableMessage(PrintWriter out, Throwable e, StackTrace rascalTrace, StandardTextWriter prettyPrinter) {
        out.println(e.toString());
        out.println("(internal error)");
        try {
            rascalTrace.prettyPrintedString(out, prettyPrinter);
            out.println();
        }
        catch (IOException e1) {
            out.println("Error printing stack trace");
        }
        e.printStackTrace(out);
        out.println();
        out.flush();
    }

    public static void parseOrStaticOrThrowMessage(PrintWriter out, RuntimeException e, StandardTextWriter prettyPrinter) {
        if (e instanceof ParseError) {
            ReadEvalPrintDialogMessages.parseErrorMessage(out, "unknown", "unknown", (ParseError)e, prettyPrinter);
        } else if (e instanceof StaticError) {
            ReadEvalPrintDialogMessages.staticErrorMessage(out, (StaticError)e, prettyPrinter);
        } else if (e instanceof Throw) {
            ReadEvalPrintDialogMessages.throwMessage(out, (Throw)e, prettyPrinter);
        } else {
            out.write("Not a rascal exception: " + e.toString());
        }
    }

    public static void throwMessage(PrintWriter out, Throw e, StandardTextWriter prettyPrinter) {
        LimitedResultWriter lros = new LimitedResultWriter(1000);
        try {
            if (e.getException() != null) {
                prettyPrinter.write(e.getException(), lros);
            }
        }
        catch (RuntimeException runtimeException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ISourceLocation loc = e.getLocation();
        if (loc != null) {
            ReadEvalPrintDialogMessages.printSourceLocation(out, loc, prettyPrinter);
            out.print(": ");
        } else {
            out.print("unknown location: ");
        }
        out.println(lros.getBuffer().toString());
        StackTrace trace = e.getTrace();
        if (trace != null) {
            try {
                trace.prettyPrintedString(out, prettyPrinter);
            }
            catch (IOException e1) {
                out.println("Error printing stacktrace");
            }
        }
    }

    private static void printSourceLocation(PrintWriter out, ISourceLocation l, StandardTextWriter prettyPrinter) {
        try {
            prettyPrinter.write(l, out);
        }
        catch (IOException ex) {
            out.print("Error printing location");
        }
    }

    public static void staticErrorMessage(PrintWriter out, StaticError e, StandardTextWriter writer) {
        ReadEvalPrintDialogMessages.printSourceLocation(out, e.getLocation(), writer);
        out.print(": ");
        out.println(e.getMessage());
        out.flush();
    }
}

