/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.classloaders;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.rascalmpl.uri.URIResolverRegistry;

public class SourceLocationClassLoader
extends ClassLoader {
    private final List<ClassLoader> path;
    private final Stack<SearchItem> stack = new Stack();

    public SourceLocationClassLoader(IList classpath, ClassLoader parent) {
        super(parent);
        this.path = this.initialize(classpath);
    }

    public SourceLocationClassLoader(List<ISourceLocation> classpath, ClassLoader parent) {
        super(parent);
        this.path = this.initialize(classpath);
    }

    private List<ClassLoader> initialize(Iterable<? extends IValue> locs) {
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        ArrayList<URL> fileLocations = new ArrayList<URL>(10);
        ArrayList<ClassLoader> result = new ArrayList<ClassLoader>(10);
        for (IValue iValue : locs) {
            try {
                ISourceLocation loc = reg.logicalToPhysical((ISourceLocation)iValue);
                ClassLoader loader = reg.getClassLoader(loc, this);
                if (loader instanceof URLClassLoader) {
                    for (URL url : ((URLClassLoader)loader).getURLs()) {
                        fileLocations.add(url);
                    }
                    continue;
                }
                result.add(loader);
            }
            catch (IOException iOException) {}
        }
        if (!fileLocations.isEmpty()) {
            result.add(new URLClassLoader(fileLocations.toArray(new URL[0]), (ClassLoader)this));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader l : this.path) {
            Class<?> clazz;
            SearchItem item = new SearchItem(l, name);
            if (this.stack.contains(item)) continue;
            try {
                this.stack.push(item);
                clazz = l.loadClass(name);
                this.stack.pop();
            }
            catch (Throwable throwable) {
                try {
                    this.stack.pop();
                    throw throwable;
                }
                catch (ClassNotFoundException e) {}
            }
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (ClassLoader l : this.path) {
            try {
                return l.loadClass(name);
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String name) {
        if (this.stack.contains(new SearchItem(this, name))) {
            return null;
        }
        for (ClassLoader l : this.path) {
            try {
                this.stack.push(new SearchItem(this, name));
                URL url = l.getResource(name);
                if (url == null) continue;
                URL uRL = url;
                return uRL;
            }
            finally {
                this.stack.pop();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        final ArrayList<URL> result = new ArrayList<URL>(this.path.size());
        for (ClassLoader l : this.path) {
            SearchItem item = new SearchItem(l, name);
            if (this.stack.contains(item)) continue;
            try {
                this.stack.push(item);
                Enumeration<URL> e = l.getResources(name);
                while (e.hasMoreElements()) {
                    result.add(e.nextElement());
                }
            }
            finally {
                this.stack.pop();
            }
        }
        return new Enumeration<URL>(){
            final Iterator<URL> it;
            {
                this.it = result.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.it.next();
            }
        };
    }

    private static class SearchItem {
        private final ClassLoader loader;
        private final String className;

        public SearchItem(ClassLoader loader, String className) {
            this.loader = loader;
            this.className = className;
        }

        public boolean equals(Object obj) {
            if (obj.getClass().equals(this.getClass())) {
                SearchItem other = (SearchItem)obj;
                return other.loader == this.loader && other.className.equals(this.className);
            }
            return false;
        }

        public int hashCode() {
            return 17 + 7 * this.loader.hashCode() + 19 * this.className.hashCode();
        }
    }
}

