/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.locations;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import io.usethesource.vallang.ISourceLocation;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.rascalmpl.uri.ISourceLocationWatcher;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.util.Func;
import org.rascalmpl.util.locations.LineColumnOffsetMap;
import org.rascalmpl.util.locations.impl.ArrayLineOffsetMap;

public class ColumnMaps {
    private final LoadingCache<ISourceLocation, LineColumnOffsetMap> currentEntries;
    private final Map<ISourceLocation, Consumer<ISourceLocationWatcher.ISourceLocationChanged>> activeWatches = new ConcurrentHashMap<ISourceLocation, Consumer<ISourceLocationWatcher.ISourceLocationChanged>>();

    public ColumnMaps(Func<ISourceLocation, String, IOException> getContents) {
        this.currentEntries = Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).softValues().removalListener((loc, ignored, cause) -> {
            if (cause != RemovalCause.REPLACED) {
                this.unwatch((ISourceLocation)loc);
            }
        }).build(l -> {
            String contents = (String)getContents.apply((ISourceLocation)l);
            this.watch((ISourceLocation)l);
            return ArrayLineOffsetMap.build(contents);
        });
    }

    private void watch(ISourceLocation l) {
        Consumer<ISourceLocationWatcher.ISourceLocationChanged> clearEntry = c -> this.clear(l);
        if (this.activeWatches.putIfAbsent(l, clearEntry) == null) {
            try {
                URIResolverRegistry.getInstance().watch(l, false, clearEntry);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void unwatch(ISourceLocation k) {
        Consumer<ISourceLocationWatcher.ISourceLocationChanged> callback = this.activeWatches.remove(k);
        if (callback != null) {
            try {
                URIResolverRegistry.getInstance().unwatch(k, false, callback);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public LineColumnOffsetMap get(ISourceLocation sloc) {
        LineColumnOffsetMap map = this.currentEntries.get(sloc.top());
        if (map == null) {
            throw new RuntimeException("Location could not be read: " + sloc);
        }
        return map;
    }

    public void clear(ISourceLocation sloc) {
        this.currentEntries.invalidate(sloc.top());
    }
}

