/*
 * Copyright (c) 2025, Swat.engineering
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package org.rascalmpl.uri;

public class FileAttributes {
	private final boolean exists;
	private final boolean isFile;
	private final long created;
	private final long lastModified;
	private final boolean isWritable;
	private final boolean isReadable;
	private final long size;

	public FileAttributes(boolean exists, boolean isFile, long created, long lastModified, boolean isReadable, boolean isWritable, long size) {
		this.exists = exists;
		this.isFile = isFile;
		this.created = created;
		this.lastModified = lastModified;
		this.isReadable = isReadable;
		this.isWritable = isWritable;
		this.size = size;
	}

	public boolean exists() { return exists; }
	public boolean isFile() { return isFile; }
	public long created() { return created; }
	public long lastModified() { return lastModified; }
	public boolean isReadable() { return isReadable; }
	public boolean isWritable() { return isWritable; }
	/**
	 * internal use only, size in bytes and does not corresponds to Rascal's unicode codepoint
	 */
	public long size() { return size; }
}